(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8678,        308]
NotebookOptionsPosition[      5766,        219]
NotebookOutlinePosition[      6879,        249]
CellTagsIndexPosition[      6836,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Data Formats", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can efficiently exchange data in all standard numerical \
formats\[LongDash]allowing convenient symbolic specification of data subsets \
and data elements."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " comma separated values"
}], "GuideText",
 CellID->95019379],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TSV"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " tab-separated values"
}], "GuideText",
 CellID->296773392],

Cell["\t", "GuideDelimiter",
 CellID->102116762],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"HDF5\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF5"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " NCSA hierarchical data format (.hdf, .h5)"
}], "GuideText",
 CellID->202633757],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"CDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " NASA common data format (.cdf)"
}], "GuideText",
 CellID->804096657],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"NetCDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/NetCDF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unidata scientific data format"
}], "GuideText",
 CellID->337923628],

Cell["\t", "GuideDelimiter",
 CellID->85926933],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XPORT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XPORT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " SAS interchange format"
}], "GuideText",
 CellID->471428508],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MTP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Minitab portable format (.mtp)"
}], "GuideText",
 CellID->226136513],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Matlab/Octave data format (.mat)"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->12675414],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MTX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " MatrixMarket sparse matrix format (.mtx)"
}], "GuideText",
 CellID->812996123],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HarwellBoeing\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Harwell\[Dash]Boeing sparse matrix formats"
}], "GuideText",
 CellID->718151779],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MPS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MPS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " MPS linear-programming system format (.mps)"
}], "GuideText",
 CellID->108619788]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->60324697]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScientificAndMedicalDataFormats"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "GuideMoreAboutSub",
 CellID->312786615],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "GuideMoreAboutSub",
 CellID->612340167]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Data Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 25.2053212}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica can efficiently exchange data in all standard numerical \
formats--allowing convenient symbolic specification of data subsets and data \
elements.", "synonyms" -> {}, "title" -> "Numerical Data Formats", "type" -> 
    "Guide", "uri" -> "guide/NumericalDataFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 266, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[955, 37, 246, 8, 70, "GuideText",
 CellID->95019379],
Cell[1204, 47, 245, 8, 70, "GuideText",
 CellID->296773392],
Cell[1452, 57, 48, 1, 70, "GuideDelimiter",
 CellID->102116762],
Cell[1503, 60, 396, 12, 70, "GuideText",
 CellID->202633757],
Cell[1902, 74, 255, 8, 70, "GuideText",
 CellID->804096657],
Cell[2160, 84, 261, 8, 70, "GuideText",
 CellID->337923628],
Cell[2424, 94, 47, 1, 70, "GuideDelimiter",
 CellID->85926933],
Cell[2474, 97, 251, 8, 70, "GuideText",
 CellID->471428508],
Cell[2728, 107, 255, 8, 70, "GuideText",
 CellID->226136513],
Cell[2986, 117, 257, 8, 70, "GuideText",
 CellID->203374175],
Cell[3246, 127, 47, 1, 70, "GuideDelimiter",
 CellID->12675414],
Cell[3296, 130, 265, 8, 70, "GuideText",
 CellID->812996123],
Cell[3564, 140, 287, 8, 70, "GuideText",
 CellID->718151779],
Cell[3854, 150, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[3905, 153, 268, 8, 70, "GuideText",
 CellID->108619788]
}, Open  ]],
Cell[CellGroupData[{
Cell[4210, 166, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4275, 169, 172, 3, 70, "GuideTutorial",
 CellID->207014367],
Cell[4450, 174, 173, 3, 70, "GuideTutorial",
 CellID->60324697]
}, Open  ]],
Cell[CellGroupData[{
Cell[4660, 182, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4725, 185, 175, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4903, 190, 184, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5090, 196, 168, 3, 70, "GuideMoreAboutSub",
 CellID->312786615],
Cell[5261, 201, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[5422, 206, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396],
Cell[5583, 211, 141, 3, 70, "GuideMoreAboutSub",
 CellID->612340167]
}, Open  ]],
Cell[5739, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

