(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15862,        532]
NotebookOptionsPosition[     10509,        401]
NotebookOutlinePosition[     13817,        463]
CellTagsIndexPosition[     13774,        460]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Functions", "GuideTitle",
 CellID->10428],

Cell[TextData[{
 "Throughout ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " there is support not only for approximate real numbers, but also for exact \
numbers represented in algebraic or symbolic form",
 ". ",
 "Functions like ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["IntegerPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerPart"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["Max",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Max"]], "InlineFunctionSans"],
 " are all in effect set up to \"prove theorems\"\[LongDash]often using \
original algorithms developed at Wolfram Research\[LongDash]to give values \
with exact inputs."
}], "GuideAbstract",
 CellID->144129509],

Cell[TextData[{
 Cell[TextData[ButtonBox["Round",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Round"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ceiling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Ceiling"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerPart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FractionalPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FractionalPart"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12033],

Cell["\t", "GuideDelimiter",
 CellID->26685],

Cell[TextData[{
 Cell[TextData[ButtonBox["Min",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Min"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Max",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Max"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "minimum or maximum of numbers or lists"
}], "GuideText",
 CellID->2270],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "absolute value"
}], "GuideText",
 CellID->25329],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sign",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sign"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sign (-1, 0, +1)"
}], "GuideText",
 CellID->32261],

Cell["\t", "GuideDelimiter",
 CellID->22860],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clip"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clip to between -1 and +1 or other limits"
}], "GuideText",
 CellID->2208],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rescale to run between 0 and 1"
}], "GuideText",
 CellID->8982],

Cell[TextData[{
 Cell[TextData[ButtonBox["Chop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Chop"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "chop small values to 0"
}], "GuideText",
 CellID->22162],

Cell["\t", "GuideDelimiter",
 CellID->32506],

Cell[TextData[{
 Cell[TextData[ButtonBox["Unitize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unitize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  StyleBox["0", "TR"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["0", "TR"]}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 " otherwise"
}], "GuideText",
 CellID->35666543],

Cell[TextData[{
 Cell[TextData[ButtonBox["UnitStep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UnitStep"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  StyleBox["0", "TR"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "<", 
   StyleBox["0", "TR"]}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", 
   StyleBox["0", "TR"]}]], "InlineFormula"]
}], "GuideText",
 CellID->6878],

Cell[TextData[{
 Cell[TextData[ButtonBox["Piecewise",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Piecewise"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general piecewise function"
}], "GuideText",
 CellID->11979],

Cell[TextData[{
 Cell[TextData[ButtonBox["Boole",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Boole"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 " for ",
 Cell[TextData[ButtonBox["True",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/True"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData[
  StyleBox["0", "TR"]], "InlineFormula"],
 " for ",
 Cell[TextData[ButtonBox["False",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/False"]], "InlineFunctionSans"]
}], "GuideText",
 CellID->1897],

Cell["\t", "GuideDelimiter",
 CellID->7887],

Cell[TextData[{
 Cell[TextData[ButtonBox["Less",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Greater",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LessEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GreaterEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[">=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->3545],

Cell["\t", "GuideDelimiterSubsection",
 CellID->35101941],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Integer Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/IntegerFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->6538],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is an integer"
}], "GuideText",
 CellID->14469],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quotient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/IntegerFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30783]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->17540],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "GuideTutorial",
 CellID->412913713]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18633],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "GuideMoreAbout",
 CellID->13509],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->24557],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "GuideMoreAboutSub",
 CellID->26134]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->646082203],

Cell[TextData[{
 ButtonBox["Demonstrations related to Numerical Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Abs+\
OR+Boole+OR+Ceiling+OR+Chop+OR+Clip+OR+False+OR+Floor+OR+FractionalPart+OR+\
GCD+OR+Greater+OR+GreaterEqual+OR+IntegerPart+OR+IntegerQ+OR+Less+OR+\
LessEqual+OR+Max+OR+Min+OR+Mod+OR+Piecewise+OR+Quotient+OR+Rescale+OR+Round+\
OR+Sign+OR+True+OR+Unitize+OR+UnitStep)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->46358790]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 27.3772518}", "context" -> "", 
    "keywords" -> {
     "absolute value", "aliquant", "arrays", "Boolean", "Boolean algebra", 
      "box function", "boxcar function", "causal signals", "ceil", 
      "characteristic function", "comparison", "complex number", "congruence",
       "coprime", "crop", "csgn", "cyclic indices", "discontinuous functions",
       "division of integers", "entier", "entire", "Euclidean algorithm", 
      "Euclid's algorithm", "FEM", "finding maximal element in lists", 
      "finite elements", "finite fields", "fix", "frac", "fractional part", 
      "GCF", "greater", "greater equal", "greatest common divider", 
      "greatest common divisor", "greatest integer function", "Heaviside", 
      "Heaviside function", "Heaviside step function", "highest", 
      "highest common factor", "idiv", "idivide", "igcd", 
      "indicator function", "inequality", "int", "integer part", 
      "integral part of division", "integrate over a region", 
      "interval-defined functions", "intrz", "iquo", "irem", 
      "Iverson's convention", "largest", "least integer function", 
      "limiting function", "lists", "logical value", "lowest", "lowest terms",
       "magnitude of complex number", "maximal element", "maximum", "min", 
      "minimal element", "minimum", "modp", "mods", "modulo", 
      "nearest integer", "nearest integer function", "nint", 
      "non-integer part", "number rounding", "number sign", 
      "one-sided functions", "piecewise continuous functions", "quo", "quot", 
      "ramp", "ramp function", "relative primality", "rem", "remainder", 
      "round down", "rounddown", "round-off", "roundoff", "roundoff errors", 
      "round up", "roundup", "saturation function", "sawtooth function", 
      "sectionally defined functions", "sgn", "sign", "signum", "smallest", 
      "square wave", "step function", "testing for integers", 
      "theta function", "triangular wave", "trim", "trunc", 
      "truncate to integer", "truncation of numbers", "truth value", 
      "unit step", "unit step function"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Throughout Mathematica there is support not only for approximate real \
numbers, but also for exact numbers represented in algebraic or symbolic \
form. Functions like Floor, IntegerPart and Max are all in effect set up to \
\"prove theorems\"--often using original algorithms developed at Wolfram \
Research--to give values with exact inputs.", "synonyms" -> {}, "title" -> 
    "Numerical Functions", "type" -> "Guide", "uri" -> 
    "guide/NumericalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->10428],
Cell[679, 28, 818, 23, 70, "GuideAbstract",
 CellID->144129509],
Cell[1500, 53, 1020, 29, 70, "InlineGuideFunctionListing",
 CellID->12033],
Cell[2523, 84, 44, 1, 70, "GuideDelimiter",
 CellID->26685],
Cell[2570, 87, 369, 13, 70, "GuideText",
 CellID->2270],
Cell[2942, 102, 229, 9, 70, "GuideText",
 CellID->25329],
Cell[3174, 113, 233, 9, 70, "GuideText",
 CellID->32261],
Cell[3410, 124, 44, 1, 70, "GuideDelimiter",
 CellID->22860],
Cell[3457, 127, 257, 9, 70, "GuideText",
 CellID->2208],
Cell[3717, 138, 252, 9, 70, "GuideText",
 CellID->8982],
Cell[3972, 149, 239, 9, 70, "GuideText",
 CellID->22162],
Cell[4214, 160, 44, 1, 70, "GuideDelimiter",
 CellID->32506],
Cell[4261, 163, 472, 19, 70, "GuideText",
 CellID->35666543],
Cell[4736, 184, 580, 23, 70, "GuideText",
 CellID->6878],
Cell[5319, 209, 253, 9, 70, "GuideText",
 CellID->11979],
Cell[5575, 220, 580, 21, 70, "GuideText",
 CellID->1897],
Cell[6158, 243, 43, 1, 70, "GuideDelimiter",
 CellID->7887],
Cell[6204, 246, 1256, 43, 70, "InlineGuideFunctionListing",
 CellID->3545],
Cell[7463, 291, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->35101941],
Cell[CellGroupData[{
Cell[7545, 296, 216, 5, 70, "GuideFunctionsSubsection",
 CellID->6538],
Cell[7764, 303, 265, 9, 70, "GuideText",
 CellID->14469],
Cell[8032, 314, 793, 23, 70, "InlineGuideFunctionListing",
 CellID->30783]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8874, 343, 58, 1, 70, "GuideTutorialsSection",
 CellID->17540],
Cell[8935, 346, 156, 3, 70, "GuideTutorial",
 CellID->412913713]
}, Open  ]],
Cell[CellGroupData[{
Cell[9128, 354, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18633],
Cell[9190, 357, 142, 3, 70, "GuideMoreAbout",
 CellID->13509],
Cell[9335, 362, 146, 3, 70, "GuideMoreAbout",
 CellID->24557],
Cell[9484, 367, 164, 3, 70, "GuideMoreAboutSub",
 CellID->26134]
}, Open  ]],
Cell[CellGroupData[{
Cell[9685, 375, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->646082203],
Cell[9757, 378, 710, 18, 70, "GuideRelatedLinks",
 CellID->46358790]
}, Open  ]],
Cell[10482, 399, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

