(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12709,        400]
NotebookOptionsPosition[      7908,        279]
NotebookOutlinePosition[     10714,        333]
CellTagsIndexPosition[     10671,        330]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Optimization", "GuideTitle",
 CellID->2340],

Cell[TextData[{
 "Integrated into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are a full range of state-of-the-art local and global optimization \
techniques, both numeric and symbolic, including constrained nonlinear \
optimization, interior point methods and integer programming\[LongDash]as \
well as original symbolic methods",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture provides seamless access to industrial-strength \
system and model optimization, efficiently handling million-variable linear \
programming, and multi-thousand-variable nonlinear problems."
}], "GuideAbstract",
 CellID->163112724],

Cell[TextData[{
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NMaximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMaximize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " nonlinear constrained global optimization"
}], "GuideText",
 CellID->21476],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FindMaximum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMaximum"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " local unconstrained or constrained optimization"
}], "GuideText",
 CellID->3154],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " optimal nonlinear unconstrained or constrained fit to data"
}], "GuideText",
 CellID->10935],

Cell["\t", "GuideDelimiter",
 CellID->16430],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Maximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Maximize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic global optimization"
}], "GuideText",
 CellID->5831],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot regions satisfied by inequalities"
}], "GuideText",
 CellID->3537],

Cell["\t", "GuideDelimiter",
 CellID->15623],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " real and integer linear programming in matrix form"
}], "GuideText",
 CellID->30211],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " least-squares problem in matrix form"
}], "GuideText",
 CellID->16211],

Cell["\t", "GuideDelimiterSubsection",
 CellID->137771986],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Combinatorial Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DiscreteMathematics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->704893981],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindShortestTour",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindShortestTour"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve a traveling salesman problem"
}], "GuideText",
 CellID->396734022],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve integer programming problems"
}], "GuideText",
 CellID->947959765]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->11754],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "GuideTutorial",
 CellID->275077791],

Cell[TextData[ButtonBox["Numerical Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalOptimization"]], "GuideTutorial",
 CellID->307238205],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->37333028],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "GuideTutorial",
 CellID->41775158]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->3293],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Variational Methods Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/guide/VariationalMethodsPackage"]], \
"GuideMoreAbout",
 CellID->13431964],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->1746899519],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->1798777425],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->348519122],

Cell[TextData[{
 ButtonBox["Demonstrations related to Optimization",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22optimization+methods%22+content%3AFindFit+OR+FindMaximum+OR+FindMinimum+OR+\
FindShortestTour+OR+LeastSquares+OR+LinearProgramming+OR+Maximize+OR+Minimize+\
OR+NMaximize+OR+NMinimize+OR+RegionPlot+OR+RegionPlot3D"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->32735283]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 29.1116712}", "context" -> "", 
    "keywords" -> {
     "approximation of functions", "constrained local optimization", 
      "constrained optimization", "convex programming", "cost function", 
      "cylindrical decomposition", "exact optimization", "extremization", 
      "find fit", "find maximum", "find minimum", "fits", "fitting curves", 
      "fitting differential equations", "fitting surfaces", 
      "global maximization", "global minimization", "goal functions", 
      "inequalities", "infeasible constraints", "integer linear programming", 
      "integer programming", "interior point algorithm", 
      "interior point methods", "Karmarkar's algorithm", "least-squares", 
      "least squares", "least-squares fits", "Levenberg-Marquardt method", 
      "linear constraints", "linear fractional programming", 
      "linear objective function", "linear optimization", 
      "linear programming", "local maximization", "local minimization", 
      "local optimization", "LP", "maximization", "minimization", 
      "nonlinear fitting", "numerical maximization", "numerical maximum", 
      "numerical minimization", "objective functions", "operations research", 
      "optimization", "parametric optimization", "pay-off functions", 
      "polynomial fit", "polynomial programming", "quadratic programming", 
      "residuals", "simplex algorithm", "symbolic optimization", 
      "testing models", "trend line"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Integrated into Mathematica are a full range of state-of-the-art local \
and global optimization techniques, both numeric and symbolic, including \
constrained nonlinear optimization, interior point methods and integer \
programming--as well as original symbolic methods. Mathematica's symbolic \
architecture provides seamless access to industrial-strength system and model \
optimization, efficiently handling million-variable linear programming, and \
multi-thousand-variable nonlinear problems.", "synonyms" -> {}, "title" -> 
    "Optimization", "type" -> "Guide", "uri" -> "guide/Optimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 49, 1, 70, "GuideTitle",
 CellID->2340],
Cell[671, 28, 656, 15, 70, "GuideAbstract",
 CellID->163112724],
Cell[1330, 45, 392, 12, 70, "GuideText",
 CellID->21476],
Cell[1725, 59, 405, 12, 70, "GuideText",
 CellID->3154],
Cell[2133, 73, 276, 8, 70, "GuideText",
 CellID->10935],
Cell[2412, 83, 44, 1, 70, "GuideDelimiter",
 CellID->16430],
Cell[2459, 86, 374, 12, 70, "GuideText",
 CellID->5831],
Cell[2836, 100, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2887, 103, 686, 18, 70, "GuideText",
 CellID->3537],
Cell[3576, 123, 44, 1, 70, "GuideDelimiter",
 CellID->15623],
Cell[3623, 126, 288, 8, 70, "GuideText",
 CellID->30211],
Cell[3914, 136, 409, 11, 70, "GuideText",
 CellID->16211],
Cell[4326, 149, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->137771986],
Cell[CellGroupData[{
Cell[4409, 154, 215, 5, 70, "GuideFunctionsSubsection",
 CellID->704893981],
Cell[4627, 161, 274, 8, 70, "GuideText",
 CellID->396734022],
Cell[4904, 171, 391, 12, 70, "GuideText",
 CellID->947959765]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5344, 189, 58, 1, 70, "GuideTutorialsSection",
 CellID->11754],
Cell[5405, 192, 144, 3, 70, "GuideTutorial",
 CellID->275077791],
Cell[5552, 197, 162, 3, 70, "GuideTutorial",
 CellID->307238205],
Cell[5717, 202, 176, 4, 70, "GuideTutorial",
 CellID->37333028],
Cell[5896, 208, 180, 4, 70, "GuideTutorial",
 CellID->41775158]
}, Open  ]],
Cell[CellGroupData[{
Cell[6113, 217, 58, 1, 70, "GuideMoreAboutSection",
 CellID->3293],
Cell[6174, 220, 161, 3, 70, "GuideMoreAbout",
 CellID->21321],
Cell[6338, 225, 192, 5, 70, "GuideMoreAbout",
 CellID->13431964],
Cell[6533, 232, 191, 5, 70, "GuideMoreAboutSub",
 CellID->1746899519],
Cell[6727, 239, 200, 5, 70, "GuideMoreAboutSub",
 CellID->1798777425],
Cell[6930, 246, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[CellGroupData[{
Cell[7147, 254, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->348519122],
Cell[7219, 257, 647, 17, 70, "GuideRelatedLinks",
 CellID->32735283]
}, Open  ]],
Cell[7881, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

