(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12923,        425]
NotebookOptionsPosition[      8529,        311]
NotebookOutlinePosition[     10970,        360]
CellTagsIndexPosition[     10927,        357]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Parallel & Grid Computing", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s general ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " symbolic communication protocol immediately allows both \
platform-independent client-server operation\[LongDash]as well as parallel \
computation in which both data and programs can be exchanged seamlessly \
between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernels. Building on these foundations, grid",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a full environment for parallel computing, with fully integrated \
parallel-computation functions and advanced grid-management support. "
}], "GuideAbstract",
 CellID->39942370],

Cell[CellGroupData[{

Cell["Running Remote Kernels", "GuideFunctionsSubsection",
 CellID->366733851],

Cell[TextData[{
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Kernel Configuration Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/KernelConfigurationOptions"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set up additional local or remote kernels"
}], "GuideText",
 CellID->25630894],

Cell[TextData[{
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Notebook's Kernel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/NotebookKernel"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " choose the kernel to connect to "
}], "GuideText",
 CellID->155554892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Evaluator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Evaluator"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify which kernel to use for a cell, button, etc."
}], "GuideText",
 CellID->511589390],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20474784]
}, Open  ]],

Cell[CellGroupData[{

Cell["Launching Kernels", "GuideFunctionsSubsection",
 CellID->738863960],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkLaunch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkLaunch"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkCreate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkCreate"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkConnect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkConnect"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " start and connect kernels"
}], "GuideText",
 CellID->54057127],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["-",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/MathKernel"],
  ButtonBox["mathlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/MathKernel"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " command-line option for launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode"
}], "GuideText",
 CellID->53893346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Communicating Between Kernels \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathLinkMathematicaFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->13940245],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkRead"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LinkWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkWrite"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " read, write arbitrary data and programs over ",
 StyleBox["MathLink",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["EvaluatePacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReturnPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReturnPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TextPacket",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->156771675],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinkReadyQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select between several ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process Management", "GuideFunctionsSubsection",
 CellID->187303541],

Cell[TextData[{
 Cell[TextData[ButtonBox["$ParentLink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ParentLink"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$ProcessID",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ProcessID"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$ParentProcessID",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$ParentProcessID"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MachineName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MachineName"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->78778129]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->13456735]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->171208371],

Cell[TextData[{
 ButtonBox["grid",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/gridmathematica/"], None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/gridmathematica/"], None}],
  FontSlant->"Italic"]
}], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Parallel Computing Toolkit",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://documents.wolfram.com/applications/parallel/"], 
   None}]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parallel & Grid Computing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 33.8930436}", "context" -> "", 
    "keywords" -> {
     "bind name", "child process", "child processes", "concurrency", 
      "connect link", "connect MathLink", "ConnectLink", "create link", 
      "create task", "data available", "data parallelism", "find link", 
      "fork", "get data from MathLink", "heterogeneous networks", "host name",
       "hostname", "job number", "kill a process", "launching programs", 
      "link connect", "link create", "link launch", "link read", "link ready",
       "link write", "listen on link", "machine name", 
      "MathLink connection to kernel", "MathLink expression ready", 
      "multiprocessing", "network computation", "parent link", 
      "parent process", "peer computing", "PID", "PPID", "process ID", 
      "publish link", "put data", "reading expression from MathLink", 
      "register link", "remote kernels", "send data via MathLink", 
      "signaling a process", "slave processes", "starting programs", 
      "subscribe to link", "subsidiary processes", "synchronization", 
      "write data to MathLink"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's general MathLink symbolic communication protocol \
immediately allows both platform-independent client-server operation--as well \
as parallel computation in which both data and programs can be exchanged \
seamlessly between Mathematica kernels. Building on these foundations, \
gridMathematica provides a full environment for parallel computing, with \
fully integrated parallel-computation functions and advanced grid-management \
support. ", "synonyms" -> {}, "title" -> "Parallel & Grid Computing", "type" -> 
    "Guide", "uri" -> "guide/ParallelAndGridComputing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 687, 18, 70, "GuideAbstract",
 CellID->39942370],
Cell[CellGroupData[{
Cell[1401, 50, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->366733851],
Cell[1482, 53, 469, 12, 70, "GuideText",
 CellID->25630894],
Cell[1954, 67, 438, 12, 70, "GuideText",
 CellID->155554892],
Cell[2395, 81, 278, 8, 70, "GuideText",
 CellID->511589390],
Cell[2676, 91, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->20474784]
}, Open  ]],
Cell[CellGroupData[{
Cell[2770, 97, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->738863960],
Cell[2846, 100, 516, 16, 70, "GuideText",
 CellID->54057127],
Cell[3365, 118, 478, 19, 70, "GuideText",
 CellID->53893346]
}, Open  ]],
Cell[CellGroupData[{
Cell[3880, 142, 246, 6, 70, "GuideFunctionsSubsection",
 CellID->13940245],
Cell[4129, 150, 444, 14, 70, "GuideText",
 CellID->203374175],
Cell[4576, 166, 856, 24, 70, "InlineGuideFunctionListing",
 CellID->156771675],
Cell[5435, 192, 309, 11, 70, "GuideText",
 CellID->1463276848],
Cell[5747, 205, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[5842, 211, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->187303541],
Cell[5919, 214, 845, 23, 70, "InlineGuideFunctionListing",
 CellID->78778129]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6813, 243, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6878, 246, 374, 11, 70, "GuideTutorial",
 CellID->13456735]
}, Open  ]],
Cell[CellGroupData[{
Cell[7289, 262, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7354, 265, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[7546, 271, 262, 9, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[7845, 285, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->171208371],
Cell[7917, 288, 356, 11, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[8276, 301, 211, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[8502, 309, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

