(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12024,        416]
NotebookOptionsPosition[      7871,        304]
NotebookOutlinePosition[     10193,        353]
CellTagsIndexPosition[     10150,        350]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Parts of Matrices", "GuideTitle",
 CellID->23292],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides several convenient methods for extracting and manipulating parts \
of matrices. The flexible ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", " ", "]"}], "]"}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 ") and ",
 Cell[BoxData[";;"], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ") syntaxes provide compact yet readable representations of operations on \
submatrices and matrix elements. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic character also allows convenient pattern and rule-based element \
specifications."
}], "GuideAbstract",
 CellID->1723],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dimensions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dimensions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "dimensions of a matrix"
}], "GuideText",
 CellID->11153],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is a matrix"
}], "GuideText",
 CellID->15948],

Cell["\t", "GuideDelimiter",
 CellID->24395],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "elements and submatrices: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 "; resettable with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "=", 
   StyleBox["x", "TI"]}]], "InlineFormula"]
}], "GuideText",
 CellID->25197],

Cell[TextData[{
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "take rows, columns and submatrices"
}], "GuideText",
 CellID->4508],

Cell[TextData[{
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "drop rows, columns and submatrices"
}], "GuideText",
 CellID->22908],

Cell[TextData[{
 Cell[TextData[ButtonBox["Diagonal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Diagonal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " get the list of elements on the diagonal"
}], "GuideText",
 CellID->81592354],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotateLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RotateLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["RotateRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RotateRight"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " cyclically ",
 "rotate rows or columns"
}], "GuideText",
 CellID->17411],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reverse rows or columns"
}], "GuideText",
 CellID->69296834],

Cell[TextData[{
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interchange rows and columns"
}], "GuideText",
 CellID->26624305],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " join rows or columns of several matrices"
}], "GuideText",
 CellID->149573908],

Cell["\t", "GuideDelimiter",
 CellID->13993],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find positions where elements that match a pattern occur"
}], "GuideText",
 CellID->7665],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extract"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "extract elements that appear at a list of positions"
}], "GuideText",
 CellID->26781],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make replacements for collections of elements"
}], "GuideText",
 CellID->319780168],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayRules"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get a list of positions and values for nonzero elements"
}], "GuideText",
 CellID->3202],

Cell["\t", "GuideDelimiter",
 CellID->17610],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply a function at any level"
}], "GuideText",
 CellID->24828]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->27256],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->421603135],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "GuideTutorial",
 CellID->97480921],

Cell[TextData[ButtonBox["Getting and Setting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GettingAndSettingPiecesOfMatrices"]], "GuideTutorial",
 CellID->8979225],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "GuideTutorial",\

 CellID->188144983],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "GuideTutorial",
 CellID->693933341]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18023],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->20769],

Cell[TextData[ButtonBox["Parts of General Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "GuideMoreAbout",
 CellID->11715]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parts of Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 35.0180724}", "context" -> "", 
    "keywords" -> {
     "applying functions to lists of expressions", 
      "applying functions to parts of expression", "array rules", 
      "array shape", "array size", "block matrices", "catenating lists", 
      "changing parts", "collapse", "columns", "concatenating lists", 
      "contraction", "cycle", "deleting elements", "discard elements", 
      "elements", "extraction of sublists", "indices", "left shift", "levels",
       "list as matrix", "lists", "matrices", "matrix dimensions", 
      "matrix transpose", "merging lists", "multiple parts", 
      "numerical matrices", "parts", "permutation of indices", 
      "picking out sequences of elements in lists", 
      "removing elements from lists", "replacements", "replace part", 
      "right shift", "rotate left", "rotate right", "rows", 
      "segments of lists", "sequence of elements", 
      "specify elements in sparse array", "splicing", "stride", "submatrices",
       "tensors", "testing for matrices", "transpose of matrices", 
      "transposition of lists"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides several convenient methods for extracting and \
manipulating parts of matrices. The flexible [[ ]] (Part) and ;; (Span) \
syntaxes provide compact yet readable representations of operations on \
submatrices and matrix elements. Mathematica's symbolic character also allows \
convenient pattern and rule-based element specifications.", "synonyms" -> {}, 
    "title" -> "Parts of Matrices", "type" -> "Guide", "uri" -> 
    "guide/PartsOfMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->23292],
Cell[677, 28, 985, 28, 70, "GuideAbstract",
 CellID->1723],
Cell[1665, 58, 251, 9, 70, "GuideText",
 CellID->11153],
Cell[1919, 69, 261, 9, 70, "GuideText",
 CellID->15948],
Cell[2183, 80, 44, 1, 70, "GuideDelimiter",
 CellID->24395],
Cell[2230, 83, 673, 26, 70, "GuideText",
 CellID->25197],
Cell[2906, 111, 250, 9, 70, "GuideText",
 CellID->4508],
Cell[3159, 122, 251, 9, 70, "GuideText",
 CellID->22908],
Cell[3413, 133, 408, 11, 70, "GuideText",
 CellID->81592354],
Cell[3824, 146, 395, 13, 70, "GuideText",
 CellID->17411],
Cell[4222, 161, 244, 8, 70, "GuideText",
 CellID->69296834],
Cell[4469, 171, 253, 8, 70, "GuideText",
 CellID->26624305],
Cell[4725, 181, 256, 8, 70, "GuideText",
 CellID->149573908],
Cell[4984, 191, 44, 1, 70, "GuideDelimiter",
 CellID->13993],
Cell[5031, 194, 275, 8, 70, "GuideText",
 CellID->7665],
Cell[5309, 204, 274, 9, 70, "GuideText",
 CellID->26781],
Cell[5586, 215, 280, 9, 70, "GuideText",
 CellID->319780168],
Cell[5869, 226, 283, 9, 70, "GuideText",
 CellID->3202],
Cell[6155, 237, 44, 1, 70, "GuideDelimiter",
 CellID->17610],
Cell[6202, 240, 244, 9, 70, "GuideText",
 CellID->24828]
}, Open  ]],
Cell[CellGroupData[{
Cell[6483, 254, 58, 1, 70, "GuideTutorialsSection",
 CellID->27256],
Cell[6544, 257, 157, 3, 70, "GuideTutorial",
 CellID->421603135],
Cell[6704, 262, 156, 3, 70, "GuideTutorial",
 CellID->97480921],
Cell[6863, 267, 191, 4, 70, "GuideTutorial",
 CellID->8979225],
Cell[7057, 273, 206, 5, 70, "GuideTutorial",
 CellID->188144983],
Cell[7266, 280, 165, 3, 70, "GuideTutorial",
 CellID->693933341]
}, Open  ]],
Cell[CellGroupData[{
Cell[7468, 288, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18023],
Cell[7530, 291, 146, 3, 70, "GuideMoreAbout",
 CellID->20769],
Cell[7679, 296, 150, 3, 70, "GuideMoreAbout",
 CellID->11715]
}, Open  ]],
Cell[7844, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

