(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11112,        359]
NotebookOptionsPosition[      7025,        255]
NotebookOutlinePosition[      9453,        304]
CellTagsIndexPosition[      9410,        301]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Plotting and Image Regions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows convenient automated selection of plotting and image regions using \
a family of specially developed robust algorithms, as well as allowing \
detailed manual control, especially for optimization of image stability in \
animations and dynamic graphics. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotRange"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the basic range of coordinates to include (e.g. ",
 Cell[TextData[ButtonBox["All",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Automatic",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 ")"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotRangePadding",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how much to extend the range of coordinates, axes, etc."
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrameMargins",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrameMargins"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "margins to leave inside a frame"
}], "GuideText",
 CellID->71594454],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImagePadding",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImagePadding"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "extra space outside the final plot range to leave for labels, etc. "
}], "GuideText",
 CellID->109249218],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotRangeClipping",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to clip objects that extend beyond the final plot range"
}], "GuideText",
 CellID->460492438],

Cell["\t", "GuideDelimiter",
 CellID->42353078],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the overall size of the final image"
}], "GuideText",
 CellID->766571699],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageMargins",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageMargins"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "margins to leave outside the final image"
}], "GuideText",
 CellID->199536366],

Cell[TextData[{
 Cell[TextData[ButtonBox["AspectRatio",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AspectRatio"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the shape of the final image, leaving empty space if necessary"
}], "GuideText",
 CellID->33034976],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalRegion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalRegion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to leave space for 3D graphics to rotate without clipping"
}], "GuideText",
 CellID->172152365],

Cell["\t", "GuideDelimiter",
 CellID->103837529],

Cell[TextData[{
 Cell[TextData[ButtonBox["DataRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DataRange"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "how to assign coordinates in data plots"
}], "GuideText",
 CellID->260213189],

Cell["\t", "GuideDelimiterSubsection",
 CellID->149687936],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Coordinates",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsCoordinates"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->60671846],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scaled",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scaled"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coordinates scaled to plot range"
}], "GuideText",
 CellID->323982286],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageScaled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageScaled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coordinates scaled to image region"
}], "GuideText",
 CellID->99143226]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1802829160],

Cell[TextData[{
 ButtonBox["Demonstrations related to Plotting and Image Regions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AspectRatio+OR+DataRange+OR+FrameMargins+OR+ImageMargins+OR+ImagePadding+OR+\
ImageSize+OR+PlotRange+OR+PlotRangeClipping+OR+PlotRangePadding+OR+\
SphericalRegion)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->67440673]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plotting and Image Regions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 39.6431908}", "context" -> "", 
    "keywords" -> {
     "aspect ratio", "autoscaling in plots", "boundary of plots", 
      "centering in 3D", "centering of three-dimensional object", 
      "circumscribing sphere", "data range", "distortion", "elongation", 
      "frame margins", "graphics margins", "graphics range", "graphics size", 
      "height of plots", "image margins", "image padding", "image size", 
      "limits of plots", "orientation of 3D object", "picture size", 
      "plot margins", "plot range", "plot range clipping", 
      "plot range padding", "plots", "range for x axis", "range for y axis", 
      "range of data", "range of data values", "range of graphics", 
      "ranges of coordinates", "rescale values", "rotation of 3D coordinates",
       "shape", "size", "spherical region", "squashing", "width", 
      "zoom in plot", "box model", "margin top", "margin right", 
      "margin bottom", "margin left", "padding top", "padding right", 
      "padding left", "padding bottom", "border width", "content area", 
      "padding area", "border area", "margin area", "CSS box model", 
      "content edge", "inner edge", "padding edge", "rendered content", 
      "border edge", "margin edge", "outer edge"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica allows convenient automated selection of plotting and image \
regions using a family of specially developed robust algorithms, as well as \
allowing detailed manual control, especially for optimization of image \
stability in animations and dynamic graphics. ", "synonyms" -> {}, "title" -> 
    "Plotting and Image Regions", "type" -> "Guide", "uri" -> 
    "guide/PlottingAndImageRegions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 370, 8, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1063, 38, 458, 15, 70, "GuideText",
 CellID->203374175],
Cell[1524, 55, 446, 12, 70, "GuideText",
 CellID->1463276848],
Cell[1973, 69, 412, 12, 70, "GuideText",
 CellID->71594454],
Cell[2388, 83, 449, 12, 70, "GuideText",
 CellID->109249218],
Cell[2840, 97, 455, 12, 70, "GuideText",
 CellID->460492438],
Cell[3298, 111, 47, 1, 70, "GuideDelimiter",
 CellID->42353078],
Cell[3348, 114, 266, 9, 70, "GuideText",
 CellID->766571699],
Cell[3617, 125, 277, 9, 70, "GuideText",
 CellID->199536366],
Cell[3897, 136, 296, 9, 70, "GuideText",
 CellID->33034976],
Cell[4196, 147, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4247, 150, 308, 9, 70, "GuideText",
 CellID->172152365],
Cell[4558, 161, 48, 1, 70, "GuideDelimiter",
 CellID->103837529],
Cell[4609, 164, 270, 9, 70, "GuideText",
 CellID->260213189],
Cell[4882, 175, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->149687936],
Cell[CellGroupData[{
Cell[4965, 180, 199, 5, 70, "GuideFunctionsSubsection",
 CellID->60671846],
Cell[5167, 187, 252, 8, 70, "GuideText",
 CellID->323982286],
Cell[5422, 197, 408, 11, 70, "GuideText",
 CellID->99143226]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5879, 214, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5944, 217, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6104, 222, 158, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 230, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1802829160],
Cell[6372, 233, 611, 17, 70, "GuideRelatedLinks",
 CellID->67440673]
}, Open  ]],
Cell[6998, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

