(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7535,        252]
NotebookOptionsPosition[      4629,        173]
NotebookOutlinePosition[      6370,        213]
CellTagsIndexPosition[      6327,        210]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polygons", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides unified graphics support for 2D and 3D polygons, allowing all \
standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " colors and transparencies to be used for both faces and edges, as well as \
interpolated across polygons."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "polygon or collection of polygons in 2D or 3D"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->395970521],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graphics directives to specify how to draw edges"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["FaceForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FaceForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graphics directives to specify how to draw interiors of faces"
}], "GuideText",
 CellID->248443239],

Cell["\t", "GuideDelimiter",
 CellID->65324260],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColors",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexColors"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "vertex colors to interpolate in 2D or 3D"
}], "GuideText",
 CellID->87290701],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexNormals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexNormals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "effective vertex normal directions in 3D"
}], "GuideText",
 CellID->81844212],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general construct supporting polygonal meshes"
}], "GuideText",
 CellID->63594395]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "GuideMoreAbout",
 CellID->322657298]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->228497320],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polygons",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22polygons%22+content%3AEdgeForm+OR+FaceForm+OR+GraphicsComplex+OR+Polygon+OR+\
VertexColors+OR+VertexNormals"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->139737902]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polygons - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 41.0807276}", "context" -> "", 
    "keywords" -> {
     "2D polygon", "3D polygon", "borders of polygons", "color dithering", 
      "continuous shading", "edge form", "face", "face form", "facet", 
      "filled region", "Gouraud shading", "graphics complex", 
      "Lambertian diffuse lighting", "light dithering", "polygon edges style",
       "polygon mesh", "polygon normals", "polyhedra", "polytope", "region", 
      "seams between polygons", "surface data", "surface graphics", 
      "surface lighting", "surface mesh", "surface normals", 
      "surface polygons", "surface shading", "surface triangulation", 
      "vertex colors", "vertex normals"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides unified graphics support for 2D and 3D polygons, \
allowing all standard Mathematica colors and transparencies to be used for \
both faces and edges, as well as interpolated across polygons.", 
    "synonyms" -> {}, "title" -> "Polygons", "type" -> "Guide", "uri" -> 
    "guide/Polygons"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[672, 28, 353, 10, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1028, 40, 272, 9, 70, "GuideText",
 CellID->203374175],
Cell[1303, 51, 48, 1, 70, "GuideDelimiter",
 CellID->395970521],
Cell[1354, 54, 278, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1635, 65, 290, 9, 70, "GuideText",
 CellID->248443239],
Cell[1928, 76, 47, 1, 70, "GuideDelimiter",
 CellID->65324260],
Cell[1978, 79, 421, 12, 70, "GuideText",
 CellID->87290701],
Cell[2402, 93, 423, 12, 70, "GuideText",
 CellID->81844212],
Cell[2828, 107, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2879, 110, 432, 12, 70, "GuideText",
 CellID->63594395]
}, Open  ]],
Cell[CellGroupData[{
Cell[3348, 127, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3413, 130, 168, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[3584, 135, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[3737, 140, 202, 4, 70, "GuideMoreAbout",
 CellID->322657298]
}, Open  ]],
Cell[CellGroupData[{
Cell[3976, 149, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->228497320],
Cell[4048, 152, 539, 16, 70, "GuideRelatedLinks",
 CellID->139737902]
}, Open  ]],
Cell[4602, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

