(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10816,        332]
NotebookOptionsPosition[      6423,        225]
NotebookOutlinePosition[      9309,        281]
CellTagsIndexPosition[      9266,        278]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Polynomial Division", "GuideTitle",
 CellID->990],

Cell[TextData[{
 "As with integers, operations related to division are key to many \
computations with polynomials. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes not only highly optimized univariate polynomial-division \
algorithms, but also state-of-the-art multivariate generalizations. "
}], "GuideAbstract",
 CellID->3873],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialQuotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialRemainder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialQuotientRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->200358017],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialGCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialLCM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialExtendedGCD",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolynomialExtendedGCD"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->527669318],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cancel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cancel"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cancel factors in a ratio of polynomials"
}], "GuideText",
 CellID->17241],

Cell["\t", "GuideDelimiter",
 CellID->4641],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent one polynomial as a sum of others"
}], "GuideText",
 CellID->5646],

Cell[TextData[{
 Cell[TextData[ButtonBox["GroebnerBasis",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a reduced Groebner basis for a list of polynomials"
}], "GuideText",
 CellID->23525],

Cell["\t", "GuideDelimiter",
 CellID->28213],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialMod"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce polynomial coefficients modulo ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->16824],

Cell[TextData[{
 Cell[TextData[ButtonBox["Modulus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Modulus"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify the modulus for a finite field"
}], "GuideText",
 CellID->17929]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->8695],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->161175268],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "GuideTutorial",
 CellID->174693145],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "GuideTutorial",
 CellID->414928313],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "GuideTutorial",
 CellID->99979351]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->7993],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->26067],

Cell[TextData[ButtonBox["Polynomial Factoring",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "GuideMoreAbout",
 CellID->22187],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->149123976],

Cell[TextData[{
 ButtonBox["Demonstrations related to Polynomial Division",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Cancel+OR+GroebnerBasis+OR+Modulus+OR+PolynomialExtendedGCD+OR+PolynomialGCD+\
OR+PolynomialLCM+OR+PolynomialMod+OR+PolynomialQuotient+OR+\
PolynomialQuotientRemainder+OR+PolynomialReduce+OR+PolynomialRemainder)"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->254183236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomial Division - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 43.0182772}", "context" -> "", 
    "keywords" -> {
     "algebraic algorithms", "algebraic geometry", "algebraic varieties", 
      "Aryabhatta's identity", "Bezout identity", "Buchberger algorithm", 
      "cancel out", "catastrophe theory", "common factors", "common roots", 
      "commutative algebra", "division", "division of polynomials", "divisor",
       "elimination basis", "Euclidean algorithm", 
      "extended greatest common divisor", "GCD of polynomials", 
      "generalized division", "generalized polynomial remainder", 
      "greatest common divisor", "greatest common divisor of polynomials", 
      "Gro\"bner basis", "Groebner basis", "Groebner-Walk algorithm", "HCF", 
      "highest common factor", "ideal basis", "ideal operations", "ideals", 
      "LCM of polynomials", "lowest common multiple", "modular computation", 
      "modular reduction of polynomials", "modular ring", "normal form", 
      "polynomial Diophantine equations", "polynomial division", 
      "polynomial extended", "polynomial extended GCD", "polynomial GCD", 
      "polynomial greatest common divisor", "polynomial interreduction", 
      "polynomial LCM", "polynomial least common multiple", "polynomial mod", 
      "polynomial moduli", "polynomial quotient", 
      "polynomial quotient remainder", "polynomial reduce", 
      "polynomial remainder", "primary decomposition", "prime fields", 
      "projection of algebraic set", "quot", "quotient", 
      "quotient of polynomials", "quotient rings", "rational function", "rem",
       "remainder", "remainder in polynomial division", "singularities", 
      "smallest common multiple", "standard basis", "syzygies", "varieties", 
      "Zariski closure", "Zippel's algorithm"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "As with integers, operations related to division are key to many \
computations with polynomials. Mathematica includes not only highly optimized \
univariate polynomial-division algorithms, but also state-of-the-art \
multivariate generalizations. ", "synonyms" -> {}, "title" -> 
    "Polynomial Division", "type" -> "Guide", "uri" -> 
    "guide/PolynomialDivision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->990],
Cell[677, 28, 344, 8, 70, "GuideAbstract",
 CellID->3873],
Cell[1024, 38, 832, 21, 70, "InlineGuideFunctionListing",
 CellID->200358017],
Cell[1859, 61, 795, 20, 70, "InlineGuideFunctionListing",
 CellID->527669318],
Cell[2657, 83, 261, 9, 70, "GuideText",
 CellID->17241],
Cell[2921, 94, 43, 1, 70, "GuideDelimiter",
 CellID->4641],
Cell[2967, 97, 283, 9, 70, "GuideText",
 CellID->5646],
Cell[3253, 108, 290, 9, 70, "GuideText",
 CellID->23525],
Cell[3546, 119, 44, 1, 70, "GuideDelimiter",
 CellID->28213],
Cell[3593, 122, 330, 11, 70, "GuideText",
 CellID->16824],
Cell[3926, 135, 261, 9, 70, "GuideText",
 CellID->17929]
}, Open  ]],
Cell[CellGroupData[{
Cell[4224, 149, 57, 1, 70, "GuideTutorialsSection",
 CellID->8695],
Cell[4284, 152, 189, 4, 70, "GuideTutorial",
 CellID->161175268],
Cell[4476, 158, 191, 4, 70, "GuideTutorial",
 CellID->174693145],
Cell[4670, 164, 167, 3, 70, "GuideTutorial",
 CellID->414928313],
Cell[4840, 169, 197, 4, 70, "GuideTutorial",
 CellID->99979351]
}, Open  ]],
Cell[CellGroupData[{
Cell[5074, 178, 58, 1, 70, "GuideMoreAboutSection",
 CellID->7993],
Cell[5135, 181, 148, 3, 70, "GuideMoreAbout",
 CellID->26067],
Cell[5286, 186, 152, 3, 70, "GuideMoreAbout",
 CellID->22187],
Cell[5441, 191, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[CellGroupData[{
Cell[5651, 199, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->149123976],
Cell[5723, 202, 658, 18, 70, "GuideRelatedLinks",
 CellID->254183236]
}, Open  ]],
Cell[6396, 223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

