(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17266,        559]
NotebookOptionsPosition[     12831,        438]
NotebookOutlinePosition[     15001,        484]
CellTagsIndexPosition[     14958,        481]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Procedural Programming", "GuideTitle",
 CellID->6508],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stands out from traditional computer languages in supporting many \
programming paradigms. Procedural programming is the only paradigm available \
in languages like C and Java, as well as most scripting languages. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports all standard procedural programming constructs, but often extends \
them through integration into its more general symbolic programming \
environment."
}], "GuideAbstract",
 CellID->25149],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["value",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 " set the value for a variable"
}], "GuideText",
 CellID->31920],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "execute expressions in sequence"
}], "GuideText",
 CellID->10106],

Cell["\t", "GuideDelimiterSubsection",
 CellID->19271],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Assignments \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Assignments"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->12368],

Cell[TextData[{
 Cell[TextData[ButtonBox["=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["+=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AddTo"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["++",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Increment"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["*=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimesBy"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppendTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppendTo"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Assignments"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Loops \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LoopingConstructs"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->15258],

Cell[TextData[{
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["While",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/While"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["For",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/For"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LoopingConstructs"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4157]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Conditionals \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Conditionals"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->9647],

Cell[TextData[{
 Cell[TextData[ButtonBox["If",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/If"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Which",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Which"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Switch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Switch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["And",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["&&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Less",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Conditionals"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Flow Control \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FlowControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18238],

Cell[TextData[{
 Cell[TextData[ButtonBox["Return",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Return"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Throw",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Throw"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Catch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Catch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FlowControl"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24122]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Scoping Constructs \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScopingConstructs"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->244574497],

Cell[TextData[{
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["With",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/With"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Block",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Block"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ScopingConstructs"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->456834773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Input, Output, Etc. \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BasicInputAndOutputInPrograms"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->17723],

Cell[TextData[{
 Cell[TextData[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Print"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Input",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Input"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pause",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pause"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenRead",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenRead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->906]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18706],

Cell[TextData[ButtonBox["Functions as Procedures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FunctionsAsProcedures"]], "GuideTutorial",
 CellID->166318243],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "GuideTutorial",
 CellID->71307028],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "GuideTutorial",
 CellID->332730818],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "GuideTutorial",
 CellID->674100989],

Cell[TextData[ButtonBox["Modules and Local Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ModulesAndLocalVariables"]], "GuideTutorial",
 CellID->400781559],

Cell[TextData[ButtonBox["Blocks Compared with Modules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BlocksComparedWithModules"]], "GuideTutorial",
 CellID->417067063]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->30345],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "GuideMoreAbout",
 CellID->12351],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "GuideMoreAboutSub",
 CellID->31550],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "GuideMoreAboutSub",
 CellID->2097],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAboutSub",
 CellID->350007888]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Procedural Programming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 48.6902974}", "context" -> "", 
    "keywords" -> {
     "blocks", "branch", "code", "combine conditions", "conditional", 
      "conditionals", "control flow", "dynamic scoping", "else", 
      "exception handling", "fixed variables", "fluid variables", 
      "functional composition", "functions", "handling", "handling of errors",
       "imperative", "iterated functions", "iteration", "jump", 
      "lexical scoping", "local constants", "local values", "macros", 
      "multiple conditional", "multiple cases", "nesting of functions", 
      "non-local returns", "procedure", "procedures", "programs", "repeat", 
      "repeating expressions", "requesting input", "returns", "routines", 
      "scope", "scoping", "static scoping", "stop", "strings", "subroutines", 
      "symbols", "temporary values", "then", "until", "routines", 
      "subroutines"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica stands out from traditional computer languages in supporting \
many programming paradigms. Procedural programming is the only paradigm \
available in languages like C and Java, as well as most scripting languages. \
Mathematica supports all standard procedural programming constructs, but \
often extends them through integration into its more general symbolic \
programming environment.", "synonyms" -> {}, "title" -> 
    "Procedural Programming", "type" -> "Guide", "uri" -> 
    "guide/ProceduralProgramming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->6508],
Cell[681, 28, 534, 12, 70, "GuideAbstract",
 CellID->25149],
Cell[1218, 42, 386, 15, 70, "GuideText",
 CellID->31920],
Cell[1607, 59, 677, 23, 70, "GuideText",
 CellID->10106],
Cell[2287, 84, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->19271],
Cell[CellGroupData[{
Cell[2366, 89, 206, 5, 70, "GuideFunctionsSubsection",
 CellID->12368],
Cell[2575, 96, 1190, 35, 70, "InlineGuideFunctionListing",
 CellID->6421]
}, Open  ]],
Cell[CellGroupData[{
Cell[3802, 136, 206, 5, 70, "GuideFunctionsSubsection",
 CellID->15258],
Cell[4011, 143, 1187, 35, 70, "InlineGuideFunctionListing",
 CellID->4157]
}, Open  ]],
Cell[CellGroupData[{
Cell[5235, 183, 207, 5, 70, "GuideFunctionsSubsection",
 CellID->9647],
Cell[5445, 190, 1697, 56, 70, "InlineGuideFunctionListing",
 CellID->4982]
}, Open  ]],
Cell[CellGroupData[{
Cell[7179, 251, 207, 5, 70, "GuideFunctionsSubsection",
 CellID->18238],
Cell[7389, 258, 1014, 29, 70, "InlineGuideFunctionListing",
 CellID->24122]
}, Open  ]],
Cell[CellGroupData[{
Cell[8440, 292, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->244574497],
Cell[8666, 299, 800, 23, 70, "InlineGuideFunctionListing",
 CellID->456834773]
}, Open  ]],
Cell[CellGroupData[{
Cell[9503, 327, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->17723],
Cell[9738, 334, 1221, 36, 70, "InlineGuideFunctionListing",
 CellID->906]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11008, 376, 58, 1, 70, "GuideTutorialsSection",
 CellID->18706],
Cell[11069, 379, 163, 3, 70, "GuideTutorial",
 CellID->166318243],
Cell[11235, 384, 169, 3, 70, "GuideTutorial",
 CellID->71307028],
Cell[11407, 389, 143, 3, 70, "GuideTutorial",
 CellID->332730818],
Cell[11553, 394, 172, 3, 70, "GuideTutorial",
 CellID->674100989],
Cell[11728, 399, 170, 3, 70, "GuideTutorial",
 CellID->400781559],
Cell[11901, 404, 172, 3, 70, "GuideTutorial",
 CellID->417067063]
}, Open  ]],
Cell[CellGroupData[{
Cell[12110, 412, 59, 1, 70, "GuideMoreAboutSection",
 CellID->30345],
Cell[12172, 415, 142, 3, 70, "GuideMoreAbout",
 CellID->12351],
Cell[12317, 420, 151, 3, 70, "GuideMoreAboutSub",
 CellID->31550],
Cell[12471, 425, 158, 3, 70, "GuideMoreAboutSub",
 CellID->2097],
Cell[12632, 430, 157, 3, 70, "GuideMoreAboutSub",
 CellID->350007888]
}, Open  ]],
Cell[12804, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

