(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10477,        352]
NotebookOptionsPosition[      6668,        248]
NotebookOutlinePosition[      8742,        293]
CellTagsIndexPosition[      8699,        290]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Rational Functions", "GuideTitle",
 CellID->32652],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can efficiently handle both univariate and multivariate rational \
functions, with built-in functions immediately implementing standard \
algebraic transformations."
}], "GuideAbstract",
 CellID->130134447],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apart"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "decompose into partial fractions with minimal denominators"
}], "GuideText",
 CellID->435],

Cell[TextData[{
 Cell[TextData[ButtonBox["Together",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Together"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put rational functions over a common denominator"
}], "GuideText",
 CellID->16693],

Cell["\t", "GuideDelimiter",
 CellID->15072],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cancel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cancel"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cancel common factors between numerator and denominator"
}], "GuideText",
 CellID->17916],

Cell[TextData[{
 Cell[TextData[ButtonBox["Numerator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Numerator"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Denominator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Denominator"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pick out numerator, denominator"
}], "GuideText",
 CellID->6716],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialRemainder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialQuotient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25328],

Cell["\t", "GuideDelimiter",
 CellID->1511],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " factor numerator and denominator, cancelling common factors"
}], "GuideText",
 CellID->791356655],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand everything except denominators"
}], "GuideText",
 CellID->32125],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpandAll"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand everything, including denominators"
}], "GuideText",
 CellID->11838],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandNumerator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExpandDenominator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpandDenominator"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand numerators and denominators only"
}], "GuideText",
 CellID->27296],

Cell["\t", "GuideDelimiter",
 CellID->586854495],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadeApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PadeApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a rational approximation to any function"
}], "GuideText",
 CellID->187318205],

Cell[CellGroupData[{

Cell["Operations on Rational Functions", "GuideFunctionsSubsection",
 CellID->18939],

Cell[TextData[{
 Cell[TextData[ButtonBox["Residue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Residue"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11544]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1056],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], \
"GuideTutorial",
 CellID->317333015],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "GuideTutorial",
 CellID->54754351],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "GuideTutorial",
 CellID->130101737],

Cell[TextData[ButtonBox["Transforming Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformingAlgebraicExpressions"]], "GuideTutorial",
 CellID->94840692]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->26758],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->24588],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "GuideMoreAbout",
 CellID->12021],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rational Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 54.2529398}", "context" -> "", 
    "keywords" -> {
     "cancel out", "collecting over common denominators", "collecting terms", 
      "common denominator", "common factors", "denom", "denominator", 
      "denominators", "divide by", "dividend", "division", 
      "division of polynomials", "divisor", "expand all", 
      "expand denominator", "expand numerator", "expansion", "factoring", 
      "factoring over extension fields", "fractions", 
      "greatest common divisor", "irreducibility", "modular factorization", 
      "numer", "numerator", "Pade' approximant", "Pade' technique", 
      "partial fractions", "polynomial division", "polynomial factorization", 
      "polynomial quotient", "polynomial remainder", "prime elements", "quot",
       "quotient", "quotient of polynomials", "rational function", "rem", 
      "remainder", "remainder in polynomial division", "res", 
      "singularity of meromorphic function", "top of fraction", "UFD", 
      "unique factorization domain"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica can efficiently handle both univariate and multivariate \
rational functions, with built-in functions immediately implementing standard \
algebraic transformations.", "synonyms" -> {}, "title" -> 
    "Rational Functions", "type" -> "Guide", "uri" -> 
    "guide/RationalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->32652],
Cell[678, 28, 274, 7, 70, "GuideAbstract",
 CellID->130134447],
Cell[955, 37, 275, 9, 70, "GuideText",
 CellID->435],
Cell[1233, 48, 273, 9, 70, "GuideText",
 CellID->16693],
Cell[1509, 59, 44, 1, 70, "GuideDelimiter",
 CellID->15072],
Cell[1556, 62, 276, 9, 70, "GuideText",
 CellID->17916],
Cell[1835, 73, 390, 13, 70, "GuideText",
 CellID->6716],
Cell[2228, 88, 434, 11, 70, "InlineGuideFunctionListing",
 CellID->25328],
Cell[2665, 101, 43, 1, 70, "GuideDelimiter",
 CellID->1511],
Cell[2711, 104, 279, 8, 70, "GuideText",
 CellID->791356655],
Cell[2993, 114, 258, 9, 70, "GuideText",
 CellID->32125],
Cell[3254, 125, 268, 9, 70, "GuideText",
 CellID->11838],
Cell[3525, 136, 423, 13, 70, "GuideText",
 CellID->27296],
Cell[3951, 151, 48, 1, 70, "GuideDelimiter",
 CellID->586854495],
Cell[4002, 154, 433, 12, 70, "GuideText",
 CellID->187318205],
Cell[CellGroupData[{
Cell[4460, 170, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->18939],
Cell[4547, 173, 590, 17, 70, "InlineGuideFunctionListing",
 CellID->11544]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5186, 196, 57, 1, 70, "GuideTutorialsSection",
 CellID->1056],
Cell[5246, 199, 210, 5, 70, "GuideTutorial",
 CellID->317333015],
Cell[5459, 206, 188, 4, 70, "GuideTutorial",
 CellID->54754351],
Cell[5650, 212, 198, 4, 70, "GuideTutorial",
 CellID->130101737],
Cell[5851, 218, 187, 4, 70, "GuideTutorial",
 CellID->94840692]
}, Open  ]],
Cell[CellGroupData[{
Cell[6075, 227, 59, 1, 70, "GuideMoreAboutSection",
 CellID->26758],
Cell[6137, 230, 148, 3, 70, "GuideMoreAbout",
 CellID->24588],
Cell[6288, 235, 162, 3, 70, "GuideMoreAbout",
 CellID->12021],
Cell[6453, 240, 173, 3, 70, "GuideMoreAbout",
 CellID->31201602]
}, Open  ]],
Cell[6641, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

