(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16206,        534]
NotebookOptionsPosition[     11224,        410]
NotebookOutlinePosition[     14067,        465]
CellTagsIndexPosition[     14024,        462]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Rules & Patterns", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "At the core of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic programming paradigm is the concept of transformation rules for \
arbitrary symbolic patterns. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s",
 " pattern language conveniently describes a very general set of classes of \
expressions, making possible uniquely readable, elegant and efficient \
programs. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Rules \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Rules"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->855719743],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"],
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Rule",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " representation of replacement rule"
}], "GuideText",
 CellID->136647404],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"],
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"],
  StyleBox[ButtonBox["rules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply replacement rules to an expression"
}], "GuideText",
 CellID->1205848],

Cell[TextData[{
 Cell[TextData[ButtonBox["RuleDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[":>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplaceRepeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["//.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Condition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["/;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Rules"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->426380925],

Cell["\t", "GuideDelimiterSubsection",
 CellID->29748727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Patterns \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Patterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->297546511],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any expression, named ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->243558837],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankSequence"], "TI"],
  ButtonBox["__",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankSequence"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of expressions"
}], "GuideText",
 CellID->221806116],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["a",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"],
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"],
  StyleBox[ButtonBox["b",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"],
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"],
  StyleBox[ButtonBox["c",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " alternative forms"
}], "GuideText",
 CellID->214293291],

Cell[TextData[{
 Cell[TextData[ButtonBox["Repeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["..",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Except",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Except"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Longest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Longest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Shortest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Shortest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Patterns"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->585851726],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Pattern Matching Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PatternMatchingFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->75566001],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " elements of a list or expression matching a given pattern"
}], "GuideText",
 CellID->412654777],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatchQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Count",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Count"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteCases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PatternMatchingFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->38056567],

Cell["\t", "GuideDelimiterSubsection",
 CellID->716820316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Assignments \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Assignments"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->182186973],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make assignments for arbitrary patterns"
}], "GuideText",
 CellID->700518034]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsAndTransformationRules"]], "GuideTutorial",
 CellID->231261676],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "GuideTutorial",\

 CellID->196482616],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "GuideTutorial",\

 CellID->302153571],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/VariablesInPureFunctionsAndRules"]], "GuideTutorial",
 CellID->413462860],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "GuideTutorial",
 CellID->633702806],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "GuideTutorial",
 CellID->13947359]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rules & Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 57.7374040}", "context" -> "", 
    "keywords" -> {
     "applicability of transformation rules", "arrow", "avoiding matches", 
      "complementary patterns", "conditions", "constraints", "contains", 
      "controlled transformations", "criteria", "deferred evaluation", 
      "delayed evaluation", "delayed rules", "delete cases", "depends on", 
      "disambiguating pattern matches", "domain", "element of a list", 
      "evaluation at a point", "excluded patterns", "greedy match", 
      "immediate rules", "indices", "levels", "list member", 
      "logic programming", "longest pattern match", "longest sequence", 
      "matching", "membership test", "non-greedy match", 
      "number of occurrences", "one or more", "one-or-more", "parts", 
      "pattern condition", "pattern matching", "patterns", "present in list", 
      "preventing evaluation in rules", "priorities on pattern matches", 
      "provided that", "regular expression", 
      "removing elements that match a pattern", "repeated expression", 
      "repeated pattern", "repeated rule application", "replace all", 
      "replace repeated", "replacement", "replacements", "ReplaceRepeated", 
      "restricted pattern", "restriction", 
      "restrictions on transformation rules", "rule-based programming", 
      "rule delayed", "rules", "search", "shortest pattern match", 
      "slash-dot", "slash-semi", "slash-slash-dot", "substitution", 
      "template matching", "temporary binding", "test for elements in lists", 
      "test for pattern match", "testing for matching of patterns", 
      "testing for presence", "transformation rules", "whenever", "where"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "At the core of Mathematica's symbolic programming paradigm is the \
concept of transformation rules for arbitrary symbolic patterns. \
Mathematica's pattern language conveniently describes a very general set of \
classes of expressions, making possible uniquely readable, elegant and \
efficient programs. ", "synonyms" -> {}, "title" -> "Rules & Patterns", 
    "type" -> "Guide", "uri" -> "guide/RulesAndPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[680, 28, 456, 13, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1161, 45, 198, 5, 70, "GuideFunctionsSubsection",
 CellID->855719743],
Cell[1362, 52, 571, 21, 70, "GuideText",
 CellID->136647404],
Cell[1936, 75, 603, 21, 70, "GuideText",
 CellID->1205848],
Cell[2542, 98, 1164, 38, 70, "InlineGuideFunctionListing",
 CellID->426380925],
Cell[3709, 138, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->29748727]
}, Open  ]],
Cell[CellGroupData[{
Cell[3803, 144, 204, 5, 70, "GuideFunctionsSubsection",
 CellID->297546511],
Cell[4010, 151, 400, 15, 70, "GuideText",
 CellID->243558837],
Cell[4413, 168, 354, 13, 70, "GuideText",
 CellID->221806116],
Cell[4770, 183, 623, 22, 70, "GuideText",
 CellID->214293291],
Cell[5396, 207, 1409, 40, 70, "InlineGuideFunctionListing",
 CellID->585851726],
Cell[6808, 249, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[6903, 255, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->75566001],
Cell[7145, 263, 275, 8, 70, "GuideText",
 CellID->412654777],
Cell[7423, 273, 1237, 36, 70, "InlineGuideFunctionListing",
 CellID->38056567],
Cell[8663, 311, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->716820316]
}, Open  ]],
Cell[CellGroupData[{
Cell[8758, 317, 210, 5, 70, "GuideFunctionsSubsection",
 CellID->182186973],
Cell[8971, 324, 770, 28, 70, "GuideText",
 CellID->700518034]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9790, 358, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9855, 361, 185, 4, 70, "GuideTutorial",
 CellID->231261676],
Cell[10043, 367, 180, 4, 70, "GuideTutorial",
 CellID->196482616],
Cell[10226, 373, 177, 4, 70, "GuideTutorial",
 CellID->302153571],
Cell[10406, 379, 191, 4, 70, "GuideTutorial",
 CellID->413462860],
Cell[10600, 385, 148, 3, 70, "GuideTutorial",
 CellID->633702806],
Cell[10751, 390, 182, 4, 70, "GuideTutorial",
 CellID->13947359]
}, Open  ]],
Cell[CellGroupData[{
Cell[10970, 399, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11035, 402, 147, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[11197, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

