(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12848,        428]
NotebookOptionsPosition[      8335,        306]
NotebookOutlinePosition[     10645,        353]
CellTagsIndexPosition[     10602,        350]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Series Expansions", "GuideTitle",
 CellID->17377],

Cell[TextData[{
 "Power series are in many ways the algebraic analog of limited-precision \
numbers. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can generate series approximations to virtually any combination of \
built-in mathematical functions. It will then automatically combine series \
truncating to the correct order. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports not only ordinary power series, but also Laurent series, Puiseux \
series, as well as complex asymptotic expansions for special functions with \
elaborate branch cut structures. Many of the formulas used are original to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "GuideAbstract",
 CellID->10130],

Cell[TextData[{
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " construct a series expansion in one or more variables"
}], "GuideText",
 CellID->25253],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Normal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from a series expansion to an ordinary expression"
}], "GuideText",
 CellID->15000],

Cell[TextData[{
 Cell[TextData[ButtonBox["O",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/O"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic representation of a higher-order series term"
}], "GuideText",
 CellID->27754],

Cell[TextData[{
 Cell[TextData[ButtonBox["Assumptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Assumptions"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Assuming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Assuming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give assumptions about parameters"
}], "GuideText",
 CellID->289],

Cell["\t", "GuideDelimiter",
 CellID->32488],

Cell[TextData[{
 Cell[TextData[ButtonBox["Coefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Coefficient"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coefficient of a particular term in an ordinary power series"
}], "GuideText",
 CellID->25215],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coefficients in an ordinary power series"
}], "GuideText",
 CellID->12008],

Cell[TextData[{
 Cell[TextData[ButtonBox["SeriesCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coefficient of a term in a general series"
}], "GuideText",
 CellID->31310],

Cell["\t", "GuideDelimiter",
 CellID->940],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseSeries"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the functional inverse of a series"
}], "GuideText",
 CellID->27799],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComposeSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComposeSeries"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the functional composition of series"
}], "GuideText",
 CellID->2997],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Limit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Limit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the limit of a series at its expansion point"
}], "GuideText",
 CellID->8454],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " integrate a series"
}], "GuideText",
 CellID->304],

Cell[TextData[{
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " differentiate a series"
}], "GuideText",
 CellID->8237],

Cell["\t", "GuideDelimiter",
 CellID->154256035],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogicalExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogicalExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand out equations for series"
}], "GuideText",
 CellID->12499],

Cell["\t", "GuideDelimiter",
 CellID->728038933],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadeApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PadeApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a rational approximation to a function"
}], "GuideText",
 CellID->15617410]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->30792],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "GuideTutorial",
 CellID->5095854],

Cell[TextData[ButtonBox["Making Power Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingPowerSeriesExpansions"]], "GuideTutorial",\

 CellID->689804047],

Cell[TextData[ButtonBox["Operations on Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnPowerSeries"]], "GuideTutorial",
 CellID->198653972],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfPowerSeries"]], "GuideTutorial",
 CellID->28198204],

Cell[TextData[ButtonBox["Converting Power Series to Normal Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]], \
"GuideTutorial",
 CellID->156047878]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18682],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"GuideMoreAboutSub",
 CellID->17137],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAboutSub",
 CellID->5033],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FourierSeries/guide/FourierSeriesPackage"]], "GuideMoreAboutSub",
 CellID->10293],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/guide/NumericalCalculusPackage"]], \
"GuideMoreAboutSub",
 CellID->32053]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->155037723],

Cell[TextData[{
 ButtonBox["Demonstrations related to Series Expansions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22series%22+content%3AAssuming+OR+Assumptions+OR+Coefficient+OR+\
CoefficientList+OR+ComposeSeries+OR+D+OR+Integrate+OR+InverseSeries+OR+Limit+\
OR+LogicalExpand+OR+Normal+OR+O+OR+PadeApproximant+OR+Series+OR+\
SeriesCoefficient"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->63284748]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series Expansions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 2.1906430}", "context" -> "", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "approximations", 
      "asymptotic expansions", "asymptotic value", "big-O notation", "coef", 
      "coefficient list", "coefficient of a polynomial", "compose series", 
      "directed limit", "formal series", "functional composition", 
      "inverse of power series", "inverse series", "Landau symbol", 
      "Laurent series", "lim", "limiting value", "Maclaurin series", 
      "Maclaurin series expansion", "polynomial coefficient", 
      "polynomial coefficients", "power series", "power series expansion", 
      "reversion of power series", "series coefficient", 
      "series coefficients", "series expansions", "series terms", 
      "substitute series", "Taylor series", "Taylor series expansion", 
      "truncation of power series", "value at discontinuity"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Power series are in many ways the algebraic analog of limited-precision \
numbers. Mathematica can generate series approximations to virtually any \
combination of built-in mathematical functions. It will then automatically \
combine series truncating to the correct order. Mathematica supports not only \
ordinary power series, but also Laurent series, Puiseux series, as well as \
complex asymptotic expansions for special functions with elaborate branch cut \
structures. Many of the formulas used are original to Mathematica.", 
    "synonyms" -> {}, "title" -> "Series Expansions", "type" -> "Guide", 
    "uri" -> "guide/SeriesExpansions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->17377],
Cell[677, 28, 712, 17, 70, "GuideAbstract",
 CellID->10130],
Cell[1392, 47, 269, 8, 70, "GuideText",
 CellID->25253],
Cell[1664, 57, 273, 8, 70, "GuideText",
 CellID->15000],
Cell[1940, 67, 259, 8, 70, "GuideText",
 CellID->27754],
Cell[2202, 77, 384, 12, 70, "GuideText",
 CellID->289],
Cell[2589, 91, 44, 1, 70, "GuideDelimiter",
 CellID->32488],
Cell[2636, 94, 286, 8, 70, "GuideText",
 CellID->25215],
Cell[2925, 104, 274, 8, 70, "GuideText",
 CellID->12008],
Cell[3202, 114, 279, 8, 70, "GuideText",
 CellID->31310],
Cell[3484, 124, 42, 1, 70, "GuideDelimiter",
 CellID->940],
Cell[3529, 127, 269, 8, 70, "GuideText",
 CellID->27799],
Cell[3801, 137, 270, 8, 70, "GuideText",
 CellID->2997],
Cell[4074, 147, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4125, 150, 262, 8, 70, "GuideText",
 CellID->8454],
Cell[4390, 160, 238, 8, 70, "GuideText",
 CellID->304],
Cell[4631, 170, 227, 8, 70, "GuideText",
 CellID->8237],
Cell[4861, 180, 48, 1, 70, "GuideDelimiter",
 CellID->154256035],
Cell[4912, 183, 261, 8, 70, "GuideText",
 CellID->12499],
Cell[5176, 193, 48, 1, 70, "GuideDelimiter",
 CellID->728038933],
Cell[5227, 196, 435, 12, 70, "GuideText",
 CellID->15617410]
}, Open  ]],
Cell[CellGroupData[{
Cell[5699, 213, 58, 1, 70, "GuideTutorialsSection",
 CellID->30792],
Cell[5760, 216, 140, 3, 70, "GuideTutorial",
 CellID->5095854],
Cell[5903, 221, 178, 4, 70, "GuideTutorial",
 CellID->689804047],
Cell[6084, 227, 168, 3, 70, "GuideTutorial",
 CellID->198653972],
Cell[6255, 232, 185, 4, 70, "GuideTutorial",
 CellID->28198204],
Cell[6443, 238, 209, 5, 70, "GuideTutorial",
 CellID->156047878]
}, Open  ]],
Cell[CellGroupData[{
Cell[6689, 248, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18682],
Cell[6751, 251, 204, 5, 70, "GuideMoreAboutSub",
 CellID->17137],
Cell[6958, 258, 190, 4, 70, "GuideMoreAboutSub",
 CellID->5033],
Cell[7151, 264, 175, 4, 70, "GuideMoreAboutSub",
 CellID->10293],
Cell[7329, 270, 189, 5, 70, "GuideMoreAboutSub",
 CellID->32053]
}, Open  ]],
Cell[CellGroupData[{
Cell[7555, 280, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->155037723],
Cell[7627, 283, 666, 18, 70, "GuideRelatedLinks",
 CellID->63284748]
}, Open  ]],
Cell[8308, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

