(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11886,        367]
NotebookOptionsPosition[      7413,        257]
NotebookOutlinePosition[     10300,        312]
CellTagsIndexPosition[     10257,        309]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Sparse Arrays", "GuideTitle",
 CellID->9793],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has special sparse-array technology for efficiently handling arrays with \
literally astronomical numbers of elements when only a small fraction of the \
elements are nonzero. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s linear algebra and all standard list operations can be done in symbolic \
form on ",
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " objects, in which nonzero elements are specified by giving \
rules\[LongDash]potentially including patterns\[LongDash]for the values of \
elements at particular positions. "
}], "GuideAbstract",
 CellID->28505],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a sparse array of any rank from a list of rules or a dense array"
}], "GuideText",
 CellID->29465],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Normal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert a sparse array to a dense array of explicit lists"
}], "GuideText",
 CellID->12239],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayRules",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayRules"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find position\[Rule]value rules for elements in a sparse array"
}], "GuideText",
 CellID->26206],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert symbolic equations to sparse arrays"
}], "GuideText",
 CellID->24209],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " visualize a 2D sparse array using grayscales or other color maps"
}], "GuideText",
 CellID->565253937],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatrixPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " visualize a sparse matrix with color, ticks, etc."
}], "GuideText",
 CellID->16499],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " take a sparse array as the adjacency matrix for a graph"
}], "GuideText",
 CellID->134560891],

Cell[CellGroupData[{

Cell["Sparse Linear Algebra", "GuideFunctionsSubsection",
 CellID->18175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Eigenvalues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Eigenvalues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SingularValueList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->31036]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import/Export Formats", "GuideFunctionsSubsection",
 CellID->23061],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MTX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"HarwellBoeing\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13647]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->15618],

Cell[TextData[ButtonBox["Sparse Arrays: Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SparseArrays-ManipulatingLists"]], "GuideTutorial",
 CellID->316808061],

Cell[TextData[ButtonBox["Sparse Arrays: Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-LinearAlgebra"]], "GuideTutorial",
 CellID->466098004]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15712],

Cell[TextData[ButtonBox["Matrices & Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "GuideMoreAbout",
 CellID->27896],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "GuideMoreAbout",
 CellID->21909]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->229912150],

Cell[TextData[{
 ButtonBox["Demonstrations related to Sparse Arrays",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22sparse+arrays%22+content%3AArrayPlot+OR+ArrayRules+OR+CoefficientArrays+OR+\
Dot+OR+Eigenvalues+OR+GraphPlot+OR+LinearSolve+OR+MatrixPlot+OR+Normal+OR+\
Outer+OR+SingularValueList+OR+SparseArray"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->294489362]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sparse Arrays - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 4.2063196}", "context" -> "", 
    "keywords" -> {
     "Arnoldi methods", "ARPACK", "array plot", "array rules", "arrays", 
      "band-diagonal matrices", "Cartesian products", "coefficient arrays", 
      "condition number of matrices", "diagonalization", "diagonalize", 
      "digraph layout", "direct products", "direct products of tensors", 
      "direct solver methods", "division of matrices", "dot product", 
      "dyadic products", "elements plot", "exterior products", 
      "Gaussian elimination", "generalized eigenvalues", "graph drawing", 
      "graph embedding", "graph layout", "graph plot", "graph visualization", 
      "hashing", "homogeneous forms", "inner products", 
      "Kronecker products of tensors", "Krylov methods", "linear equations", 
      "LINPACK", "lists", "matrices", "matrix equations", 
      "matrix multiplication", "matrix multiply", "matrix pencils", 
      "matrix plot", "matrix structure plot", "matrix vector multiplication", 
      "multifrontal methods", "multiplication", "nary forms", 
      "network layout", "network visualization", "normal window frame option",
       "outer products", "position-value pairs", "quadratic forms", 
      "scalar product", "singular eigenvalue problem", "singular value list", 
      "solution of linear systems", "sparse array", "sparse matrices", 
      "sparse matrix", "sparse representation", "sparse vector", 
      "specify elements in sparse array", "tensor products", "tensors", 
      "truncation of power series", "UMFPACK", "vectors", "wedge product"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has special sparse-array technology for efficiently handling \
arrays with literally astronomical numbers of elements when only a small \
fraction of the elements are nonzero. Mathematica's linear algebra and all \
standard list operations can be done in symbolic form on SparseArray objects, \
in which nonzero elements are specified by giving rules--potentially \
including patterns--for the values of elements at particular positions. ", 
    "synonyms" -> {}, "title" -> "Sparse Arrays", "type" -> "Guide", "uri" -> 
    "guide/SparseArrays"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->9793],
Cell[672, 28, 725, 17, 70, "GuideAbstract",
 CellID->28505],
Cell[1400, 47, 302, 9, 70, "GuideText",
 CellID->29465],
Cell[1705, 58, 278, 9, 70, "GuideText",
 CellID->12239],
Cell[1986, 69, 291, 9, 70, "GuideText",
 CellID->26206],
Cell[2280, 80, 286, 9, 70, "GuideText",
 CellID->24209],
Cell[2569, 91, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2620, 94, 290, 8, 70, "GuideText",
 CellID->565253937],
Cell[2913, 104, 418, 11, 70, "GuideText",
 CellID->16499],
Cell[3334, 117, 426, 11, 70, "GuideText",
 CellID->134560891],
Cell[CellGroupData[{
Cell[3785, 132, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->18175],
Cell[3861, 135, 1158, 33, 70, "InlineGuideFunctionListing",
 CellID->31036]
}, Open  ]],
Cell[CellGroupData[{
Cell[5056, 173, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->23061],
Cell[5132, 176, 623, 17, 70, "InlineGuideFunctionListing",
 CellID->13647]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5804, 199, 58, 1, 70, "GuideTutorialsSection",
 CellID->15618],
Cell[5865, 202, 185, 4, 70, "GuideTutorial",
 CellID->316808061],
Cell[6053, 208, 174, 3, 70, "GuideTutorial",
 CellID->466098004]
}, Open  ]],
Cell[CellGroupData[{
Cell[6264, 216, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15712],
Cell[6326, 219, 162, 3, 70, "GuideMoreAbout",
 CellID->27896],
Cell[6491, 224, 140, 3, 70, "GuideMoreAbout",
 CellID->21909]
}, Open  ]],
Cell[CellGroupData[{
Cell[6668, 232, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->229912150],
Cell[6740, 235, 631, 17, 70, "GuideRelatedLinks",
 CellID->294489362]
}, Open  ]],
Cell[7386, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

