(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24299,        715]
NotebookOptionsPosition[     17248,        542]
NotebookOutlinePosition[     21006,        610]
CellTagsIndexPosition[     20963,        607]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Statistics", "GuideTitle",
 CellID->18129],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides integrated support both for classical statistics and for modern \
large-scale data analysis. Its symbolic character allows broader coverage, \
with symbolic manipulation of statistical distributions, symbolic \
specification of functions and models, and general symbolic representations \
of large-scale data properties. Incorporating the latest numerics and \
computational geometry algorithms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides high-accuracy and high-reliability statistical results for \
datasets of almost unlimited size. "
}], "GuideAbstract",
 CellID->21358],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Quantities \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DescriptiveStatistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->268772646],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StandardDeviation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StandardDeviation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Median",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Median"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Covariance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Covariance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DescriptiveStatistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->23105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Statistical Distributions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StatisticalDistributions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->457507075],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8870049],

Cell[TextData[{
 Cell[TextData[ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "probability density function, cumulative density function"
}], "GuideText",
 CellID->122109823]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Data Fitting \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->446243540],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find a general nonlinear fit"
}], "GuideText",
 CellID->20065],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->649417926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Data Smoothing \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataTransformsAndSmoothing"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->332535342],

Cell[TextData[{
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingMedian",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingMedian"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListCorrelate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListCorrelate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->41515262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Exploratory Data Analysis \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DataClassification"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->32917008],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataClassification"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->661574159]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Random Sampling \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RandomNumberGeneration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->245467654],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RandomNumberGeneration"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->619537876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Importing Data \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExporting"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->714115726],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"CSV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CSV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15034744]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->12516],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "GuideTutorial",
 CellID->14481],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "GuideTutorial",
 CellID->15579],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "GuideTutorial",
 CellID->73377947],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "GuideTutorial",
 CellID->58175659],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "GuideTutorial",\

 CellID->140382176],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "GuideTutorial",
 CellID->664059042],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->177357799],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "GuideTutorial",
 CellID->667388196],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "GuideTutorial",
 CellID->226520497]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->9023],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "GuideMoreAbout",
 CellID->1727],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->196026298],

Cell[TextData[ButtonBox["Linear Regression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->1771],

Cell[TextData[ButtonBox["Nonlinear Regression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAboutSub",
 CellID->374687295],

Cell[TextData[ButtonBox["Analysis of Variance",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ANOVA/guide/AnalysisOfVariancePackage"]], "GuideMoreAboutSub",
 CellID->276911616],

Cell[TextData[ButtonBox["Hypothesis Testing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/guide/HypothesisTestingPackage"]], \
"GuideMoreAboutSub",
 CellID->287447553],

Cell[TextData[ButtonBox["Multivariate Statistics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"]], \
"GuideMoreAboutSub",
 CellID->43891222],

Cell[TextData[ButtonBox["Hierarchical Clustering",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/guide/HierarchicalClusteringPackage"]], \
"GuideMoreAboutSub",
 CellID->558555719],

Cell[TextData[ButtonBox["Statistical Plots",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/guide/StatisticalPlotsPackage"]], \
"GuideMoreAboutSub",
 CellID->173266127],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "GuideMoreAbout",
 CellID->14247681]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1846400784],

Cell[TextData[{
 ButtonBox["Demonstrations related to Statistics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22statistics%22+content%3ABinCounts+OR+CDF+OR+ChiSquareDistribution+OR+\
FindClusters+OR+FindFit+OR+Fit+OR+Interpolation+OR+LeastSquares+OR+\
ListCorrelate+OR+Mean+OR+Median+OR+MovingAverage+OR+MovingMedian+OR+Nearest+\
OR+NormalDistribution+OR+PDF+OR+PoissonDistribution+OR+Quantile+OR+\
RandomChoice+OR+RandomInteger+OR+RandomReal+OR+StandardDeviation+OR+Variance"]\
, None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->264262083]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statistics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 11.1908734}", "context" -> "", 
    "keywords" -> {
     "2nd quartile", "50th percentile", "agglomeration", "arrays", "average", 
      "avg", "bilinear interpolation", "bin counts", "binning", 
      "category counts", "CDF", "central value", "chi square distribution", 
      "chi squared", "chi squared distribution", "cluster", 
      "cluster analysis", "clustering", "clustering of data", 
      "comma-separated values", "confidence intervals", "correlations", 
      "cumulative distribution function", "curve fitting", "deciles", 
      "density estimation", "density function", "dispersion", "distribution", 
      "distribution function", "empirical distribution", "excel format", 
      "expectation", "expected value", "find clusters", "find fit", 
      "fitting curves", "fitting of data", "Gauss integral", 
      "Gaussian distribution", "Gaussian integral", "grouping of data", 
      "histogram", "infrequent events", "interp", "interpolate data", 
      "interpolate equation", "interpolate formula", "interpolate numbers", 
      "interpolate table", "interquartile range", "least squares", 
      "least-squares", "least-squares fits", "linear fits", 
      "linear interpolation", "linear moving average", "list correlate", 
      "Lotus 1-2-3 format", "MA", "mass function", "mean", "median", "models",
       "moving average", "moving mean", "moving median", 
      "non-frequent events", "nonlinear fitting", "normal distribution", 
      "order statistics", "partitioning of data", "percentiles", 
      "Poisson distribution", "Poisson process", "prob", 
      "probability density function", "probability distribution", 
      "probability function", "probability mass function", "quantile", 
      "quartiles", "rand", "random choice", "random integer", "random real", 
      "random selection", "randomint", "range counts", "rare events", 
      "residuals", "rnd", "sample standard deviation", "sample variance", 
      "sampling with replacement", "select randomly", "simple moving average",
       "SMA", "spread", "spreadsheets", "standard deviation", 
      "standard error", "standard normal distribution", "tab-delimited data", 
      "tables", "tabular data", "testing models", "trend line", "TSV format", 
      "VAR", "variance", "Weibull quantile method", "weighted moving average",
       "WMA", "XLS format"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica provides integrated support both for classical statistics \
and for modern large-scale data analysis. Its symbolic character allows \
broader coverage, with symbolic manipulation of statistical distributions, \
symbolic specification of functions and models, and general symbolic \
representations of large-scale data properties. Incorporating the latest \
numerics and computational geometry algorithms, Mathematica provides \
high-accuracy and high-reliability statistical results for datasets of almost \
unlimited size. ", "synonyms" -> {}, "title" -> "Statistics", "type" -> 
    "Guide", "uri" -> "guide/Statistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 48, 1, 70, "GuideTitle",
 CellID->18129],
Cell[670, 28, 671, 14, 70, "GuideAbstract",
 CellID->21358],
Cell[CellGroupData[{
Cell[1366, 46, 231, 5, 70, "GuideFunctionsSubsection",
 CellID->268772646],
Cell[1600, 53, 1452, 41, 70, "InlineGuideFunctionListing",
 CellID->23105]
}, Open  ]],
Cell[CellGroupData[{
Cell[3089, 99, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->457507075],
Cell[3331, 107, 1329, 33, 70, "InlineGuideFunctionListing",
 CellID->8870049],
Cell[4663, 142, 683, 19, 70, "GuideText",
 CellID->122109823]
}, Open  ]],
Cell[CellGroupData[{
Cell[5383, 166, 235, 5, 70, "GuideFunctionsSubsection",
 CellID->446243540],
Cell[5621, 173, 246, 8, 70, "GuideText",
 CellID->20065],
Cell[5870, 183, 992, 27, 70, "InlineGuideFunctionListing",
 CellID->649417926]
}, Open  ]],
Cell[CellGroupData[{
Cell[6899, 215, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->332535342],
Cell[7130, 222, 1147, 30, 70, "InlineGuideFunctionListing",
 CellID->41515262]
}, Open  ]],
Cell[CellGroupData[{
Cell[8314, 257, 232, 6, 70, "GuideFunctionsSubsection",
 CellID->32917008],
Cell[8549, 265, 1262, 32, 70, "InlineGuideFunctionListing",
 CellID->661574159]
}, Open  ]],
Cell[CellGroupData[{
Cell[9848, 302, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->245467654],
Cell[10076, 309, 1280, 32, 70, "InlineGuideFunctionListing",
 CellID->619537876]
}, Open  ]],
Cell[CellGroupData[{
Cell[11393, 346, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->714115726],
Cell[11619, 353, 1028, 29, 70, "InlineGuideFunctionListing",
 CellID->15034744]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12696, 388, 58, 1, 70, "GuideTutorialsSection",
 CellID->12516],
Cell[12757, 391, 146, 3, 70, "GuideTutorial",
 CellID->14481],
Cell[12906, 396, 162, 3, 70, "GuideTutorial",
 CellID->15579],
Cell[13071, 401, 161, 3, 70, "GuideTutorial",
 CellID->73377947],
Cell[13235, 406, 161, 3, 70, "GuideTutorial",
 CellID->58175659],
Cell[13399, 411, 177, 4, 70, "GuideTutorial",
 CellID->140382176],
Cell[13579, 417, 144, 3, 70, "GuideTutorial",
 CellID->664059042],
Cell[13726, 422, 172, 3, 70, "GuideTutorial",
 CellID->177357799],
Cell[13901, 427, 158, 3, 70, "GuideTutorial",
 CellID->667388196],
Cell[14062, 432, 165, 3, 70, "GuideTutorial",
 CellID->226520497]
}, Open  ]],
Cell[CellGroupData[{
Cell[14264, 440, 58, 1, 70, "GuideMoreAboutSection",
 CellID->9023],
Cell[14325, 443, 155, 3, 70, "GuideMoreAbout",
 CellID->1727],
Cell[14483, 448, 144, 3, 70, "GuideMoreAbout",
 CellID->196026298],
Cell[14630, 453, 177, 5, 70, "GuideMoreAboutSub",
 CellID->1771],
Cell[14810, 460, 191, 5, 70, "GuideMoreAboutSub",
 CellID->374687295],
Cell[15004, 467, 174, 4, 70, "GuideMoreAboutSub",
 CellID->276911616],
Cell[15181, 473, 185, 5, 70, "GuideMoreAboutSub",
 CellID->287447553],
Cell[15369, 480, 199, 5, 70, "GuideMoreAboutSub",
 CellID->43891222],
Cell[15571, 487, 200, 5, 70, "GuideMoreAboutSub",
 CellID->558555719],
Cell[15774, 494, 182, 5, 70, "GuideMoreAboutSub",
 CellID->173266127],
Cell[15959, 501, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976],
Cell[16142, 506, 155, 3, 70, "GuideMoreAbout",
 CellID->14247681]
}, Open  ]],
Cell[CellGroupData[{
Cell[16334, 514, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1846400784],
Cell[16407, 517, 799, 20, 70, "GuideRelatedLinks",
 CellID->264262083]
}, Open  ]],
Cell[17221, 540, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

