(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16647,        551]
NotebookOptionsPosition[     11603,        420]
NotebookOutlinePosition[     14395,        476]
CellTagsIndexPosition[     14352,        473]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["String Patterns", "GuideTitle",
 CellID->20217],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic string patterns provide a compact yet readable basis for \
sophisticated string operations. Included directly in programs, or \
symbolically generated on the fly, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s string patterns can routinely be used on strings with millions of \
elements. "
}], "GuideAbstract",
 CellID->50251340],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a symbolic string-pattern expression (",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "~~", 
   StyleBox["s", "TI"], "~~", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->31505],

Cell["\t", "GuideDelimiter",
 CellID->1157],

Cell[TextData[{
 Cell[TextData[ButtonBox["_",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Blank"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "any character"
}], "GuideText",
 CellID->31502],

Cell[TextData[{
 Cell[TextData[ButtonBox["__",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankSequence"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["___",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankNullSequence"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sequences of characters (one or more, zero or more)"
}], "GuideText",
 CellID->7666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox[
    RowBox[{
     StyleBox["p", "TI"], "|", 
     StyleBox["p", "TI"], "|", 
     StyleBox["p", "TI"]}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alternatives"], " "}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "alternatives"
}], "GuideText",
 CellID->9275],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Repeated"], "TI"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Repeated"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RepeatedNull"], "TI"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RepeatedNull"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " repeated patterns"
}], "GuideText",
 CellID->32046],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " named patterns"
}], "GuideText",
 CellID->17632],

Cell[TextData[{
 Cell[TextData[ButtonBox["Shortest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Shortest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Longest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Longest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "shortest, longest matches"
}], "GuideText",
 CellID->29789],

Cell[TextData[{
 Cell[TextData[ButtonBox["Except",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Except"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "matches that exclude a pattern"
}], "GuideText",
 CellID->6046],

Cell["\t", "GuideDelimiter",
 CellID->2145],

Cell[TextData[{
 Cell[TextData[ButtonBox["Whitespace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Whitespace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DatePattern",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DatePattern"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->13152],

Cell[TextData[{
 Cell[TextData[ButtonBox["WordCharacter",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WordCharacter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCharacter",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCharacter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LetterCharacter",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LetterCharacter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WhitespaceCharacter",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WhitespaceCharacter"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31901],

Cell[TextData[{
 Cell[TextData[ButtonBox["WordBoundary",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WordBoundary"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StartOfLine",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StartOfLine"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EndOfLine",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EndOfLine"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StartOfString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StartOfString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EndOfString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EndOfString"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8326],

Cell["\t", "GuideDelimiter",
 CellID->29153],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegularExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RegularExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "string patterns in regular expression notation"
}], "GuideText",
 CellID->21184],

Cell["\t", "GuideDelimiter",
 CellID->19649],

Cell[TextData[{
 Cell[TextData[ButtonBox["IgnoreCase",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IgnoreCase"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for whether to ignore case"
}], "GuideText",
 CellID->30350],

Cell[TextData[{
 Cell[TextData[ButtonBox["Overlaps",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Overlaps"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for how to treat substring overlaps"
}], "GuideText",
 CellID->10405],

Cell["\t", "GuideDelimiter",
 CellID->24346],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test the overall format of a string"
}], "GuideText",
 CellID->233745942],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->1025],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringMatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringMatchQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringFreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringFreeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringReplace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28970]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->14336],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "GuideTutorial",
 CellID->265328237],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "GuideTutorial",
 CellID->4795],

Cell[TextData[ButtonBox["Regular Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RegularExpressions"]], "GuideTutorial",
 CellID->9793],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "GuideTutorial",
 CellID->215773380]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->11323],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAbout",
 CellID->5532],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "GuideMoreAbout",
 CellID->28856],

Cell[TextData[ButtonBox["Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->3210],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 13.5659342}", "context" -> "", 
    "keywords" -> {
     "\\0", "avoiding matches", "awk", "case folding", "case sensitivity", 
      "case-sensitive", "character class", "compare strings", 
      "complementary patterns", "contain substring", "date pattern", 
      "digit character", "disambiguating pattern matches", 
      "editing of strings", "end of line", "end of string", "eol", 
      "excluded patterns", "greedy match", "grep", "ignore case", 
      "Kleene closure", "Kleene star operator", "letter character", 
      "longest pattern match", "longest sequence", "lowercase", 
      "matching of strings", "matching strings", "newline", 
      "non-greedy match", "number characters", "number string", 
      "overlapping strings", "overlapping substrings", "overlaps", 
      "pattern matching", "patterns for string", "Perl \\w", 
      "positive closure", "POSIX [[:alpha:]]", 
      "priorities on pattern matches", "production rules", "regex", 
      "regular expression", "regular language", "replace substring", 
      "replacement of characters", "replacements of substrings", 
      "ReplaceString", "rewriting of strings", "sed", 
      "shortest pattern match", "smash case", "space", "start of line", 
      "start of string", "string cases", "string comparison", 
      "string expression", "string format", "string free", "string match", 
      "string matching", "string pattern", "string replace", 
      "substitution in strings", "tab", "test for alphabetic character", 
      "translation of strings", "uppercase", "whitespace", 
      "whitespace character", "word boundary", "word character"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's symbolic string patterns provide a compact yet readable \
basis for sophisticated string operations. Included directly in programs, or \
symbolically generated on the fly, Mathematica's string patterns can \
routinely be used on strings with millions of elements. ", "synonyms" -> {}, 
    "title" -> "String Patterns", "type" -> "Guide", "uri" -> 
    "guide/StringPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 53, 1, 70, "GuideTitle",
 CellID->20217],
Cell[675, 28, 418, 11, 70, "GuideAbstract",
 CellID->50251340],
Cell[1096, 41, 413, 14, 70, "GuideText",
 CellID->31505],
Cell[1512, 57, 43, 1, 70, "GuideDelimiter",
 CellID->1157],
Cell[1558, 60, 228, 9, 70, "GuideText",
 CellID->31502],
Cell[1789, 71, 405, 13, 70, "GuideText",
 CellID->7666],
Cell[2197, 86, 360, 15, 70, "GuideText",
 CellID->9275],
Cell[2560, 103, 567, 22, 70, "GuideText",
 CellID->32046],
Cell[3130, 127, 638, 25, 70, "GuideText",
 CellID->17632],
Cell[3771, 154, 665, 19, 70, "GuideText",
 CellID->29789],
Cell[4439, 175, 250, 9, 70, "GuideText",
 CellID->6046],
Cell[4692, 186, 43, 1, 70, "GuideDelimiter",
 CellID->2145],
Cell[4738, 189, 763, 20, 70, "InlineGuideFunctionListing",
 CellID->13152],
Cell[5504, 211, 866, 23, 70, "InlineGuideFunctionListing",
 CellID->31901],
Cell[6373, 236, 1047, 29, 70, "InlineGuideFunctionListing",
 CellID->8326],
Cell[7423, 267, 44, 1, 70, "GuideDelimiter",
 CellID->29153],
Cell[7470, 270, 289, 9, 70, "GuideText",
 CellID->21184],
Cell[7762, 281, 44, 1, 70, "GuideDelimiter",
 CellID->19649],
Cell[7809, 284, 262, 9, 70, "GuideText",
 CellID->30350],
Cell[8074, 295, 267, 9, 70, "GuideText",
 CellID->10405],
Cell[8344, 306, 44, 1, 70, "GuideDelimiter",
 CellID->24346],
Cell[8391, 309, 417, 12, 70, "GuideText",
 CellID->233745942],
Cell[CellGroupData[{
Cell[8833, 325, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->1025],
Cell[9045, 332, 1051, 29, 70, "InlineGuideFunctionListing",
 CellID->28970]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10145, 367, 58, 1, 70, "GuideTutorialsSection",
 CellID->14336],
Cell[10206, 370, 143, 3, 70, "GuideTutorial",
 CellID->265328237],
Cell[10352, 375, 143, 3, 70, "GuideTutorial",
 CellID->4795],
Cell[10498, 380, 151, 3, 70, "GuideTutorial",
 CellID->9793],
Cell[10652, 385, 183, 4, 70, "GuideTutorial",
 CellID->215773380]
}, Open  ]],
Cell[CellGroupData[{
Cell[10872, 394, 59, 1, 70, "GuideMoreAboutSection",
 CellID->11323],
Cell[10934, 397, 149, 3, 70, "GuideMoreAbout",
 CellID->5532],
Cell[11086, 402, 157, 3, 70, "GuideMoreAbout",
 CellID->28856],
Cell[11246, 407, 151, 3, 70, "GuideMoreAboutSub",
 CellID->3210],
Cell[11400, 412, 161, 3, 70, "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],
Cell[11576, 418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

