(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11896,        387]
NotebookOptionsPosition[      7506,        278]
NotebookOutlinePosition[     10131,        330]
CellTagsIndexPosition[     10088,        327]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Structural Operations on Expressions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic architecture immediately allows it to perform \
structural transformations not only on objects like lists, but also on \
general symbolic expressions that can represent concrete or abstract data of \
any kind."
}], "GuideAbstract",
 CellID->520529621],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten out nested functions (associativity)"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "thread a function over lists or other constructs"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sort elements of an expression (commutativity)"
}], "GuideText",
 CellID->52743937],

Cell["\t", "GuideDelimiter",
 CellID->44683343],

Cell[TextData[{
 Cell[TextData[ButtonBox["FlattenAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FlattenAt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten particular elements"
}], "GuideText",
 CellID->44951813],

Cell[TextData[{
 Cell[TextData[ButtonBox["Distribute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Distribute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply distributivity to nested functions"
}], "GuideText",
 CellID->172276858],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->102483493],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "join expressions together"
}], "GuideText",
 CellID->92356971],

Cell[TextData[{
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Prepend",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prepend"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Take",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Take"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Drop"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->55125564],

Cell["\t", "GuideDelimiterSubsection",
 CellID->365840096],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Operations on Numbered Parts \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PartsOfExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->437768185],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[{
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["...",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PartsOfExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->206116521]
}, Open  ]],

Cell[CellGroupData[{

Cell["Head-Related Operations", "GuideFunctionsSubsection",
 CellID->448847474],

Cell[TextData[{
 Cell[TextData[ButtonBox["Through",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Through"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Operate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Operate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->307624931]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "GuideTutorial",
 CellID->142438749],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "GuideTutorial",
 CellID->97480921],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "GuideTutorial",
 CellID->492147115]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Structural Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RearrangingAndRestructuringLists"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Structural Operations on Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 14.1753248}", "context" -> "", 
    "keywords" -> {
     "appending", "applying functions to elements of lists", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices", "arrange", 
      "ascending order", "canonical order", "catenating lists", 
      "changing parts", "collapse", "composition of functions", 
      "concatenating lists", "contraction", "deleting elements", 
      "descending order", "discard elements", "dyadic products", 
      "expression elements", "expansion", "expressions", "exterior products", 
      "extraction of sublists", "flatten at", "functions", "grade in APL", 
      "implementing linearity of operators", "implementing listability", 
      "join lists", "levels", "linearity of operators", "lists ordering", 
      "map at", "merging lists", "multiple parts", "nesting of functions", 
      "parts", "performing operations on heads", "permutation of indices", 
      "picking out elements", "prepend elements to lists", "ravel in APL", 
      "removing elements from expressions", "replace part", "replacements", 
      "segments of lists", "selector", "sequence of elements", 
      "sorting of lists", "splicing", "squash", "stride", "subexpressions", 
      "sublists", "threading operations over equations", 
      "threading over lists", "transpose of matrices", 
      "transposition of lists", "unevaluated expressions", "unpack", 
      "unravel"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's unified symbolic architecture immediately allows it to \
perform structural transformations not only on objects like lists, but also \
on general symbolic expressions that can represent concrete or abstract data \
of any kind.", "synonyms" -> {}, "title" -> 
    "Structural Operations on Expressions", "type" -> "Guide", "uri" -> 
    "guide/StructuralOperationsOnExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 78, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[700, 28, 338, 8, 70, "GuideAbstract",
 CellID->520529621],
Cell[1041, 38, 271, 9, 70, "GuideText",
 CellID->203374175],
Cell[1315, 49, 274, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1592, 60, 261, 8, 70, "GuideText",
 CellID->52743937],
Cell[1856, 70, 47, 1, 70, "GuideDelimiter",
 CellID->44683343],
Cell[1906, 73, 257, 9, 70, "GuideText",
 CellID->44951813],
Cell[2166, 84, 273, 9, 70, "GuideText",
 CellID->172276858],
Cell[2442, 95, 598, 17, 70, "InlineGuideFunctionListing",
 CellID->102483493],
Cell[3043, 114, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[3094, 117, 245, 9, 70, "GuideText",
 CellID->92356971],
Cell[3342, 128, 789, 23, 70, "InlineGuideFunctionListing",
 CellID->55125564],
Cell[4134, 153, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->365840096],
Cell[CellGroupData[{
Cell[4217, 158, 236, 6, 70, "GuideFunctionsSubsection",
 CellID->437768185],
Cell[4456, 166, 1221, 42, 70, "InlineGuideFunctionListing",
 CellID->206116521]
}, Open  ]],
Cell[CellGroupData[{
Cell[5714, 213, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->448847474],
Cell[5796, 216, 606, 17, 70, "InlineGuideFunctionListing",
 CellID->307624931]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6451, 239, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6516, 242, 160, 3, 70, "GuideTutorial",
 CellID->142438749],
Cell[6679, 247, 156, 3, 70, "GuideTutorial",
 CellID->97480921],
Cell[6838, 252, 201, 4, 70, "GuideTutorial",
 CellID->492147115]
}, Open  ]],
Cell[CellGroupData[{
Cell[7076, 261, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7141, 264, 183, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7327, 270, 137, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[7479, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

