(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    197835,       6648]
NotebookOptionsPosition[    160378,       5458]
NotebookOutlinePosition[    161950,       5495]
CellTagsIndexPosition[    161907,       5492]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Summary of New Features in 6.0", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 fundamentally redefines ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and introduces a major new paradigm for computation. Building on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s time-tested core symbolic architecture, Version 6.0 adds nearly a \
thousand new functions\[LongDash]almost doubling the total number of \
functions in the system\[LongDash]dramatically increasing both the breadth \
and depth of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s capabilities, as well as introducing hundreds of major original \
algorithms, and perhaps a thousand new ideas, large and small. "
}], "GuideAbstract",
 CellID->2001916300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideFunctionsSection",
 CellID->201610654],

Cell[CellGroupData[{

Cell["List & Expression Manipulation", "GuideFunctionsSubsection",
 CellID->9319498],

Cell[TextData[{
 "New general ",
 ";;",
 " (",
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ") notation for sequences of parts, blocks, etc."
}], "GuideText",
 CellID->98869818],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " construct to specify arbitrarily banded multidimensional arrays. "
}], "GuideText",
 CellID->16926488],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 " extended to general index rules, with patterns."
}], "GuideText",
 CellID->138044753],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for generalized block array flattening."
}], "GuideText",
 CellID->18169366],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " extended to handle flattening disjoint levels."
}], "GuideText",
 CellID->188284072],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " generalized to join arrays at any level."
}], "GuideText",
 CellID->128782558],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reverse"]], "InlineFunctionSans"],
 " generalized to reverse at any level."
}], "GuideText",
 CellID->278239285],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["PadRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadRight"]], "InlineFunctionSans"],
 " generalized to automatically form full arrays."
}], "GuideText",
 CellID->391533991],

Cell[TextData[{
 Cell[TextData[ButtonBox["SortBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SortBy"]], "InlineFunctionSans"],
 " for sorting by values of a function applied to list elements."
}], "GuideText",
 CellID->21115004],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " function to tally identical elements and multiplicities."
}], "GuideText",
 CellID->16732978],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["BinLists",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinLists"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to count and list elements that lie in value bins."
}], "GuideText",
 CellID->637004094],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for successive sums and differences in lists."
}], "GuideText",
 CellID->94881002],

Cell[TextData[{
 Cell[TextData[ButtonBox["Commonest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Commonest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to find most frequent elements in lists."
}], "GuideText",
 CellID->163889897],

Cell[TextData[{
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to interleave elements in lists."
}], "GuideText",
 CellID->353190769],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for random subsets of lists."
}], "GuideText",
 CellID->359031881],

Cell[TextData[{
 "Much faster ",
 Cell[TextData[ButtonBox["ListConvolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListConvolve"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListCorrelate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListCorrelate"]], "InlineFunctionSans"],
 " for integer lists."
}], "GuideText",
 CellID->468360581],

Cell[TextData[{
 "Optimizations in ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Tuples",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tuples"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->202291337]
}, Open  ]],

Cell[CellGroupData[{

Cell["Language Constructs", "GuideFunctionsSubsection",
 CellID->426141213],

Cell[TextData[{
 Cell[TextData[ButtonBox["Longest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Longest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Shortest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Shortest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for enhanced pattern-matching control."
}], "GuideText",
 CellID->322789566],

Cell[TextData[{
 "Support for matching general pattern subsequences.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PatternSequence"]
}], "GuideText",
 CellID->161239270],

Cell[TextData[{
 Cell[TextData[ButtonBox["Repeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 " (",
 "..",
 ") generalized to constrain the number of repeats."
}], "GuideText",
 CellID->46889215],

Cell[TextData[{
 "General iterator support for iteration over lists in ",
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 ", etc."
}], "GuideText",
 CellID->62243854],

Cell[TextData[{
 Cell[TextData[ButtonBox["LengthWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LengthWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for list-oriented functional programming."
}], "GuideText",
 CellID->12243738],

Cell[TextData[{
 Cell[TextData[ButtonBox["Quiet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Quiet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for convenient message control."
}], "GuideText",
 CellID->288013558]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programming & Development", "GuideFunctionsSubsection",
 CellID->27518964],

Cell[TextData[{
 "Full-featured source-level debugger, including breakpoints, watchpoints and \
stepping. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Debugger"]
}], "GuideText",
 CellID->477005702],

Cell[TextData[{
 Cell[TextData[ButtonBox["Monitor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Monitor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for real-time symbolic monitoring of running programs."
}], "GuideText",
 CellID->143163979],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrintTemporary",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrintTemporary"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for temporary printing during a computation."
}], "GuideText",
 CellID->144562658],

Cell[TextData[{
 "New symbolic options management system for functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OptionsManagement"]
}], "GuideText",
 CellID->28341705],

Cell[TextData[{
 "User-defined syntax coloring for any function. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SyntaxInformation"]
}], "GuideText",
 CellID->210610845],

Cell[TextData[{
 "Direct support for enhanced editing of .m package files. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/New"]
}], "GuideText",
 CellID->356571299],

Cell[TextData[{
 "Access to over a hundred system-level customizations. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SystemOptions"],
 " "
}], "GuideText",
 CellID->262252336],

Cell[TextData[{
 Cell[TextData[ButtonBox["Input",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Input"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InputString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputString"]], "InlineFunctionSans"],
 " restyled based on symbolic interface elements."
}], "GuideText",
 CellID->502030374],

Cell[TextData[{
 "Symbol name discovery extended to regular expressions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Names"]
}], "GuideText",
 CellID->146998744]
}, Open  ]],

Cell[CellGroupData[{

Cell["String-Related Functions", "GuideFunctionsSubsection",
 CellID->457410545],

Cell[TextData[{
 "Efficient nearest-neighbor finding for strings. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Nearest"]
}], "GuideText",
 CellID->2212985],

Cell[TextData[{
 "Built-in dictionary lookup for words. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DictionaryLookup"]
}], "GuideText",
 CellID->25039394],

Cell[TextData[{
 "Edit and other distance measures for strings. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EditDistance"]
}], "GuideText",
 CellID->333226429],

Cell[TextData[{
 "Built-in hash code function with multiple schemes. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]
}], "GuideText",
 CellID->158052593],

Cell[TextData[{
 "Built-in support for string patterns representing dates. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DatePattern"]
}], "GuideText",
 CellID->87018944],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringTake",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringTake"]], "InlineFunctionSans"],
 " generalized to allow multiple substrings."
}], "GuideText",
 CellID->821473875],

Cell[TextData[{
 "Faster ",
 Cell[TextData[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FromCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFunctionSans"],
 " for long strings. "
}], "GuideText",
 CellID->409077209]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Functions", "GuideFunctionsSubsection",
 CellID->639363691],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for base and Roman numeral number forms. "
}], "GuideText",
 CellID->6085468],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 " extended to handle strings and Roman numerals."
}], "GuideText",
 CellID->304448955],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TreeForm"]], "InlineFunctionSans"],
 " enhanced to use graphical output."
}], "GuideText",
 CellID->138210334],

Cell[TextData[{
 "Extensive new date manipulation functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DateAndTime"]
}], "GuideText",
 CellID->557826620]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic Interactivity", "GuideFunctionsSection",
 CellID->322528867],

Cell[CellGroupData[{

Cell["Interactive Manipulation", "GuideFunctionsSubsection",
 CellID->828305781],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " as a universal dynamic interface for arbitrary objects."
}], "GuideText",
 CellID->68141558],

Cell["Immediate connection of variables to 20+ control types.", "GuideText",
 CellID->477222907],

Cell[TextData[{
 "Support for arbitrary numbers of variables connected to controls. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlObjects"]
}], "GuideText",
 CellID->33752157],

Cell[TextData[{
 "Support for general control layout, labeling, alignment, etc. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlsOptions"]
}], "GuideText",
 CellID->859750128],

Cell[TextData[{
 "Support for in-image arbitrary locator controls. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Locator"]
}], "GuideText",
 CellID->703999471],

Cell[TextData[{
 "Automatic mapping to gamepads and other HID controls. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GamepadAndDeviceInterface"]
}], "GuideText",
 CellID->696759615],

Cell["Autorun and bookmarking capabilities.", "GuideText",
 CellID->311179905],

Cell[TextData[{
 "Support for automatic encapsulation of imported functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SaveDefinitions"]
}], "GuideText",
 CellID->444049655],

Cell[TextData[{
 "Export to Flash and other web formats. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MultimediaFormats"]
}], "GuideText",
 CellID->114575713]
}, Open  ]],

Cell[CellGroupData[{

Cell["Viewers & Annotations", "GuideFunctionsSubsection",
 CellID->378219929],

Cell[TextData[{
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["SlideView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SlideView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["MenuView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MenuView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FlipView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FlipView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["PopupView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["OpenerView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OpenerView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " viewers."
}], "GuideText",
 CellID->360333661],

Cell[TextData[{
 "Support for arbitrary content and labeling in all viewers, with dynamic \
sizing. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OptionsAndStylingForInteractiveManipulation"]
}], "GuideText",
 CellID->285356196],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with arbitrary textual or graphical content."
}], "GuideText",
 CellID->101796930],

Cell[TextData[{
 "Support for attaching tooltips etc. to arbitrary expressions, graphics \
elements, etc. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]
}], "GuideText",
 CellID->260931488],

Cell[TextData[{
 Cell[TextData[ButtonBox["MouseAnnotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for associating expressions with arbitrary annotation elements."
}], "GuideText",
 CellID->249138647],

Cell[TextData[{
 Cell[TextData[ButtonBox["Panel",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Panel"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["Pane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Pane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for arbitrary wrapping of text and other content."
}], "GuideText",
 CellID->577374319],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for self-paced running animation."
}], "GuideText",
 CellID->161296430],

Cell[TextData[{
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ProgressIndicator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ProgressIndicator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Monitor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Monitor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for monitoring computations."
}], "GuideText",
 CellID->531886007]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Controls", "GuideFunctionsSubsection",
 CellID->28833099],

Cell[TextData[{
 "Seamless integration of active controls with graphics, layout and \
typesetting. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DynamicSetting"]
}], "GuideText",
 CellID->71812222],

Cell[TextData[{
 "Support for ",
 Cell[TextData[ButtonBox["Slider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["VerticalSlider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VerticalSlider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with continuous, discrete, or symbolic range."
}], "GuideText",
 CellID->885948110],

Cell[TextData[{
 "Modifier-key-based support for multiple-level fine slider control. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InteractiveManipulation"]
}], "GuideText",
 CellID->13985895],

Cell[TextData[{
 "Support for general 2D slider controls. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Slider2D"]
}], "GuideText",
 CellID->678056046],

Cell[TextData[{
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " allowing arbitrary expressions or graphics."
}], "GuideText",
 CellID->13446634],

Cell[TextData[{
 Cell[TextData[ButtonBox["Checkbox",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Checkbox"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RadioButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RadioButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Toggler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Toggler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Opener",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opener"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " state controls."
}], "GuideText",
 CellID->294855493],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorSlider",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorSlider"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ColorSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for interactive color choosing."
}], "GuideText",
 CellID->66103338],

Cell[TextData[{
 Cell[TextData[ButtonBox["Setter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Setter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " control for setting arbitrary values."
}], "GuideText",
 CellID->11463108],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetterBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SetterBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RadioButtonBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CheckboxBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CheckboxBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and other composite controls."
}], "GuideText",
 CellID->152519472],

Cell[TextData[{
 Cell[TextData[ButtonBox["Trigger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Trigger"]], "InlineFunctionSans"],
 " control for events that continuously change when triggered."
}], "GuideText",
 CellID->23030144],

Cell[TextData[{
 "General ",
 Cell[TextData[ButtonBox["InputField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InputField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " control, allowing string, expression, etc. input."
}], "GuideText",
 CellID->995049188],

Cell[TextData[{
 "General ",
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " object, with automatic replication capability."
}], "GuideText",
 CellID->13268257],

Cell[TextData[{
 Cell[TextData[ButtonBox["LocatorPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocatorPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " providing immediate movable locators in graphics, etc."
}], "GuideText",
 CellID->130345485],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Manipulator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " animation and manipulation controls."
}], "GuideText",
 CellID->150967746],

Cell[TextData[{
 "Symbolic ",
 Cell[TextData[ButtonBox["Button",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Button"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " object allowing arbitrary appearance and arbitrary action."
}], "GuideText",
 CellID->140031874],

Cell[TextData[{
 Cell[TextData[ButtonBox["ActionMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ActionMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " allowing arbitrary function execution."
}], "GuideText",
 CellID->99671765],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " providing image-map coordinates."
}], "GuideText",
 CellID->77293379],

Cell[TextData[{
 Cell[TextData[ButtonBox["PaneSelector",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PaneSelector"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to display one of several objects based on a dynamic value."
}], "GuideText",
 CellID->460485435],

Cell[TextData[{
 Cell[TextData[ButtonBox["Appearance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Appearance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " option for system and generic appearances of controls."
}], "GuideText",
 CellID->453425578],

Cell[TextData[{
 "Support for specification of control sizes and other properties. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlsOptions"]
}], "GuideText",
 CellID->147015558],

Cell[TextData[{
 Cell[TextData[ButtonBox["AutoAction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AutoAction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["ContinuousAction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContinuousAction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for tuning operations of controls."
}], "GuideText",
 CellID->489320271],

Cell[TextData[{
 "Support for platform-neutral rendering of all controls, including printing. \
",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ControlsRendering"]
}], "GuideText",
 CellID->338767391],

Cell[TextData[{
 "Time-based ",
 Cell[TextData[ButtonBox["Clock",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Clock"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Refresh",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Refresh"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " controls"
}], "GuideText",
 CellID->76348298],

Cell[TextData[{
 Cell[TextData[ButtonBox["Delimiter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Delimiter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for visual separation in controls layout."
}], "GuideText",
 CellID->133931082]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic Interactivity Language", "GuideFunctionsSubsection",
 CellID->481430176],

Cell[TextData[{
 "General ",
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " construct for representing continually updated dynamic expressions."
}], "GuideText",
 CellID->155524844],

Cell[TextData[{
 "Support for arbitrary tracking and action functions in ",
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ". ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrackedSymbols"]
}], "GuideText",
 CellID->359202113],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " scoping construct for interface-localized values and variables."
}], "GuideText",
 CellID->143871343],

Cell[TextData[{
 "Dynamic access to interface properties ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CurrentValue"]
}], "GuideText",
 CellID->677537328],

Cell[TextData[{
 "Convenient access to mouse position information. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MousePosition"]
}], "GuideText",
 CellID->201299114],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to allow preview modes when controls are active."
}], "GuideText",
 CellID->42404386],

Cell[TextData[{
 "Mechanism to synchronize initialization and updating of dynamic variables. \
",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SynchronousUpdating"]
}], "GuideText",
 CellID->18861162]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface Construction System", "GuideFunctionsSubsection",
 CellID->151023455],

Cell[TextData[{
 "Fully serializable interface, completely described in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic language."
}], "GuideText",
 CellID->818241640],

Cell["\<\
Seamless integration of active controls with scrolling documents, graphics, \
etc. \
\>", "GuideText",
 CellID->89861596],

Cell[TextData[{
 "Instant universal interface using ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "."
}], "GuideText",
 CellID->590956203],

Cell[TextData[{
 "Support for multiple interface paradigms, including dialog boxes, toolbars, \
click panes, etc.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ControlType"]
}], "GuideText",
 CellID->139582891],

Cell[TextData[{
 "Arbitrary programmable and dynamic control arrangement. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ControlPlacement"]
}], "GuideText",
 CellID->171290032],

Cell[TextData[{
 "Convenient immediate support of gamepads and other HID devices ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GamepadAndDeviceInterface"]
}], "GuideText",
 CellID->50250718],

Cell["\<\
Arbitrary interface building within scrollable notebook documents.\
\>", "GuideText",
 CellID->91776225],

Cell[TextData[{
 Cell[TextData[ButtonBox["DockedCells",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DockedCells"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to create a custom toolbar inside a notebook."
}], "GuideText",
 CellID->138977703],

Cell[TextData[{
 Cell[TextData[ButtonBox["PasteButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PasteButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Hyperlink",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Hyperlink"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for most common types of buttons."
}], "GuideText",
 CellID->731123111],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["DialogNotebook",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DialogNotebook"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to construct a dialog with arbitrary controls."
}], "GuideText",
 CellID->372965815],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreatePalette",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreatePalette"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["PaletteNotebook",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to create and manipulate custom palettes."
}], "GuideText",
 CellID->276033374],

Cell[TextData[{
 "Many standard and customizable types of dialogs. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DialogBoxes"]
}], "GuideText",
 CellID->179854941],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNameSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileNameSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ColorSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " controls to bring up system dialogs."
}], "GuideText",
 CellID->681783268],

Cell[TextData[{
 "Programmatic interface to system dialogs for files, colors, sound \
recording, etc. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SystemDialogInput"]
}], "GuideText",
 CellID->100410379],

Cell[TextData[{
 "Symbolic ",
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " supporting 30+ types of low-level events."
}], "GuideText",
 CellID->244526769],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. to specify low-level event handlers."
}], "GuideText",
 CellID->252353505],

Cell[TextData[{
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deploy"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to create noneditable interfaces."
}], "GuideText",
 CellID->82054703],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interpretation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Interpretation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for creation of evaluatable template-based interfaces."
}], "GuideText",
 CellID->281586042],

Cell[TextData[{
 Cell[TextData[ButtonBox["Setting",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Setting"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["DynamicSetting",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicSetting"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to obtain values of dynamic controls."
}], "GuideText",
 CellID->557929191]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematics and Algorithms", "GuideFunctionsSection",
 CellID->32151889],

Cell[CellGroupData[{

Cell["Mathematical Functions", "GuideFunctionsSubsection",
 CellID->567202398],

Cell[TextData[{
 Cell[TextData[ButtonBox["Round",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Round"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Ceiling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Ceiling"]], "InlineFunctionSans"],
 " generalized to allow \"round to nearest n\", etc."
}], "GuideText",
 CellID->6831296],

Cell[TextData[{
 "Spherical Bessel, Hankel and Kelvin functions added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"],
 " "
}], "GuideText",
 CellID->54373158],

Cell[TextData[{
 "Whittaker and parabolic cylinder functions added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]
}], "GuideText",
 CellID->64654151],

Cell[TextData[{
 "Full coverage of spheroidal functions added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]
}], "GuideText",
 CellID->75322184],

Cell[TextData[{
 "Bessel and Airy zeros functions added.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]
}], "GuideText",
 CellID->260275068],

Cell[TextData[{
 "Riemann zeta function zeros function added.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ZetaZero"]
}], "GuideText",
 CellID->45820978],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinc",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["HeavisideTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " functions added."
}], "GuideText",
 CellID->41160406],

Cell[TextData[{
 Cell[TextData[ButtonBox["Unitize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unitize"]], "InlineFunctionSans"],
 " convenience function added."
}], "GuideText",
 CellID->238673628],

Cell[TextData[{
 "Zernike polynomials added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ZernikeR"]
}], "GuideText",
 CellID->10281983],

Cell[TextData[{
 "Siegel theta function added.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SiegelTheta"]
}], "GuideText",
 CellID->392450815],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyGamma"]], "InlineFunctionSans"],
 " generalized to arbitrary complex order."
}], "GuideText",
 CellID->1002584],

Cell["\<\
Thousands of new rules added for generalized hypergeometric functions.\
\>", "GuideText",
 CellID->135725829]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integer Functions", "GuideFunctionsSubsection",
 CellID->704053081],

Cell["\<\
Greatly enhanced arbitrary-length integer arithmetic on 64-bit systems.\
\>", "GuideText",
 CellID->504832195],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subfactorial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Subfactorial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CatalanNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CatalanNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["LucasL",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LucasL"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->295668876],

Cell[TextData[{
 "Bell and N\[ODoubleDot]rlund (generalized Bernoulli) polynomials added.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]
}], "GuideText",
 CellID->938244732],

Cell[TextData[{
 Cell[TextData[ButtonBox["Divisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Divisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["QuotientRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/QuotientRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->147772664],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChineseRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " function added."
}], "GuideText",
 CellID->572601159],

Cell[TextData[{
 Cell[TextData[ButtonBox["KroneckerSymbol",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerSymbol"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->119346176],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimitiveRoot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->98727143],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerModList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowerModList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->220979850],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NextPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["RandomPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "."
}], "GuideText",
 CellID->485602411],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrimePowerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrimePowerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["SquareFreeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " tests for integers."
}], "GuideText",
 CellID->215940184],

Cell[TextData[{
 Cell[TextData[ButtonBox["FactorInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FactorInteger"]], "InlineFunctionSans"],
 " extended to allow partial factorization."
}], "GuideText",
 CellID->837041664],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to find number of digits in a number."
}], "GuideText",
 CellID->394571081],

Cell[TextData[{
 "Bitwise functions for arbitrary-length integers added.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BitwiseOperations"]
}], "GuideText",
 CellID->51164511],

Cell[TextData[{
 Cell[TextData[ButtonBox["HermiteDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for Hermite normal forms of integer matrices."
}], "GuideText",
 CellID->825444987]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number Theory", "GuideFunctionsSubsection",
 CellID->590680085],

Cell[TextData[{
 "21 functions for algebraic number theory and algebraic number fields added. \
",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlgebraicNumberTheory"],
 " "
}], "GuideText",
 CellID->52738223],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootApproximant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootApproximant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added to find algebraic number approximants."
}], "GuideText",
 CellID->103612628],

Cell[TextData[{
 Cell[TextData[ButtonBox["Convergents",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Convergents"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to find successive continued fraction convergents."
}], "GuideText",
 CellID->111025215],

Cell[TextData[{
 "Ramanujan tau functions added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]
}], "GuideText",
 CellID->241025712],

Cell[TextData[{
 "General support added for integer partitions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerPartitions"]
}], "GuideText",
 CellID->57499680],

Cell[TextData[{
 "Functions for representations of numbers as sums of powers. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]
}], "GuideText",
 CellID->146542830],

Cell[TextData[{
 "Functions for solving and testing Frobenius equations. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]
}], "GuideText",
 CellID->33089224],

Cell[TextData[{
 "Faster ",
 Cell[TextData[ButtonBox["Prime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Prime"]], "InlineFunctionSans"],
 " and primes-related functions."
}], "GuideText",
 CellID->345840383],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootIntervals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootIntervals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["IsolatingInterval",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for root isolation."
}], "GuideText",
 CellID->252670490]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Computation", "GuideFunctionsSubsection",
 CellID->96497051],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " extended to allow automated theorem-proving with symbolic operators."
}], "GuideText",
 CellID->234399947],

Cell[TextData[{
 "Improved original algorithm for solving large polynomial systems over the \
reals. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AssumptionsAndDomains"]
}], "GuideText",
 CellID->258488735],

Cell[TextData[{
 Cell[TextData[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]], "InlineFunctionSans"],
 " extended to symbolic solution of first-order initial value PDEs."
}], "GuideText",
 CellID->27446544],

Cell[TextData[{
 "Traveling wave solutions for nonlinear PDEs. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]
}], "GuideText",
 CellID->332988343],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 " extended to solve linear fractional systems of difference equations."
}], "GuideText",
 CellID->409847533],

Cell[TextData[{
 "Solution of multistep linear difference equations of arbitrary order. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]
}], "GuideText",
 CellID->23111163],

Cell[TextData[{
 Cell[TextData[ButtonBox["SeriesCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFunctionSans"],
 " extended to multivariate series and arbitrary expansion points."
}], "GuideText",
 CellID->500343366],

Cell[TextData[{
 Cell[TextData[ButtonBox["Expand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Expand"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Factor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Cancel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cancel"]], "InlineFunctionSans"],
 " etc. automatically thread over equations etc."
}], "GuideText",
 CellID->193634535],

Cell[TextData[{
 Cell[TextData[ButtonBox["PossibleZeroQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " fast, heuristic test for zeros added."
}], "GuideText",
 CellID->298242870],

Cell[TextData[{
 "Support for generation of symmetric polynomials, and symmetric reduction. \
",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]
}], "GuideText",
 CellID->7863569],

Cell[TextData[{
 "Polynomial discriminant function added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Discriminant"]
}], "GuideText",
 CellID->529111110],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialQuotientRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["PolynomialExtendedGCD",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolynomialExtendedGCD"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->61972286],

Cell[TextData[{
 "Square-free polynomial testing and decomposition. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]
}], "GuideText",
 CellID->93948210],

Cell[TextData[{
 Cell[TextData[ButtonBox["GenericCylindricalDecomposition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GenericCylindricalDecomposition"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", etc. for extended handling of solution sets. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]
}], "GuideText",
 CellID->114450720],

Cell[TextData[{
 "Exact root counting and isolating intervals for polynomials. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]
}], "GuideText",
 CellID->641272487],

Cell[TextData[{
 "Support for general Pad\[EAcute] approximants. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadeApproximant"]
}], "GuideText",
 CellID->167827317],

Cell[TextData[{
 "Symbolic normalization and orthogonalization of families of functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Orthogonalize"]
}], "GuideText",
 CellID->142499084],

Cell["Faster cylindrical algebraic decomposition methods.", "GuideText",
 CellID->326714257],

Cell["\<\
Faster lexicographic and toric Gr\[ODoubleDot]bner bases.\
\>", "GuideText",
 CellID->61328379],

Cell[TextData[{
 Cell[TextData[ButtonBox["HornerForm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HornerForm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " polynomial representation."
}], "GuideText",
 CellID->64631236]
}, Open  ]],

Cell[CellGroupData[{

Cell["General Numerics ", "GuideFunctionsSubsection",
 CellID->580899261],

Cell[TextData[{
 "Support for constrained nonlinear local optimization. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]
}], "GuideText",
 CellID->81842804],

Cell[TextData[{
 "Support for integer linear programming. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]
}], "GuideText",
 CellID->133394618],

Cell[TextData[{
 "Major new algorithms for ",
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 ", with efficient high-dimensional integration."
}], "GuideText",
 CellID->51629389],

Cell[TextData[{
 "Dense output continuous to the order used in ",
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->315014471],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierDCT",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDCT"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FourierDST",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDST"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " discrete transforms added."
}], "GuideText",
 CellID->117547825],

Cell[TextData[{
 "New fast high-quality algorithms for random number generation. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RandomNumberGeneration"]
}], "GuideText",
 CellID->204797308],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", etc. generate arbitrary random arrays."
}], "GuideText",
 CellID->212040543],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomChoice",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomChoice"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for weighted discrete random selection."
}], "GuideText",
 CellID->35595821],

Cell[TextData[{
 Cell[TextData[ButtonBox["RealExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealExponent"]], "InlineFunctionSans"],
 " added."
}], "GuideText",
 CellID->22812214],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exclusions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Exclusions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to specify regions to exclude in integration, etc."
}], "GuideText",
 CellID->32011996],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExampleData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExampleData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with immediate access to matrix, optimization, etc. test problems."
}], "GuideText",
 CellID->379580304]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrices & Linear Algebra", "GuideFunctionsSubsection",
 CellID->202368338],

Cell[TextData[{
 "Automatic use of multiple processors for core numerical linear algebra. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AssumptionsAndDomains"]
}], "GuideText",
 CellID->68680975],

Cell[TextData[{
 "Symbolic specification for general banded matrices. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Band"]
}], "GuideText",
 CellID->83209894],

Cell[TextData[{
 "Tests for Hermitian and positive definite matrices. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]
}], "GuideText",
 CellID->30344631],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixRank",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixRank"]], "InlineFunctionSans"],
 " extended to work with sparse arrays."
}], "GuideText",
 CellID->228521069],

Cell[TextData[{
 Cell[TextData[ButtonBox["Diagonal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Diagonal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to extract diagonal elements in a matrix."
}], "GuideText",
 CellID->317121513],

Cell[TextData[{
 Cell[TextData[ButtonBox["SingularValueDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueDecomposition"]], 
  "InlineFunctionSans"],
 " extended for exact computation."
}], "GuideText",
 CellID->408922351],

Cell[TextData[{
 "Support for solving general linear least squares problems in matrix form. \
",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LeastSquares"]
}], "GuideText",
 CellID->386716995],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixExp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MatrixPower",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixPower"]], "InlineFunctionSans"],
 " extended for efficient application to vectors."
}], "GuideText",
 CellID->99428886],

Cell[TextData[{
 "Normalization, orthogonalization and projection of vectors.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]
}], "GuideText",
 CellID->474749534],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorAngle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VectorAngle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["UnitVector",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/UnitVector"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->65235067],

Cell[TextData[{
 "Support for Hilbert, Hankel and Toeplitz matrices. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConstructingMatrices"]
}], "GuideText",
 CellID->28144346],

Cell[TextData[{
 Cell[TextData[ButtonBox["KroneckerProduct",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added."
}], "GuideText",
 CellID->676680715],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and 8+ other geometric matrix transforms added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]
}], "GuideText",
 CellID->186581428],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatrixPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for visual representation of matrices."
}], "GuideText",
 CellID->134560209]
}, Open  ]],

Cell[CellGroupData[{

Cell["Statistics & Data Analysis", "GuideFunctionsSubsection",
 CellID->262726065],

Cell[TextData[{
 "Full symbolic & numeric computation of 20+ properties of 36 named \
statistical distributions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Statistics"]
}], "GuideText",
 CellID->245192878],

Cell[TextData[{
 "14 new descriptive statistics functions added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]
}], "GuideText",
 CellID->322479303],

Cell[TextData[{
 Cell[TextData[ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " functions for statistical distributions."
}], "GuideText",
 CellID->271345060],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for finding nearest neighbors in multidimensional data."
}], "GuideText",
 CellID->216757333],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for general cluster analysis in numeric, Boolean, string data."
}], "GuideText",
 CellID->116593529],

Cell[TextData[{
 "18 distance and dissimilarity measures added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]
}], "GuideText",
 CellID->2710797],

Cell[TextData[{
 "Built-in ",
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and other data-smoothing functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60Statistics"]
}], "GuideText",
 CellID->245608352],

Cell[TextData[{
 "Extended support for multidimensional and vector-valued interpolation.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]
}], "GuideText",
 CellID->286566132],

Cell[TextData[{
 "Support for unstructured data in ",
 Cell[TextData[ButtonBox["InterpolatingPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->83469500]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discrete Mathematics & Computational Systems", \
"GuideFunctionsSubsection",
 CellID->334564919],

Cell[TextData[{
 "Fully automated graph layout in 2D and 3D. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]
}], "GuideText",
 CellID->430210760],

Cell[TextData[{
 "Layered graph and tree layout. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]
}], "GuideText",
 CellID->680221207],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with 100+ properties of hundreds of named graphs."
}], "GuideText",
 CellID->8508662],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindShortestTour",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindShortestTour"]], "InlineFunctionSans"],
 " for traveling salesman problem."
}], "GuideText",
 CellID->59951182],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with 75+ properties of 145 named polyhedra."
}], "GuideText",
 CellID->328751855],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 " with properties of named lattices in ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " dimensions."
}], "GuideText",
 CellID->323190878],

Cell[TextData[{
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with 60+ properties of 250+ knots."
}], "GuideText",
 CellID->103479464],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 " generalized to allow selecting any number of elements."
}], "GuideText",
 CellID->440565440],

Cell[TextData[{
 "Support for symbolic rules, functional usage, and higher-order evolution in \
",
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->369774987],

Cell[TextData[{
 Cell[TextData[ButtonBox["TuringMachine",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TuringMachine"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for general Turing machine evolution."
}], "GuideText",
 CellID->81224472]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization and Graphics", "GuideFunctionsSection",
 CellID->73657636],

Cell[CellGroupData[{

Cell["Graphics Infrastructure", "GuideFunctionsSubsection",
 CellID->105463164],

Cell["\<\
Full integration of graphics, typesetting and active controls.\
\>", "GuideText",
 CellID->151452997],

Cell["\<\
Compelling graphics produced using computational aesthetics methodology.\
\>", "GuideText",
 CellID->277930189],

Cell["Real-time 3D graphics rotation and zooming.", "GuideText",
 CellID->71551041],

Cell[TextData[{
 "Support for graphical notation in input. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpretation"]
}], "GuideText",
 CellID->582962676],

Cell[TextData[{
 "Arbitrary insetting of graphics, text, formulas etc. within another \
graphic. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inset"]
}], "GuideText",
 CellID->541202364],

Cell[TextData[{
 "Full interactive drawing of 2D graphics, including text and formulas. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]
}], "GuideText",
 CellID->248785741],

Cell[TextData[{
 "Fully editable 2D graphics using ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 ". ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"]
}], "GuideText",
 CellID->24226781],

Cell["\<\
Extensive support for hardware acceleration of 3D graphics rendering on all \
platforms.\
\>", "GuideText",
 CellID->639685876],

Cell["\<\
Seamless support for scrollable OpenGL and Direct3D graphics.\
\>", "GuideText",
 CellID->512488667],

Cell["Full support for modern GDI+, Quartz and Qt graphics layers.", \
"GuideText",
 CellID->1250328],

Cell["Antialiased graphics on all platforms.", "GuideText",
 CellID->123382678],

Cell["New antialiased fonts for Linux.", "GuideText",
 CellID->42335059],

Cell["Automatic graphics compression in notebook files.", "GuideText",
 CellID->89112715],

Cell[TextData[{
 Cell[TextData[ButtonBox["PerformanceGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFunctionSans"],
 " for general control of graphics quality or speed in animations."
}], "GuideText",
 CellID->272536195],

Cell[TextData[{
 "Built-in large collection of color schemes for use in graphics, with color \
palette. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ColorSchemes"]
}], "GuideText",
 CellID->235056529],

Cell[TextData[{
 "Transparency support in graphics and visualization. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Opacity"]
}], "GuideText",
 CellID->762000132],

Cell[TextData[{
 "Support for import and export of large number of graphics formats. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsImportingAndExporting"]
}], "GuideText",
 CellID->32358871]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Language and Primitives", "GuideFunctionsSubsection",
 CellID->270728077],

Cell[TextData[{
 "Extended and optimized graphics primitives. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]
}], "GuideText",
 CellID->171340589],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 " are fully integrated into input and output."
}], "GuideText",
 CellID->342136247],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " primitive supporting connected lines, polygonal surfaces etc. "
}], "GuideText",
 CellID->364562921],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " primitive with fully-configurable arrows. "
}], "GuideText",
 CellID->700170952],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["Sphere",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sphere"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Cylinder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Cylinder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " primitives."
}], "GuideText",
 CellID->888569784],

Cell[TextData[{
 Cell[TextData[ButtonBox["Circle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Circle"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Disk",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Disk"]], "InlineFunctionSans"],
 " now support scaled sizes."
}], "GuideText",
 CellID->123954345],

Cell[TextData[{
 Cell[TextData[ButtonBox["Point",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Point"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Line",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Line"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " enhanced to support multiple lines, points etc."
}], "GuideText",
 CellID->252192308],

Cell[TextData[{
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 " supports smooth color gradients and shading."
}], "GuideText",
 CellID->1508295],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["GraphicsColumn",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["GraphicsRow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsRow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for automatic layout of graphics."
}], "GuideText",
 CellID->590425304],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsGroup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for selection grouping of graphics objects."
}], "GuideText",
 CellID->157033653]
}, Open  ]],

Cell[CellGroupData[{

Cell["Geometric Transformations", "GuideFunctionsSubsection",
 CellID->132144035],

Cell[TextData[{
 "Full support for geometric transformations of graphics objects and \
primitives. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsTransformations"]
}], "GuideText",
 CellID->127040347],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ShearingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ",... for transformations in arbitrary dimensions."
}], "GuideText",
 CellID->6957074],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ",... symbolic geometric transformations."
}], "GuideText",
 CellID->46115567]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Options and Directives", "GuideFunctionsSubsection",
 CellID->246298763],

Cell[TextData[{
 Cell[TextData[ButtonBox["Directive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Directive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for compound graphics directive."
}], "GuideText",
 CellID->622570022],

Cell[TextData[{
 "Support for preset symbolic size specifications (e.g. ",
 Cell[TextData[ButtonBox["Tiny",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tiny"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ")."
}], "GuideText",
 CellID->52062306],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thick",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Thick"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Thin",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Thin"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Dashed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dashed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Dotted",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dotted"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. for line styles in graphics."
}], "GuideText",
 CellID->469185],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with extensive library of color schemes."
}], "GuideText",
 CellID->137627001],

Cell[TextData[{
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for arbitrary color interpolation. "
}], "GuideText",
 CellID->61968087],

Cell[TextData[{
 Cell[TextData[ButtonBox["Lighter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Lighter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Darker",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Darker"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for color adjustment."
}], "GuideText",
 CellID->224168918],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["Glow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Glow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Specularity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Specularity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " graphics directives for surface properties."
}], "GuideText",
 CellID->139050807],

Cell[TextData[{
 "Fully updated support for 3D lighting model, including point and spot light \
sources. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Lighting"]
}], "GuideText",
 CellID->14741181],

Cell[TextData[{
 "Support for ",
 Cell[TextData[ButtonBox["FaceForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FaceForm"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 " in 2D graphics. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsDirectives"]
}], "GuideText",
 CellID->34965461],

Cell[TextData[{
 "Detailed control of image size, margins and padding. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PlottingAndImageRegions"]
}], "GuideText",
 CellID->81860245],

Cell[TextData[{
 Cell[TextData[ButtonBox["ViewAngle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ViewAngle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ViewVector",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ViewVector"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ViewRange",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ViewRange"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. for graphics scene setup."
}], "GuideText",
 CellID->226497237],

Cell[TextData[{
 "Smooth shading for 2D and 3D polygon meshes and surfaces. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NormalsFunction"]
}], "GuideText",
 CellID->655763123],

Cell[TextData[{
 Cell[TextData[ButtonBox["LabelStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LabelStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["TicksStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TicksStyle"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["GridLinesStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFunctionSans"],
 ",... styling options."
}], "GuideText",
 CellID->44699382],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlignmentPoint",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. for graphics alignment in flowing text."
}], "GuideText",
 CellID->249918145]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization Options and Directives", "GuideFunctionsSubsection",
 CellID->15799570],

Cell[TextData[{
 "Arbitrary ",
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " support in 2D and 3D."
}], "GuideText",
 CellID->152085160],

Cell[TextData[{
 "Automatic contour labels. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourLabels"]
}], "GuideText",
 CellID->23174920],

Cell[TextData[{
 "Support for built-in color functions, specularity etc. in all visualization \
functions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorFunction"]
}], "GuideText",
 CellID->373009353],

Cell[TextData[{
 "Full adaptive sampling with ",
 Cell[TextData[ButtonBox["MaxRecursion",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MaxRecursion"]], "InlineFunctionSans"],
 " for all function visualization. "
}], "GuideText",
 CellID->68291596],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClippingStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClippingStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ContourStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourStyle"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FillingStyle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FillingStyle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ",... styling options."
}], "GuideText",
 CellID->788194],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColors",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexColors"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["VertexNormals",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VertexNormals"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for smooth interpolation of surface color and lighting."
}], "GuideText",
 CellID->141360513]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Annotation", "GuideFunctionsSubsection",
 CellID->33214342],

Cell[TextData[{
 Cell[TextData[ButtonBox["Annotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Annotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for arbitrary object annotation."
}], "GuideText",
 CellID->79906587],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to display an arbitrary tooltip for any object."
}], "GuideText",
 CellID->200822392],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["MouseAnnotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for mouse-sensitive annotation."
}], "GuideText",
 CellID->594932],

Cell[TextData[{
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for annotation in the window status area."
}], "GuideText",
 CellID->120340216],

Cell[TextData[{
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to display a separate window."
}], "GuideText",
 CellID->365899303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization Framework", "GuideFunctionsSubsection",
 CellID->654866555],

Cell[TextData[{
 "Plotting over regions specified by arbitrary constraints. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RegionFunction"]
}], "GuideText",
 CellID->78869555],

Cell[TextData[{
 "Exclusions mechanism to exclude discontinuities, etc. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exclusions"]
}], "GuideText",
 CellID->188495618],

Cell[TextData[{
 "Fully general mesh overlay capability for all regions and surfaces. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MeshFunctions"]
}], "GuideText",
 CellID->601284221],

Cell["\<\
Adaptive sampling in all 2D and 3D function visualization functions. \
\>", "GuideText",
 CellID->771314132],

Cell["\<\
Unstructured data in all 2D and 3D data visualization functions. \
\>", "GuideText",
 CellID->912346555],

Cell["\<\
Support for symbolic or missing data in 2D and 3D visualization functions. \
\>", "GuideText",
 CellID->511746070],

Cell["Efficient support for plotting large-scale sparse arrays.", "GuideText",
 CellID->214581301],

Cell[TextData[{
 "Enhanced support for ",
 Cell[TextData[ButtonBox["InterpolationOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFunctionSans"],
 ", including multidimensional data."
}], "GuideText",
 CellID->668031351],

Cell[TextData[{
 "Support for stepped 2D plots and Voronoi-based 3D plots. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpolationOrder"]
}], "GuideText",
 CellID->592464239]
}, Open  ]],

Cell[CellGroupData[{

Cell["2D Visualization", "GuideFunctionsSubsection",
 CellID->518932592],

Cell[TextData[{
 "Enhanced ",
 Cell[TextData[ButtonBox["Plot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot"]], "InlineFunctionSans"],
 " with support for filling, adaptive sampling, exclusions, mesh overlays \
etc. "
}], "GuideText",
 CellID->148498916],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["ParametricPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot"]], "InlineFunctionSans"],
 " with support for 2D parametric region, adaptivity, meshes, etc. "
}], "GuideText",
 CellID->348362369],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListLinePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLinePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with support for multiple datasets, data markers and fill styles. "
}], "GuideText",
 CellID->532795662],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateListPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateListPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for general plotting of time- and date-based data."
}], "GuideText",
 CellID->646717645],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["ListLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListLogLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListLogLinearPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " functions."
}], "GuideText",
 CellID->896990680],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["LogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["LogLinearPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["LogLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " functions."
}], "GuideText",
 CellID->42138103],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["PolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListPolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " functions."
}], "GuideText",
 CellID->160353379],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlotMarkers",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PlotMarkers"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " option for indication of data points in multiple datasets."
}], "GuideText",
 CellID->384004708],

Cell[TextData[{
 Cell[TextData[ButtonBox["Joined",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Joined"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " option for joining styles of multiple datasets."
}], "GuideText",
 CellID->884658368],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for visualizing regions described by combinations of inequalities. "
}], "GuideText",
 CellID->2972130],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListDensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListContourPlot"]], "InlineFunctionSans"],
 " support unstructured data, downsampling, smooth colors, region constraints \
and mesh overlays. "
}], "GuideText",
 CellID->184016010],

Cell[TextData[{
 Cell[TextData[ButtonBox["DensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DensityPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 " with adaptivity, smooth colors, region constraints. "
}], "GuideText",
 CellID->485792834],

Cell[TextData[{
 "Convenient support for equation-based contours in ",
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->8068299],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["ReliefPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReliefPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for cartographic and height-based data."
}], "GuideText",
 CellID->679750428],

Cell[TextData[{
 "Enhanced ",
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 " with more detailed data-range capabilities."
}], "GuideText",
 CellID->9409602],

Cell[TextData[{
 "Fully integrated ",
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["LayeredGraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "."
}], "GuideText",
 CellID->825922866],

Cell[TextData[{
 "Support for sparse arrays and color-based data in ",
 Cell[TextData[ButtonBox["Raster",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Raster"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->80412081],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to create a raster image from an arbitrary expression."
}], "GuideText",
 CellID->673076272]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D Visualization", "GuideFunctionsSubsection",
 CellID->90042433],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot3D"]], "InlineFunctionSans"],
 " supports unstructured data, downsampling, region constraints and mesh \
overlays. "
}], "GuideText",
 CellID->6602205],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ParametricPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFunctionSans"],
 " with full adaptive plotting, region constraints and mesh overlays. "
}], "GuideText",
 CellID->998998886],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for 3D contour plotting."
}], "GuideText",
 CellID->220261876],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for visualizing 3D regions described by combinations of inequalities. "
}], "GuideText",
 CellID->252433801],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListSurfacePlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListSurfacePlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 "for 3D surface reconstruction from multivalued data."
}], "GuideText",
 CellID->187416445],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPointPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for 3D scatter plots."
}], "GuideText",
 CellID->465952739],

Cell[TextData[{
 "Fully integrated ",
 Cell[TextData[ButtonBox["RevolutionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["SphericalPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "."
}], "GuideText",
 CellID->152784341],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["NormalsFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalsFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " option to specify effective normal vectors on a surface."
}], "GuideText",
 CellID->821796109],

Cell[TextData[{
 "New ",
 Cell[TextData[ButtonBox["GraphPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for general graph layout in 3D."
}], "GuideText",
 CellID->493876181]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic Visualization", "GuideFunctionsSubsection",
 CellID->356368376],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " as an instant universal interface for dynamic visualization."
}], "GuideText",
 CellID->51031240],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for function- and frame-based animation. "
}], "GuideText",
 CellID->68886085],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "Pane, ",
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", etc. for mouse interaction with graphics. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ClickInteractivePanels"]
}], "GuideText",
 CellID->109785224],

Cell[TextData[{
 "Support for gamepads and other devices. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GamepadAndDeviceInterface"]
}], "GuideText",
 CellID->477724529]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sound", "GuideFunctionsSubsection",
 CellID->147899263],

Cell[TextData[{
 "Note-based symbolic sound, with full MIDI-like support. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SoundAndSonification"]
}], "GuideText",
 CellID->11296780],

Cell[TextData[{
 "Support for arbitrary sound time-warping. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sound"]
}], "GuideText",
 CellID->48482761],

Cell[TextData[{
 "Support for a wide range of note-based instruments and percussion. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SoundNote"]
}], "GuideText",
 CellID->36626700],

Cell[TextData[{
 "Support for combined output of note-based and sampled sound. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sound"]
}], "GuideText",
 CellID->724765684],

Cell[TextData[{
 "Spectrogram representation of sounds in output. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EmitSound"]
}], "GuideText",
 CellID->241022356],

Cell[TextData[{
 "Built-in programmatic support for sound recording dialog. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SystemDialogInput"]
}], "GuideText",
 CellID->901630168],

Cell[TextData[{
 Cell[TextData[ButtonBox["Beep",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Beep"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " added. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Beep"]
}], "GuideText",
 CellID->890653091],

Cell[TextData[{
 "Support for import and export of all standard audio formats. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AudioFormats"]
}], "GuideText",
 CellID->107803054]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Handling & Data Sources", "GuideFunctionsSection",
 CellID->139337527],

Cell[CellGroupData[{

Cell["Large Collections of Curated Data", "GuideFunctionsSubsection",
 CellID->421408595],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. collections of mathematical objects. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalData"]
}], "GuideText",
 CellID->590867822],

Cell[TextData[{
 Cell[TextData[ButtonBox["CityData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CityData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CountryData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CountryData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for geographical, demographic, economic etc. information."
}], "GuideText",
 CellID->25033031],

Cell[TextData[{
 Cell[TextData[ButtonBox["FinancialData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FinancialData"]], "InlineFunctionSans"],
 " for current and historical securities data."
}], "GuideText",
 CellID->16081595],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParticleData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParticleData"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["AstronomicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AstronomicalData"]], "InlineFunctionSans"],
 " collections. "
}], "GuideText",
 CellID->154277387],

Cell[TextData[{
 Cell[TextData[ButtonBox["ElementData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ElementData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["IsotopeData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IsotopeData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ChemicalData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChemicalData"]], "InlineFunctionSans"],
 " collections of chemical and nuclear data. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideText",
 CellID->507439478],

Cell[TextData[{
 "Built-in extensive computable dictionary. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DictionaryLookup"]
}], "GuideText",
 CellID->160195217],

Cell[TextData[{
 Cell[TextData[ButtonBox["WordData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/WordData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " with word properties and relations between words."
}], "GuideText",
 CellID->38728974],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExampleData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExampleData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " collection of standard tests, 3D models, image and audio clips etc."
}], "GuideText",
 CellID->123042678],

Cell[TextData[{
 Cell[TextData[ButtonBox["Missing",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Missing"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for symbolic representation of unavailable data."
}], "GuideText",
 CellID->10228906]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import & Export", "GuideFunctionsSubsection",
 CellID->881370858],

Cell[TextData[{
 "Greatly enhanced ",
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->63029493],

Cell["\<\
New \"elements\" framework allows handling of individual aspects of data \
files.\
\>", "GuideText",
 CellID->5860726],

Cell[TextData[{
 "Greatly extended collection of supported formats. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListingOfAllFormats"]
}], "GuideText",
 CellID->36932718],

Cell["\<\
Lines, Words, UnicodeText are incorporated as elements in universal text \
converter.\
\>", "GuideText",
 CellID->215577464],

Cell["Efficient handling of table import.", "GuideText",
 CellID->201829078],

Cell[TextData[{
 "15+ new formats for 3d geometry models (",
 ButtonBox["PLY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"],
 ", ",
 ButtonBox["OFF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/OFF"],
 ", ",
 ButtonBox["JVX",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JVX"],
 ", ",
 ButtonBox["Maya",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Maya"],
 ", ",
 ButtonBox["DXF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DXF"],
 ", ",
 ButtonBox["STL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/STL"],
 ") ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]
}], "GuideText",
 CellID->47729570],

Cell[TextData[{
 "New image formats (",
 ButtonBox["PXR",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PXR"],
 ", ",
 ButtonBox["TGA",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TGA"],
 ", ",
 ButtonBox["SCT",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SCT"],
 ", ",
 ButtonBox["JPEG200",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG2000"],
 ", ",
 ButtonBox["EMF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EMF"],
 ")."
}], "GuideText",
 CellID->240230487],

Cell[TextData[{
 "Support for EXIF metadata in ",
 ButtonBox["JPEG ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"],
 "and ",
 ButtonBox["GIF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"],
 "."
}], "GuideText",
 CellID->875067492],

Cell[TextData[{
 "New and enhanced handling of scientific and medical data formats ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]
}], "GuideText",
 CellID->34411873],

Cell[TextData[{
 "Support for chemical, biological and medical data formats (",
 ButtonBox["FASTA",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FASTA"],
 ", ",
 ButtonBox["EDF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EDF"],
 ", ",
 ButtonBox["PDB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDB"],
 ", ",
 ButtonBox["MOL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MOL"],
 ", ",
 ButtonBox["XYZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XYZ"],
 ")"
}], "GuideText",
 CellID->1033514650],

Cell[TextData[{
 "Support for geospatial formats (",
 ButtonBox["USGSDEM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/USGSDEM"],
 ", ",
 ButtonBox["GTOPO30",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GTOPO30"],
 ", ",
 ButtonBox["CDED",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CDED"],
 ")"
}], "GuideText",
 CellID->607542955],

Cell[TextData[{
 "Enhanced support for ",
 ButtonBox["SDTS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SDTS"],
 " format."
}], "GuideText",
 CellID->57011457],

Cell[TextData[{
 "Archive and compression formats (",
 ButtonBox["ZIP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZIP"],
 ", ",
 ButtonBox["GZIP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GZIP"],
 ", ",
 ButtonBox["TAR",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TAR"],
 ", ",
 ButtonBox["BZIP2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BZIP2"],
 ", ",
 ButtonBox["UUE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UUE"],
 ", ",
 ButtonBox["Base64",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Base64"],
 ") added."
}], "GuideText",
 CellID->221940427],

Cell["Import and export of directories of files.", "GuideText",
 CellID->632873417],

Cell[TextData[{
 "Database and spreadsheet formats (",
 ButtonBox["MDB",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"],
 ", ",
 ButtonBox["ODS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ODS"],
 ", ",
 ButtonBox["SXC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SXC"],
 ", ",
 ButtonBox["DBF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DBF"],
 ", ",
 ButtonBox["DIF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DIF"],
 ") supported."
}], "GuideText",
 CellID->138199810],

Cell[TextData[{
 "Support for multimedia formats (",
 ButtonBox["SWF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"],
 ", ",
 ButtonBox["QuickTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/QuickTime"],
 ")."
}], "GuideText",
 CellID->264722399],

Cell[TextData[{
 "Audio formats (",
 ButtonBox["FLAC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"],
 ", ",
 ButtonBox["MIDI",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"],
 ", ",
 ButtonBox["Wave64",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Wave64"],
 ", ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AudioFormats"],
 ") added."
}], "GuideText",
 CellID->126252528],

Cell[TextData[{
 "Support for all common codecs for ",
 ButtonBox["WAV",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"],
 ", ",
 ButtonBox["AU",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AU"],
 ", ",
 ButtonBox["AIFF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AIFF"],
 ", ",
 ButtonBox["AVI, ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AVI"],
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MultimediaFormats"]
}], "GuideText",
 CellID->368280513],

Cell[TextData[{
 "Support for mathematical data formats (",
 ButtonBox["XPORT",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XPORT"],
 ", ",
 ButtonBox["MTP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MTP"],
 ", ",
 ButtonBox["MAT",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"],
 ", ",
 ButtonBox["Graph6",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Graph6"],
 ", ",
 ButtonBox["Sparse6",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Sparse6"],
 ")."
}], "GuideText",
 CellID->228682815],

Cell[TextData[{
 "Import and export of web and document formats (",
 ButtonBox["HTML",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"],
 ", ",
 ButtonBox["XHTML",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTML"],
 ", ",
 ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/format/PDF"],
 ", ",
 ButtonBox["RTF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RTF"],
 ", ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WebFormats"],
 ")."
}], "GuideText",
 CellID->309993372],

Cell["Extraction of tabular data from document formats.", "GuideText",
 CellID->175586476],

Cell[TextData[{
 "System and utility formats (Apache log files, ",
 ButtonBox["MBOX",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"],
 ", ",
 ButtonBox["ACO",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ACO"],
 ", ",
 ButtonBox["ICO",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ICO"],
 ", ",
 ButtonBox["CUR",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/CUR"],
 ", ",
 ButtonBox["WDX",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WDX"],
 ") ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SystemsAndUtilityFormats"]
}], "GuideText",
 CellID->313072397]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Handling and Analysis", "GuideFunctionsSubsection",
 CellID->753487641],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ... for data classification. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataClassification"]
}], "GuideText",
 CellID->113219964],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinCounts",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinCounts"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Tally",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tally"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SortBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SortBy"]], "InlineFunctionSans"],
 ", ... for data mining. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalData"]
}], "GuideText",
 CellID->96762233],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to infer formats of files and strings."
}], "GuideText",
 CellID->46628023],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to calculate file hash values."
}], "GuideText",
 CellID->215646713],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compress"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Uncompress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Uncompress"]], "InlineFunctionSans"],
 " for compressed ASCII-encoded representation of any object."
}], "GuideText",
 CellID->24207372],

Cell[TextData[{
 Cell[TextData[ButtonBox["AutorunSequencing",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for automatic activation of dynamic controls in ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 "."
}], "GuideText",
 CellID->74421183],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rasterize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rasterize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 "for conversion to bitmap rasters. "
}], "GuideText",
 CellID->60794357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebooks and Documents", "GuideFunctionsSection",
 CellID->210781766],

Cell[CellGroupData[{

Cell["General Interface Features", "GuideFunctionsSubsection",
 CellID->191238998],

Cell["\<\
Seamless integration of graphics, active controls and mathematical \
typesetting.\
\>", "GuideText",
 CellID->65211010],

Cell[TextData[{
 "New ",
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 " dialog covering a wide range of options. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"]
}], "GuideText",
 CellID->15621853],

Cell["Menus rearranged for simplicity of use.", "GuideText",
 CellID->33397827],

Cell["Integrated searching in help windows.", "GuideText",
 CellID->262024968],

Cell["Support for multiple simultaneous help windows.", "GuideText",
 CellID->245528514],

Cell["Restyled slide show creator.", "GuideText",
 CellID->368488996],

Cell["Built-in template for The Wolfram Demonstrations Project.", "GuideText",
 CellID->409322887],

Cell[TextData[{
 "Nearly 700 new detailed interface options and suboptions. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"]
}], "GuideText",
 CellID->2943607],

Cell[TextData[{
 Cell[TextData[ButtonBox["OutputSizeLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OutputSizeLimit"]], "InlineFunctionSans"],
 " to prevent unexpectedly large output."
}], "GuideText",
 CellID->183817266],

Cell[TextData[{
 "200+ new symbolic notational operators  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolicNotationalForms"]
}], "GuideText",
 CellID->881027685]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Structure & Appearance", "GuideFunctionsSubsection",
 CellID->360422416],

Cell["General reverse-closed cells allowing code hiding.", "GuideText",
 CellID->151117327],

Cell[TextData[{
 "Support for arbitrary docked cells for notebook toolbars. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DockedCells"]
}], "GuideText",
 CellID->61068910],

Cell["Support for manually definable cell groupings.", "GuideText",
 CellID->439593527],

Cell[TextData[{
 "Support for notebook-unique and cell-unique namespaces. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NamespaceManagement"]
}], "GuideText",
 CellID->83699528],

Cell["Adaptive horizontal scrollbar.", "GuideText",
 CellID->36777925],

Cell[TextData[{
 "Support for full-screen presentation mode. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PresentationsWithMathematica"]
}], "GuideText",
 CellID->77319888],

Cell[TextData[{
 "Support for transparent windows. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WindowOpacity"]
}], "GuideText",
 CellID->430114374],

Cell[TextData[{
 "Programmatic access to window status area. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WindowStatusArea"]
}], "GuideText",
 CellID->250328602]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input & Output", "GuideFunctionsSubsection",
 CellID->14048357],

Cell["Comprehensive real-time semantically driven syntax coloring.", \
"GuideText",
 CellID->83214551],

Cell["Immediate visual feedback on function names and spelling.", "GuideText",
 CellID->242019669],

Cell["Visual indication of function argument structures.", "GuideText",
 CellID->122219523],

Cell["Automatic italicization of function variables.", "GuideText",
 CellID->40619672],

Cell["Automatic variable scope indication.", "GuideText",
 CellID->54817579],

Cell[TextData[{
 "User-definable syntax coloring. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SyntaxInformation"]
}], "GuideText",
 CellID->135087927],

Cell["Automatic blocking of digits in long input numbers.", "GuideText",
 CellID->108251802],

Cell[TextData[{
 "Automatic \[Times] insertion for implied multiplication. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoMultiplicationSymbol"]
}], "GuideText",
 CellID->235550655],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["\[Backslash]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"],
  ButtonBox["ImplicitPlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"]
 }], "InlineFunctionSans"],
 " for entry of mixed fractions. "
}], "GuideText",
 CellID->1130919488],

Cell["Improved font-aware spanning character rendering.", "GuideText",
 CellID->192896123],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["[", "KeyEvent"],
 ", ",
 StyleBox["{", "KeyEvent"],
 ", ",
 StyleBox["(", "KeyEvent"],
 " for creating matched pairs of brackets."
}], "GuideText",
 CellID->178090585]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formatting & Styling", "GuideFunctionsSubsection",
 CellID->300531919],

Cell[TextData[{
 "Direct programmatic access to all styling, using ",
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "."
}], "GuideText",
 CellID->336762732],

Cell["\<\
Full support for style inheritance and cascading stylesheets.\
\>", "GuideText",
 CellID->540170135],

Cell["Enhanced stylesheet editing mechanism.", "GuideText",
 CellID->43003340],

Cell[TextData[{
 "Full support for spanning rows and columns in tables. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SpanFromLeft"]
}], "GuideText",
 CellID->1002460597],

Cell[TextData[{
 "Direct support for ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and related constructs."
}], "GuideText",
 CellID->427532127],

Cell[TextData[{
 "Extensive new table formatting options. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GridsAndTables"]
}], "GuideText",
 CellID->77930559],

Cell[TextData[{
 "Symbolic ",
 Cell[TextData[ButtonBox["Framed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Framed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Labeled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Labeled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. constructs."
}], "GuideText",
 CellID->57230158],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bold",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Bold"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Italic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Italic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Underlined",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Underlined"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. symbolic font settings. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FontOptions"]
}], "GuideText",
 CellID->478329029],

Cell[TextData[{
 Cell[TextData[ButtonBox["LineSpacing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LineSpacing"]], "InlineFunctionSans"],
 " enhanced to optimize inline graphics display."
}], "GuideText",
 CellID->320302670],

Cell[TextData[{
 Cell[TextData[ButtonBox["Magnify",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Magnify"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for expression-based magnification."
}], "GuideText",
 CellID->638273576],

Cell[TextData[{
 Cell[TextData[ButtonBox["Spacer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Spacer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Invisible",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Invisible"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " text formatting elements."
}], "GuideText",
 CellID->23800257]
}, Open  ]],

Cell[CellGroupData[{

Cell["Workflow Enhancements", "GuideFunctionsSubsection",
 CellID->182908213],

Cell["Integrated notebook-based editor for .m package files.", "GuideText",
 CellID->845729164],

Cell[TextData[{
 "Cell change times tracking. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellChangeTimes"]
}], "GuideText",
 CellID->435835457],

Cell[TextData[{
 "Graphical notebook history overview, with drill-down. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/NotebookHistory"]
}], "GuideText",
 CellID->105247343],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookDirectory",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NotebookDirectory"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " front end directory function."
}], "GuideText",
 CellID->78373458],

Cell[TextData[{
 Cell[TextData[ButtonBox["$UserDocumentsDirectory",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$UserDocumentsDirectory"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for easy access to saved documents."
}], "GuideText",
 CellID->202048423],

Cell[TextData[{
 "Easy programmatic access to cell grouping. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowGroupOpener"]
}], "GuideText",
 CellID->65631164]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation Control", "GuideFunctionsSubsection",
 CellID->203864978],

Cell[TextData[{
 "Notebook and cell-group localized evaluation contexts. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellContext"]
}], "GuideText",
 CellID->8251307],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellProlog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellProlog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CellEpilog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellEpilog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for cell evaluation. "
}], "GuideText",
 CellID->147055662],

Cell[TextData[{
 "Arbitrary style-settable evaluation function for any cell. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellEvaluationFunction"]
}], "GuideText",
 CellID->61351082],

Cell[TextData[{
 "Arbitrary event handlers for notebooks, cells and globally. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelInterfaceControl"]
}], "GuideText",
 CellID->480991479],

Cell[TextData[{
 "Settable automatic limiting of overly long output. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$OutputSizeLimit"]
}], "GuideText",
 CellID->367256643]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interoperability", "GuideFunctionsSubsection",
 CellID->587756692],

Cell[TextData[{
 "Automatic format recognition and conversion in ",
 StyleBox[ButtonBox["Copy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Copy"], "MenuName"],
 "/",
 StyleBox[ButtonBox["Paste",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Paste"], "MenuName"],
 "."
}], "GuideText",
 CellID->182711109],

Cell["\<\
Automatic preservation of quotes, newlines, etc. in pasted strings.\
\>", "GuideText",
 CellID->432469465],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["C", "KeyEvent"],
 " for ",
 StyleBox[ButtonBox["Copy As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CopyAs"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Plain Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PlainText"], "MenuName"],
 ". ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NotebookShortcuts"]
}], "GuideText",
 CellID->231885768],

Cell[TextData[{
 "Automatic import and export of GIF, TIFF, JPEG, PNG, SVG, PDF, ... images \
in notebooks. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsImportingAndExporting"]
}], "GuideText",
 CellID->516412911],

Cell[TextData[{
 "Support for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]]],
 "/",
 Cell[BoxData[
  StyleBox[
   RowBox[{"L", 
    StyleBox[
     AdjustmentBox["A",
      BoxBaselineShift->-0.2,
      BoxMargins->{{-0.36, -0.1}, {0, 0}}],
     FontSize->Smaller], "T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]]],
 " import, with paste auto-detection. "
}], "GuideText",
 CellID->146270953],

Cell[TextData[{
 "Automatic stripping of email annotations when pasting into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "GuideText",
 CellID->38549300],

Cell["Extended support for localized filenames under Windows.", "GuideText",
 CellID->327809182]
}, Open  ]],

Cell[CellGroupData[{

Cell["Document Programming", "GuideFunctionsSubsection",
 CellID->600170837],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDocument",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateDocument"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " etc. for immediate creation of symbolic documents."
}], "GuideText",
 CellID->58597201],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " to display an arbitrary notebook expression."
}], "GuideText",
 CellID->127546792],

Cell[TextData[{
 Cell[TextData[ButtonBox["TextCell",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TextCell"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["ExpressionCell",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpressionCell"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", etc. for direct symbolic document representation."
}], "GuideText",
 CellID->261593123],

Cell[TextData[{
 "Display of notebook expression objects within other notebooks. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DocumentNotebook"]
}], "GuideText",
 CellID->202529566],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hyperlink",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Hyperlink"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for symbolic representation of hyperlinks."
}], "GuideText",
 CellID->594979699],

Cell[TextData[{
 Cell[TextData[ButtonBox["Defer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Defer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for creating a cell containing evaluatable input."
}], "GuideText",
 CellID->337197047],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellGroup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellGroup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for symbolic cell grouping in document generation."
}], "GuideText",
 CellID->82412461]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics in Notebooks", "GuideFunctionsSubsection",
 CellID->19673033],

Cell["Interactive graphics scrollable in notebook.", "GuideText",
 CellID->54856008],

Cell["Real-time 3D rotation anywhere in notebook.", "GuideText",
 CellID->755623741],

Cell["Automatic resizing of graphics in text, etc.", "GuideText",
 CellID->575828348],

Cell[TextData[{
 "New ",
 StyleBox["Drawing Tools", "DialogElementName"],
 " palette. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/DrawingTools"]
}], "GuideText",
 CellID->305990220],

Cell[TextData[{
 "New ",
 StyleBox["Graphics Inspector", "DialogElementName"],
 " palette. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"]
}], "GuideText",
 CellID->563300997],

Cell["Stylesheet control over graphics sizing and styling.", "GuideText",
 CellID->188522855]
}, Open  ]],

Cell[CellGroupData[{

Cell["Platforms & Infrastructure", "GuideFunctionsSubsection",
 CellID->142985810],

Cell["Support for Windows Vista.", "GuideText",
 CellID->803623653],

Cell["QT-based window interface on Unix and Linux.", "GuideText",
 CellID->186169413],

Cell["64-bit front end support on all platforms.", "GuideText",
 CellID->640692232],

Cell["Security features for dynamic notebook evaluation.", "GuideText",
 CellID->32878720],

Cell[TextData[{
 StyleBox[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Install"], "MenuName"],
 " menu for installing add-on components. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Install"]
}], "GuideText",
 CellID->36541574],

Cell["Modernized interface for stand-alone kernel under Windows.", "GuideText",
 CellID->366317934]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems Interfaces & Deployment", "GuideFunctionsSection",
 CellID->408798641],

Cell[CellGroupData[{

Cell["Core System", "GuideFunctionsSubsection",
 CellID->82968555],

Cell["\<\
Major new preemptive kernel mechanism to support dynamic interactivity.\
\>", "GuideText",
 CellID->283060494],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemInformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemInformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " system dashboard with 120+ dynamically reported properties."
}], "GuideText",
 CellID->16761672],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " access to 250+ settable low-level system options and suboptions."
}], "GuideText",
 CellID->32766997],

Cell[TextData[{
 Cell[TextData[ButtonBox["$CharacterEncodings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFunctionSans"],
 " character encoding discovery interface."
}], "GuideText",
 CellID->199500227],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MachineDomains",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$MachineDomains"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["$MachineAddresses",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$MachineAddresses"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for internet property discovery. "
}], "GuideText",
 CellID->121106049],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemoryInUse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryInUse"]], "InlineFunctionSans"],
 " extended to report front end process memory."
}], "GuideText",
 CellID->5530752],

Cell[TextData[{
 Cell[TextData[ButtonBox["$SystemWordLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$SystemWordLength"]], "InlineFunctionSans"],
 " system parameter."
}], "GuideText",
 CellID->69139084],

Cell[TextData[{
 "Updated mechanism to clear cached results of computations. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClearSystemCache"]
}], "GuideText",
 CellID->53994365]
}, Open  ]],

Cell[CellGroupData[{

Cell["Files & Web Connectivity", "GuideFunctionsSubsection",
 CellID->130006915],

Cell["\<\
Streamlined handling of all internet connectivity, including proxies, etc.\
\>", "GuideText",
 CellID->435064386],

Cell[TextData[{
 "Support for string patterns in file names.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FileNames"]
}], "GuideText",
 CellID->504171564],

Cell["New file interlock mechanism.", "GuideText",
 CellID->22519836],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for fast file hashing."
}], "GuideText",
 CellID->252603948],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CreateDirectory"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["OpenWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OpenWrite"]], "InlineFunctionSans"],
 ", etc. to automatically handle temporary files."
}], "GuideText",
 CellID->834735170],

Cell[TextData[{
 Cell[TextData[ButtonBox["FilePrint",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FilePrint"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for printing file contents directly in a notebook."
}], "GuideText",
 CellID->67645730]
}, Open  ]],

Cell[CellGroupData[{

Cell["Connection Infrastructure", "GuideFunctionsSubsection",
 CellID->316621919],

Cell[TextData[{
 "New shared memory ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " protocol for Macintosh and Unix."
}], "GuideText",
 CellID->462621252],

Cell[TextData[{
 "10\[Times] throughput increase for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " shared memory devices. "
}], "GuideText",
 CellID->33725922],

Cell[TextData[{
 "Shared dynamic ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries on all platforms."
}], "GuideText",
 CellID->52461951],

Cell[TextData[{
 "Support for UTF-8, UTF-16, UTF-32 in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "GuideText",
 CellID->171765573]
}, Open  ]],

Cell[CellGroupData[{

Cell["APIs", "GuideFunctionsSubsection",
 CellID->918202346],

Cell[TextData[{
 "Major modernization of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideText",
 CellID->285451918],

Cell[TextData[{
 "Full support for installing and calling web services.  ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InstallService"]
}], "GuideText",
 CellID->3248492]
}, Open  ]],

Cell[CellGroupData[{

Cell["Device Connectivity", "GuideFunctionsSubsection",
 CellID->52094258],

Cell[TextData[{
 "Auto-detect support for arbitrary HID systems. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GamepadAndDeviceInterface"]
}], "GuideText",
 CellID->58662365],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerPath",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerPath"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " for prioritizing devices."
}], "GuideText",
 CellID->109901704],

Cell[TextData[{
 "Special controller mappings for standard gamepads and 3D devices. ",
 ButtonBox[">>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ControllerState"]
}], "GuideText",
 CellID->524010285]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional Components", "GuideFunctionsSection",
 CellID->31225209],

Cell["Completely new documentation system, in-product and on-web.", \
"GuideText",
 CellID->148236057],

Cell["\<\
Equivalent of 20,000+ pages of new documentation and tutorials.\
\>", "GuideText",
 CellID->900925586],

Cell[TextData[{
 "25,000+ new examples of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functionality."
}], "GuideText",
 CellID->142270156],

Cell[TextData[{
 "300+ \"guide page\" concept maps of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functionality."
}], "GuideText",
 CellID->747779891],

Cell["150,000+ new cross-links between documentation elements.", "GuideText",
 CellID->195787573],

Cell["In-product and on-web linguistic-aware search system.", "GuideText",
 CellID->48488680],

Cell["Load-on-demand system with automatic documentation updating.", \
"GuideText",
 CellID->31865668],

Cell["The Wolfram Demonstrations Project with 1000+ entries.", "GuideText",
 CellID->250547780],

Cell[TextData[{
 "New ",
 StyleBox["Mathematica Player",
  FontSlant->"Italic"],
 " with dynamic content capabilities."
}], "GuideText",
 CellID->36931372],

Cell["Copernic support in Wolfram Notebook Indexer (Windows only).", \
"GuideText",
 CellID->104060192],

Cell[TextData[{
 "Automatic compatibility scanning of older ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks."
}], "GuideText",
 CellID->434874434]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Listing of All New Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlphabeticalListing"]], "GuideMoreAboutSub",\

 CellID->582854384]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Summary of New Features in 6.0 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 15.7847410}", "context" -> "", 
    "keywords" -> {
     "new features", "Mathematica 6", "6.0", "Mathematica reinvented", 
      "new capabilities", "announcements"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "", "status" -> 
    "None", "summary" -> 
    "Mathematica 6.0 fundamentally redefines Mathematica and introduces a \
major new paradigm for computation. Building on Mathematica's time-tested \
core symbolic architecture, Version 6.0 adds nearly a thousand new \
functions--almost doubling the total number of functions in the \
system--dramatically increasing both the breadth and depth of Mathematica's \
capabilities, as well as introducing hundreds of major original algorithms, \
and perhaps a thousand new ideas, large and small. ", "synonyms" -> {}, 
    "title" -> "Summary of New Features in 6.0", "type" -> "Guide", "uri" -> 
    "guide/SummaryOfNewFeaturesIn60"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 72, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[694, 28, 731, 18, 70, "GuideAbstract",
 CellID->2001916300]
}, Open  ]],
Cell[CellGroupData[{
Cell[1462, 51, 156, 3, 70, "GuideFunctionsSection",
 CellID->201610654],
Cell[CellGroupData[{
Cell[1643, 58, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->9319498],
Cell[1730, 61, 390, 12, 70, "GuideText",
 CellID->98869818],
Cell[2123, 75, 378, 9, 70, "GuideText",
 CellID->16926488],
Cell[2504, 86, 230, 6, 70, "GuideText",
 CellID->138044753],
Cell[2737, 94, 368, 9, 70, "GuideText",
 CellID->18169366],
Cell[3108, 105, 221, 6, 70, "GuideText",
 CellID->188284072],
Cell[3332, 113, 209, 6, 70, "GuideText",
 CellID->128782558],
Cell[3544, 121, 211, 6, 70, "GuideText",
 CellID->278239285],
Cell[3758, 129, 348, 10, 70, "GuideText",
 CellID->391533991],
Cell[4109, 141, 233, 6, 70, "GuideText",
 CellID->21115004],
Cell[4345, 149, 380, 10, 70, "GuideText",
 CellID->16732978],
Cell[4728, 161, 646, 16, 70, "GuideText",
 CellID->637004094],
Cell[5377, 179, 648, 16, 70, "GuideText",
 CellID->94881002],
Cell[6028, 197, 364, 9, 70, "GuideText",
 CellID->163889897],
Cell[6395, 208, 350, 9, 70, "GuideText",
 CellID->353190769],
Cell[6748, 219, 638, 16, 70, "GuideText",
 CellID->359031881],
Cell[7389, 237, 357, 11, 70, "GuideText",
 CellID->468360581],
Cell[7749, 250, 448, 15, 70, "GuideText",
 CellID->202291337]
}, Open  ]],
Cell[CellGroupData[{
Cell[8234, 270, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->426141213],
Cell[8312, 273, 630, 16, 70, "GuideText",
 CellID->322789566],
Cell[8945, 291, 191, 6, 70, "GuideText",
 CellID->161239270],
Cell[9139, 299, 238, 8, 70, "GuideText",
 CellID->46889215],
Cell[9380, 309, 348, 11, 70, "GuideText",
 CellID->62243854],
Cell[9731, 322, 642, 16, 70, "GuideText",
 CellID->12243738],
Cell[10376, 340, 347, 9, 70, "GuideText",
 CellID->288013558]
}, Open  ]],
Cell[CellGroupData[{
Cell[10760, 354, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->27518964],
Cell[10843, 357, 229, 7, 70, "GuideText",
 CellID->477005702],
Cell[11075, 366, 374, 9, 70, "GuideText",
 CellID->143163979],
Cell[11452, 377, 378, 9, 70, "GuideText",
 CellID->144562658],
Cell[11833, 388, 196, 6, 70, "GuideText",
 CellID->28341705],
Cell[12032, 396, 188, 6, 70, "GuideText",
 CellID->210610845],
Cell[12223, 404, 193, 6, 70, "GuideText",
 CellID->356571299],
Cell[12419, 412, 197, 7, 70, "GuideText",
 CellID->262252336],
Cell[12619, 421, 350, 10, 70, "GuideText",
 CellID->502030374],
Cell[12972, 433, 184, 6, 70, "GuideText",
 CellID->146998744]
}, Open  ]],
Cell[CellGroupData[{
Cell[13193, 444, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->457410545],
Cell[13276, 447, 177, 6, 70, "GuideText",
 CellID->2212985],
Cell[13456, 455, 177, 6, 70, "GuideText",
 CellID->25039394],
Cell[13636, 463, 182, 6, 70, "GuideText",
 CellID->333226429],
Cell[13821, 471, 179, 6, 70, "GuideText",
 CellID->158052593],
Cell[14003, 479, 191, 6, 70, "GuideText",
 CellID->87018944],
Cell[14197, 487, 222, 6, 70, "GuideText",
 CellID->821473875],
Cell[14422, 495, 366, 11, 70, "GuideText",
 CellID->409077209]
}, Open  ]],
Cell[CellGroupData[{
Cell[14825, 511, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->639363691],
Cell[14899, 514, 371, 9, 70, "GuideText",
 CellID->6085468],
Cell[15273, 525, 227, 6, 70, "GuideText",
 CellID->304448955],
Cell[15503, 533, 210, 6, 70, "GuideText",
 CellID->138210334],
Cell[15716, 541, 180, 6, 70, "GuideText",
 CellID->557826620]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15945, 553, 74, 1, 70, "GuideFunctionsSection",
 CellID->322528867],
Cell[CellGroupData[{
Cell[16044, 558, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->828305781],
Cell[16127, 561, 380, 9, 70, "GuideText",
 CellID->68141558],
Cell[16510, 572, 96, 1, 70, "GuideText",
 CellID->477222907],
Cell[16609, 575, 205, 6, 70, "GuideText",
 CellID->33752157],
Cell[16817, 583, 203, 6, 70, "GuideText",
 CellID->859750128],
Cell[17023, 591, 180, 6, 70, "GuideText",
 CellID->703999471],
Cell[17206, 599, 205, 6, 70, "GuideText",
 CellID->696759615],
Cell[17414, 607, 78, 1, 70, "GuideText",
 CellID->311179905],
Cell[17495, 610, 198, 6, 70, "GuideText",
 CellID->444049655],
Cell[17696, 618, 182, 6, 70, "GuideText",
 CellID->114575713]
}, Open  ]],
Cell[CellGroupData[{
Cell[17915, 629, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->378219929],
Cell[17995, 632, 1696, 44, 70, "GuideText",
 CellID->360333661],
Cell[19694, 678, 251, 7, 70, "GuideText",
 CellID->285356196],
Cell[19948, 687, 1190, 30, 70, "GuideText",
 CellID->101796930],
Cell[21141, 719, 244, 7, 70, "GuideText",
 CellID->260931488],
Cell[21388, 728, 399, 9, 70, "GuideText",
 CellID->249138647],
Cell[21790, 739, 632, 16, 70, "GuideText",
 CellID->577374319],
Cell[22425, 757, 631, 16, 70, "GuideText",
 CellID->161296430],
Cell[23059, 775, 914, 23, 70, "GuideText",
 CellID->531886007]
}, Open  ]],
Cell[CellGroupData[{
Cell[24010, 803, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->28833099],
Cell[24085, 806, 218, 7, 70, "GuideText",
 CellID->71812222],
Cell[24306, 815, 667, 17, 70, "GuideText",
 CellID->885948110],
Cell[24976, 834, 215, 6, 70, "GuideText",
 CellID->13985895],
Cell[25194, 842, 172, 6, 70, "GuideText",
 CellID->678056046],
Cell[25369, 850, 366, 9, 70, "GuideText",
 CellID->13446634],
Cell[25738, 861, 1153, 30, 70, "GuideText",
 CellID->294855493],
Cell[26894, 893, 491, 13, 70, "GuideText",
 CellID->66103338],
Cell[27388, 908, 354, 9, 70, "GuideText",
 CellID->11463108],
Cell[27745, 919, 915, 23, 70, "GuideText",
 CellID->152519472],
Cell[28663, 944, 233, 6, 70, "GuideText",
 CellID->23030144],
Cell[28899, 952, 388, 10, 70, "GuideText",
 CellID->995049188],
Cell[29290, 964, 378, 10, 70, "GuideText",
 CellID->13268257],
Cell[29671, 976, 382, 9, 70, "GuideText",
 CellID->130345485],
Cell[30056, 987, 636, 16, 70, "GuideText",
 CellID->150967746],
Cell[30695, 1005, 390, 10, 70, "GuideText",
 CellID->140031874],
Cell[31088, 1017, 363, 9, 70, "GuideText",
 CellID->99671765],
Cell[31454, 1028, 355, 9, 70, "GuideText",
 CellID->77293379],
Cell[31812, 1039, 389, 9, 70, "GuideText",
 CellID->460485435],
Cell[32204, 1050, 380, 9, 70, "GuideText",
 CellID->453425578],
Cell[32587, 1061, 206, 6, 70, "GuideText",
 CellID->147015558],
Cell[32796, 1069, 651, 16, 70, "GuideText",
 CellID->489320271],
Cell[33450, 1087, 219, 7, 70, "GuideText",
 CellID->338767391],
Cell[33672, 1096, 609, 17, 70, "GuideText",
 CellID->76348298],
Cell[34284, 1115, 365, 9, 70, "GuideText",
 CellID->133931082]
}, Open  ]],
Cell[CellGroupData[{
Cell[34686, 1129, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->481430176],
Cell[34775, 1132, 400, 10, 70, "GuideText",
 CellID->155524844],
Cell[35178, 1144, 463, 13, 70, "GuideText",
 CellID->359202113],
Cell[35644, 1159, 395, 9, 70, "GuideText",
 CellID->143871343],
Cell[36042, 1170, 175, 6, 70, "GuideText",
 CellID->677537328],
Cell[36220, 1178, 186, 6, 70, "GuideText",
 CellID->201299114],
Cell[36409, 1186, 379, 9, 70, "GuideText",
 CellID->42404386],
Cell[36791, 1197, 219, 7, 70, "GuideText",
 CellID->18861162]
}, Open  ]],
Cell[CellGroupData[{
Cell[37047, 1209, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->151023455],
Cell[37135, 1212, 187, 6, 70, "GuideText",
 CellID->818241640],
Cell[37325, 1220, 131, 4, 70, "GuideText",
 CellID->89861596],
Cell[37459, 1226, 365, 10, 70, "GuideText",
 CellID->590956203],
Cell[37827, 1238, 232, 7, 70, "GuideText",
 CellID->139582891],
Cell[38062, 1247, 196, 6, 70, "GuideText",
 CellID->171290032],
Cell[38261, 1255, 213, 6, 70, "GuideText",
 CellID->50250718],
Cell[38477, 1263, 114, 3, 70, "GuideText",
 CellID->91776225],
Cell[38594, 1268, 373, 9, 70, "GuideText",
 CellID->138977703],
Cell[38970, 1279, 635, 16, 70, "GuideText",
 CellID->731123111],
Cell[39608, 1297, 660, 16, 70, "GuideText",
 CellID->372965815],
Cell[40271, 1315, 659, 16, 70, "GuideText",
 CellID->276033374],
Cell[40933, 1333, 186, 6, 70, "GuideText",
 CellID->179854941],
Cell[41122, 1341, 648, 16, 70, "GuideText",
 CellID->681783268],
Cell[41773, 1359, 225, 7, 70, "GuideText",
 CellID->100410379],
Cell[42001, 1368, 385, 10, 70, "GuideText",
 CellID->244526769],
Cell[42389, 1380, 387, 9, 70, "GuideText",
 CellID->252353505],
Cell[42779, 1391, 350, 9, 70, "GuideText",
 CellID->82054703],
Cell[43132, 1402, 388, 9, 70, "GuideText",
 CellID->281586042],
Cell[43523, 1413, 641, 16, 70, "GuideText",
 CellID->557929191]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44213, 1435, 78, 1, 70, "GuideFunctionsSection",
 CellID->32151889],
Cell[CellGroupData[{
Cell[44316, 1440, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->567202398],
Cell[44397, 1443, 464, 14, 70, "GuideText",
 CellID->6831296],
Cell[44864, 1459, 212, 7, 70, "GuideText",
 CellID->54373158],
Cell[45079, 1468, 203, 6, 70, "GuideText",
 CellID->64654151],
Cell[45285, 1476, 198, 6, 70, "GuideText",
 CellID->75322184],
Cell[45486, 1484, 194, 6, 70, "GuideText",
 CellID->260275068],
Cell[45683, 1492, 176, 6, 70, "GuideText",
 CellID->45820978],
Cell[45862, 1500, 616, 16, 70, "GuideText",
 CellID->41160406],
Cell[46481, 1518, 202, 6, 70, "GuideText",
 CellID->238673628],
Cell[46686, 1526, 158, 6, 70, "GuideText",
 CellID->10281983],
Cell[46847, 1534, 165, 6, 70, "GuideText",
 CellID->392450815],
Cell[47015, 1542, 216, 6, 70, "GuideText",
 CellID->1002584],
Cell[47234, 1550, 119, 3, 70, "GuideText",
 CellID->135725829]
}, Open  ]],
Cell[CellGroupData[{
Cell[47390, 1558, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->704053081],
Cell[47466, 1561, 120, 3, 70, "GuideText",
 CellID->504832195],
Cell[47589, 1566, 889, 23, 70, "GuideText",
 CellID->295668876],
Cell[48481, 1591, 227, 6, 70, "GuideText",
 CellID->938244732],
Cell[48711, 1599, 895, 23, 70, "GuideText",
 CellID->147772664],
Cell[49609, 1624, 353, 9, 70, "GuideText",
 CellID->572601159],
Cell[49965, 1635, 342, 9, 70, "GuideText",
 CellID->119346176],
Cell[50310, 1646, 337, 9, 70, "GuideText",
 CellID->98727143],
Cell[50650, 1657, 336, 9, 70, "GuideText",
 CellID->220979850],
Cell[50989, 1668, 605, 16, 70, "GuideText",
 CellID->485602411],
Cell[51597, 1686, 628, 16, 70, "GuideText",
 CellID->215940184],
Cell[52228, 1704, 227, 6, 70, "GuideText",
 CellID->837041664],
Cell[52458, 1712, 369, 9, 70, "GuideText",
 CellID->394571081],
Cell[52830, 1723, 198, 6, 70, "GuideText",
 CellID->51164511],
Cell[53031, 1731, 391, 9, 70, "GuideText",
 CellID->825444987]
}, Open  ]],
Cell[CellGroupData[{
Cell[53459, 1745, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->590680085],
Cell[53531, 1748, 230, 8, 70, "GuideText",
 CellID->52738223],
Cell[53764, 1758, 380, 9, 70, "GuideText",
 CellID->103612628],
Cell[54147, 1769, 378, 9, 70, "GuideText",
 CellID->111025215],
Cell[54528, 1780, 195, 6, 70, "GuideText",
 CellID->241025712],
Cell[54726, 1788, 186, 6, 70, "GuideText",
 CellID->57499680],
Cell[54915, 1796, 224, 6, 70, "GuideText",
 CellID->146542830],
Cell[55142, 1804, 218, 6, 70, "GuideText",
 CellID->33089224],
Cell[55363, 1812, 212, 7, 70, "GuideText",
 CellID->345840383],
Cell[55578, 1821, 641, 16, 70, "GuideText",
 CellID->252670490]
}, Open  ]],
Cell[CellGroupData[{
Cell[56256, 1842, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->96497051],
Cell[56334, 1845, 253, 6, 70, "GuideText",
 CellID->234399947],
Cell[56590, 1853, 230, 7, 70, "GuideText",
 CellID->258488735],
Cell[56823, 1862, 236, 6, 70, "GuideText",
 CellID->27446544],
Cell[57062, 1870, 175, 6, 70, "GuideText",
 CellID->332988343],
Cell[57240, 1878, 241, 6, 70, "GuideText",
 CellID->409847533],
Cell[57484, 1886, 199, 6, 70, "GuideText",
 CellID->23111163],
Cell[57686, 1894, 258, 6, 70, "GuideText",
 CellID->500343366],
Cell[57947, 1902, 464, 14, 70, "GuideText",
 CellID->193634535],
Cell[58414, 1918, 369, 9, 70, "GuideText",
 CellID->298242870],
Cell[58786, 1929, 225, 7, 70, "GuideText",
 CellID->7863569],
Cell[59014, 1938, 176, 6, 70, "GuideText",
 CellID->529111110],
Cell[59193, 1946, 669, 17, 70, "GuideText",
 CellID->61972286],
Cell[59865, 1965, 200, 6, 70, "GuideText",
 CellID->93948210],
Cell[60068, 1973, 512, 13, 70, "GuideText",
 CellID->114450720],
Cell[60583, 1988, 212, 6, 70, "GuideText",
 CellID->641272487],
Cell[60798, 1996, 186, 6, 70, "GuideText",
 CellID->167827317],
Cell[60987, 2004, 208, 6, 70, "GuideText",
 CellID->142499084],
Cell[61198, 2012, 92, 1, 70, "GuideText",
 CellID->326714257],
Cell[61293, 2015, 105, 3, 70, "GuideText",
 CellID->61328379],
Cell[61401, 2020, 351, 9, 70, "GuideText",
 CellID->64631236]
}, Open  ]],
Cell[CellGroupData[{
Cell[61789, 2034, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->580899261],
Cell[61865, 2037, 210, 6, 70, "GuideText",
 CellID->81842804],
Cell[62078, 2045, 197, 6, 70, "GuideText",
 CellID->133394618],
Cell[62278, 2053, 255, 7, 70, "GuideText",
 CellID->51629389],
Cell[62536, 2062, 225, 7, 70, "GuideText",
 CellID->315014471],
Cell[62764, 2071, 628, 16, 70, "GuideText",
 CellID->117547825],
Cell[63395, 2089, 211, 6, 70, "GuideText",
 CellID->204797308],
Cell[63609, 2097, 647, 16, 70, "GuideText",
 CellID->212040543],
Cell[64259, 2115, 651, 16, 70, "GuideText",
 CellID->35595821],
Cell[64913, 2133, 190, 6, 70, "GuideText",
 CellID->22812214],
Cell[65106, 2141, 375, 9, 70, "GuideText",
 CellID->32011996],
Cell[65484, 2152, 394, 9, 70, "GuideText",
 CellID->379580304]
}, Open  ]],
Cell[CellGroupData[{
Cell[65915, 2166, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->202368338],
Cell[65999, 2169, 218, 6, 70, "GuideText",
 CellID->68680975],
Cell[66220, 2177, 179, 6, 70, "GuideText",
 CellID->83209894],
Cell[66402, 2185, 215, 6, 70, "GuideText",
 CellID->30344631],
Cell[66620, 2193, 217, 6, 70, "GuideText",
 CellID->228521069],
Cell[66840, 2201, 363, 9, 70, "GuideText",
 CellID->317121513],
Cell[67206, 2212, 247, 7, 70, "GuideText",
 CellID->408922351],
Cell[67456, 2221, 212, 7, 70, "GuideText",
 CellID->386716995],
Cell[67671, 2230, 357, 10, 70, "GuideText",
 CellID->99428886],
Cell[68031, 2242, 225, 6, 70, "GuideText",
 CellID->474749534],
Cell[68259, 2250, 891, 23, 70, "GuideText",
 CellID->65235067],
Cell[69153, 2275, 196, 6, 70, "GuideText",
 CellID->28144346],
Cell[69352, 2283, 344, 9, 70, "GuideText",
 CellID->676680715],
Cell[69699, 2294, 471, 12, 70, "GuideText",
 CellID->186581428],
Cell[70173, 2308, 364, 9, 70, "GuideText",
 CellID->134560209]
}, Open  ]],
Cell[CellGroupData[{
Cell[70574, 2322, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->262726065],
Cell[70659, 2325, 231, 7, 70, "GuideText",
 CellID->245192878],
Cell[70893, 2334, 190, 6, 70, "GuideText",
 CellID->322479303],
Cell[71086, 2342, 896, 23, 70, "GuideText",
 CellID->271345060],
Cell[71985, 2367, 375, 9, 70, "GuideText",
 CellID->216757333],
Cell[72363, 2378, 392, 9, 70, "GuideText",
 CellID->116593529],
Cell[72758, 2389, 202, 6, 70, "GuideText",
 CellID->2710797],
Cell[72963, 2397, 469, 13, 70, "GuideText",
 CellID->245608352],
Cell[73435, 2412, 209, 6, 70, "GuideText",
 CellID->286566132],
Cell[73647, 2420, 244, 7, 70, "GuideText",
 CellID->83469500]
}, Open  ]],
Cell[CellGroupData[{
Cell[73928, 2432, 102, 2, 70, "GuideFunctionsSubsection",
 CellID->334564919],
Cell[74033, 2436, 200, 6, 70, "GuideText",
 CellID->430210760],
Cell[74236, 2444, 188, 6, 70, "GuideText",
 CellID->680221207],
Cell[74427, 2452, 371, 9, 70, "GuideText",
 CellID->8508662],
Cell[74801, 2463, 223, 6, 70, "GuideText",
 CellID->59951182],
Cell[75027, 2471, 377, 9, 70, "GuideText",
 CellID->328751855],
Cell[75407, 2482, 294, 9, 70, "GuideText",
 CellID->323190878],
Cell[75704, 2493, 356, 9, 70, "GuideText",
 CellID->103479464],
Cell[76063, 2504, 239, 6, 70, "GuideText",
 CellID->440565440],
Cell[76305, 2512, 278, 8, 70, "GuideText",
 CellID->369774987],
Cell[76586, 2522, 368, 9, 70, "GuideText",
 CellID->81224472]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77003, 2537, 78, 1, 70, "GuideFunctionsSection",
 CellID->73657636],
Cell[CellGroupData[{
Cell[77106, 2542, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->105463164],
Cell[77188, 2545, 111, 3, 70, "GuideText",
 CellID->151452997],
Cell[77302, 2550, 121, 3, 70, "GuideText",
 CellID->277930189],
Cell[77426, 2555, 83, 1, 70, "GuideText",
 CellID->71551041],
Cell[77512, 2558, 179, 6, 70, "GuideText",
 CellID->582962676],
Cell[77694, 2566, 208, 7, 70, "GuideText",
 CellID->541202364],
Cell[77905, 2575, 227, 6, 70, "GuideText",
 CellID->248785741],
Cell[78135, 2583, 321, 10, 70, "GuideText",
 CellID->24226781],
Cell[78459, 2595, 137, 4, 70, "GuideText",
 CellID->639685876],
Cell[78599, 2601, 110, 3, 70, "GuideText",
 CellID->512488667],
Cell[78712, 2606, 101, 2, 70, "GuideText",
 CellID->1250328],
Cell[78816, 2610, 79, 1, 70, "GuideText",
 CellID->123382678],
Cell[78898, 2613, 72, 1, 70, "GuideText",
 CellID->42335059],
Cell[78973, 2616, 89, 1, 70, "GuideText",
 CellID->89112715],
Cell[79065, 2619, 254, 6, 70, "GuideText",
 CellID->272536195],
Cell[79322, 2627, 224, 7, 70, "GuideText",
 CellID->235056529],
Cell[79549, 2636, 183, 6, 70, "GuideText",
 CellID->762000132],
Cell[79735, 2644, 221, 6, 70, "GuideText",
 CellID->32358871]
}, Open  ]],
Cell[CellGroupData[{
Cell[79993, 2655, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->270728077],
Cell[80084, 2658, 194, 6, 70, "GuideText",
 CellID->171340589],
Cell[80281, 2666, 351, 10, 70, "GuideText",
 CellID->342136247],
Cell[80635, 2678, 398, 9, 70, "GuideText",
 CellID->364562921],
Cell[81036, 2689, 367, 10, 70, "GuideText",
 CellID->700170952],
Cell[81406, 2701, 610, 17, 70, "GuideText",
 CellID->888569784],
Cell[82019, 2720, 317, 10, 70, "GuideText",
 CellID->123954345],
Cell[82339, 2732, 462, 14, 70, "GuideText",
 CellID->252192308],
Cell[82804, 2748, 217, 6, 70, "GuideText",
 CellID->1508295],
Cell[83024, 2756, 934, 24, 70, "GuideText",
 CellID->590425304],
Cell[83961, 2782, 375, 9, 70, "GuideText",
 CellID->157033653]
}, Open  ]],
Cell[CellGroupData[{
Cell[84373, 2796, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->132144035],
Cell[84457, 2799, 230, 7, 70, "GuideText",
 CellID->127040347],
Cell[84690, 2808, 664, 16, 70, "GuideText",
 CellID->6957074],
Cell[85357, 2826, 664, 16, 70, "GuideText",
 CellID->46115567]
}, Open  ]],
Cell[CellGroupData[{
Cell[86058, 2847, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->246298763],
Cell[86148, 2850, 356, 9, 70, "GuideText",
 CellID->622570022],
Cell[86507, 2861, 373, 10, 70, "GuideText",
 CellID->52062306],
Cell[86883, 2873, 1146, 30, 70, "GuideText",
 CellID->469185],
Cell[88032, 2905, 364, 9, 70, "GuideText",
 CellID->137627001],
Cell[88399, 2916, 350, 9, 70, "GuideText",
 CellID->61968087],
Cell[88752, 2927, 609, 16, 70, "GuideText",
 CellID->224168918],
Cell[89364, 2945, 644, 17, 70, "GuideText",
 CellID->139050807],
Cell[90011, 2964, 218, 7, 70, "GuideText",
 CellID->14741181],
Cell[90232, 2973, 427, 14, 70, "GuideText",
 CellID->34965461],
Cell[90662, 2989, 201, 6, 70, "GuideText",
 CellID->81860245],
Cell[90866, 2997, 904, 23, 70, "GuideText",
 CellID->226497237],
Cell[91773, 3022, 197, 6, 70, "GuideText",
 CellID->655763123],
Cell[91973, 3030, 615, 17, 70, "GuideText",
 CellID->44699382],
Cell[92591, 3049, 378, 9, 70, "GuideText",
 CellID->249918145]
}, Open  ]],
Cell[CellGroupData[{
Cell[93006, 3063, 91, 1, 70, "GuideFunctionsSubsection",
 CellID->15799570],
Cell[93100, 3066, 356, 10, 70, "GuideText",
 CellID->152085160],
Cell[93459, 3078, 162, 6, 70, "GuideText",
 CellID->23174920],
Cell[93624, 3086, 226, 7, 70, "GuideText",
 CellID->373009353],
Cell[93853, 3095, 249, 7, 70, "GuideText",
 CellID->68291596],
Cell[94105, 3104, 764, 20, 70, "GuideText",
 CellID->788194],
Cell[94872, 3126, 667, 16, 70, "GuideText",
 CellID->141360513]
}, Open  ]],
Cell[CellGroupData[{
Cell[95576, 3147, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->33214342],
Cell[95653, 3150, 357, 9, 70, "GuideText",
 CellID->79906587],
Cell[96013, 3161, 367, 9, 70, "GuideText",
 CellID->200822392],
Cell[96383, 3172, 638, 16, 70, "GuideText",
 CellID->594932],
Cell[97024, 3190, 367, 9, 70, "GuideText",
 CellID->120340216],
Cell[97394, 3201, 357, 9, 70, "GuideText",
 CellID->365899303]
}, Open  ]],
Cell[CellGroupData[{
Cell[97788, 3215, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->654866555],
Cell[97870, 3218, 195, 6, 70, "GuideText",
 CellID->78869555],
Cell[98068, 3226, 188, 6, 70, "GuideText",
 CellID->188495618],
Cell[98259, 3234, 205, 6, 70, "GuideText",
 CellID->601284221],
Cell[98467, 3242, 118, 3, 70, "GuideText",
 CellID->771314132],
Cell[98588, 3247, 114, 3, 70, "GuideText",
 CellID->912346555],
Cell[98705, 3252, 124, 3, 70, "GuideText",
 CellID->511746070],
Cell[98832, 3257, 98, 1, 70, "GuideText",
 CellID->214581301],
Cell[98933, 3260, 256, 7, 70, "GuideText",
 CellID->668031351],
Cell[99192, 3269, 199, 6, 70, "GuideText",
 CellID->592464239]
}, Open  ]],
Cell[CellGroupData[{
Cell[99428, 3280, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->518932592],
Cell[99503, 3283, 261, 8, 70, "GuideText",
 CellID->148498916],
Cell[99767, 3293, 262, 7, 70, "GuideText",
 CellID->348362369],
Cell[100032, 3302, 523, 13, 70, "GuideText",
 CellID->532795662],
Cell[100558, 3317, 380, 9, 70, "GuideText",
 CellID->646717645],
Cell[100941, 3328, 921, 24, 70, "GuideText",
 CellID->896990680],
Cell[101865, 3354, 896, 24, 70, "GuideText",
 CellID->42138103],
Cell[102764, 3380, 625, 17, 70, "GuideText",
 CellID->160353379],
Cell[103392, 3399, 386, 9, 70, "GuideText",
 CellID->384004708],
Cell[103781, 3410, 365, 9, 70, "GuideText",
 CellID->884658368],
Cell[104149, 3421, 391, 9, 70, "GuideText",
 CellID->2972130],
Cell[104543, 3432, 428, 11, 70, "GuideText",
 CellID->184016010],
Cell[104974, 3445, 368, 10, 70, "GuideText",
 CellID->485792834],
Cell[105345, 3457, 236, 7, 70, "GuideText",
 CellID->8068299],
Cell[105584, 3466, 374, 10, 70, "GuideText",
 CellID->679750428],
Cell[105961, 3478, 234, 7, 70, "GuideText",
 CellID->9409602],
Cell[106198, 3487, 909, 24, 70, "GuideText",
 CellID->825922866],
Cell[107110, 3513, 227, 7, 70, "GuideText",
 CellID->80412081],
Cell[107340, 3522, 378, 9, 70, "GuideText",
 CellID->673076272]
}, Open  ]],
Cell[CellGroupData[{
Cell[107755, 3536, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->90042433],
Cell[107829, 3539, 261, 7, 70, "GuideText",
 CellID->6602205],
Cell[108093, 3548, 383, 10, 70, "GuideText",
 CellID->998998886],
Cell[108479, 3560, 646, 16, 70, "GuideText",
 CellID->220261876],
Cell[109128, 3578, 400, 9, 70, "GuideText",
 CellID->252433801],
Cell[109531, 3589, 397, 10, 70, "GuideText",
 CellID->187416445],
Cell[109931, 3601, 357, 9, 70, "GuideText",
 CellID->465952739],
Cell[110291, 3612, 649, 17, 70, "GuideText",
 CellID->152784341],
Cell[110943, 3631, 401, 10, 70, "GuideText",
 CellID->821796109],
Cell[111347, 3643, 368, 10, 70, "GuideText",
 CellID->493876181]
}, Open  ]],
Cell[CellGroupData[{
Cell[111752, 3658, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->356368376],
Cell[111832, 3661, 385, 9, 70, "GuideText",
 CellID->51031240],
Cell[112220, 3672, 638, 16, 70, "GuideText",
 CellID->68886085],
Cell[112861, 3690, 733, 19, 70, "GuideText",
 CellID->109785224],
Cell[113597, 3711, 191, 6, 70, "GuideText",
 CellID->477724529]
}, Open  ]],
Cell[CellGroupData[{
Cell[113825, 3722, 61, 1, 70, "GuideFunctionsSubsection",
 CellID->147899263],
Cell[113889, 3725, 201, 6, 70, "GuideText",
 CellID->11296780],
Cell[114093, 3733, 170, 6, 70, "GuideText",
 CellID->48482761],
Cell[114266, 3741, 199, 6, 70, "GuideText",
 CellID->36626700],
Cell[114468, 3749, 190, 6, 70, "GuideText",
 CellID->724765684],
Cell[114661, 3757, 181, 6, 70, "GuideText",
 CellID->241022356],
Cell[114845, 3765, 199, 6, 70, "GuideText",
 CellID->901630168],
Cell[115047, 3773, 393, 12, 70, "GuideText",
 CellID->890653091],
Cell[115443, 3787, 199, 6, 70, "GuideText",
 CellID->107803054]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115691, 3799, 81, 1, 70, "GuideFunctionsSection",
 CellID->139337527],
Cell[CellGroupData[{
Cell[115797, 3804, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->421408595],
Cell[115889, 3807, 1008, 26, 70, "GuideText",
 CellID->590867822],
Cell[116900, 3835, 656, 16, 70, "GuideText",
 CellID->25033031],
Cell[117559, 3853, 229, 6, 70, "GuideText",
 CellID->16081595],
Cell[117791, 3861, 341, 10, 70, "GuideText",
 CellID->154277387],
Cell[118135, 3873, 868, 23, 70, "GuideText",
 CellID->507439478],
Cell[119006, 3898, 182, 6, 70, "GuideText",
 CellID->160195217],
Cell[119191, 3906, 370, 9, 70, "GuideText",
 CellID->38728974],
Cell[119564, 3917, 395, 9, 70, "GuideText",
 CellID->123042678],
Cell[119962, 3928, 367, 9, 70, "GuideText",
 CellID->10228906]
}, Open  ]],
Cell[CellGroupData[{
Cell[120366, 3942, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->881370858],
Cell[120440, 3945, 320, 11, 70, "GuideText",
 CellID->63029493],
Cell[120763, 3958, 128, 4, 70, "GuideText",
 CellID->5860726],
Cell[120894, 3964, 194, 6, 70, "GuideText",
 CellID->36932718],
Cell[121091, 3972, 134, 4, 70, "GuideText",
 CellID->215577464],
Cell[121228, 3978, 76, 1, 70, "GuideText",
 CellID->201829078],
Cell[121307, 3981, 711, 30, 70, "GuideText",
 CellID->47729570],
Cell[122021, 4013, 514, 23, 70, "GuideText",
 CellID->240230487],
Cell[122538, 4038, 261, 11, 70, "GuideText",
 CellID->875067492],
Cell[122802, 4051, 221, 6, 70, "GuideText",
 CellID->34411873],
Cell[123026, 4059, 549, 23, 70, "GuideText",
 CellID->1033514650],
Cell[123578, 4084, 363, 15, 70, "GuideText",
 CellID->607542955],
Cell[123944, 4101, 170, 7, 70, "GuideText",
 CellID->57011457],
Cell[124117, 4110, 623, 27, 70, "GuideText",
 CellID->221940427],
Cell[124743, 4139, 83, 1, 70, "GuideText",
 CellID->632873417],
Cell[124829, 4142, 530, 23, 70, "GuideText",
 CellID->138199810],
Cell[125362, 4167, 272, 11, 70, "GuideText",
 CellID->264722399],
Cell[125637, 4180, 435, 19, 70, "GuideText",
 CellID->126252528],
Cell[126075, 4201, 517, 21, 70, "GuideText",
 CellID->368280513],
Cell[126595, 4224, 543, 23, 70, "GuideText",
 CellID->228682815],
Cell[127141, 4249, 553, 23, 70, "GuideText",
 CellID->309993372],
Cell[127697, 4274, 90, 1, 70, "GuideText",
 CellID->175586476],
Cell[127790, 4277, 628, 26, 70, "GuideText",
 CellID->313072397]
}, Open  ]],
Cell[CellGroupData[{
Cell[128455, 4308, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->753487641],
Cell[128540, 4311, 718, 19, 70, "GuideText",
 CellID->113219964],
Cell[129261, 4332, 944, 27, 70, "GuideText",
 CellID->96762233],
Cell[130208, 4361, 643, 16, 70, "GuideText",
 CellID->46628023],
Cell[130854, 4379, 352, 9, 70, "GuideText",
 CellID->215646713],
Cell[131209, 4390, 365, 10, 70, "GuideText",
 CellID->24207372],
Cell[131577, 4402, 509, 13, 70, "GuideText",
 CellID->74421183],
Cell[132089, 4417, 362, 10, 70, "GuideText",
 CellID->60794357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[132500, 4433, 76, 1, 70, "GuideFunctionsSection",
 CellID->210781766],
Cell[CellGroupData[{
Cell[132601, 4438, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->191238998],
Cell[132686, 4441, 129, 4, 70, "GuideText",
 CellID->65211010],
Cell[132818, 4447, 313, 10, 70, "GuideText",
 CellID->15621853],
Cell[133134, 4459, 79, 1, 70, "GuideText",
 CellID->33397827],
Cell[133216, 4462, 78, 1, 70, "GuideText",
 CellID->262024968],
Cell[133297, 4465, 88, 1, 70, "GuideText",
 CellID->245528514],
Cell[133388, 4468, 69, 1, 70, "GuideText",
 CellID->368488996],
Cell[133460, 4471, 98, 1, 70, "GuideText",
 CellID->409322887],
Cell[133561, 4474, 204, 6, 70, "GuideText",
 CellID->2943607],
Cell[133768, 4482, 228, 6, 70, "GuideText",
 CellID->183817266],
Cell[133999, 4490, 189, 6, 70, "GuideText",
 CellID->881027685]
}, Open  ]],
Cell[CellGroupData[{
Cell[134225, 4501, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->360422416],
Cell[134315, 4504, 91, 1, 70, "GuideText",
 CellID->151117327],
Cell[134409, 4507, 192, 6, 70, "GuideText",
 CellID->61068910],
Cell[134604, 4515, 87, 1, 70, "GuideText",
 CellID->439593527],
Cell[134694, 4518, 200, 6, 70, "GuideText",
 CellID->83699528],
Cell[134897, 4526, 70, 1, 70, "GuideText",
 CellID->36777925],
Cell[134970, 4529, 196, 6, 70, "GuideText",
 CellID->77319888],
Cell[135169, 4537, 170, 6, 70, "GuideText",
 CellID->430114374],
Cell[135342, 4545, 183, 6, 70, "GuideText",
 CellID->250328602]
}, Open  ]],
Cell[CellGroupData[{
Cell[135562, 4556, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->14048357],
Cell[135634, 4559, 102, 2, 70, "GuideText",
 CellID->83214551],
Cell[135739, 4563, 98, 1, 70, "GuideText",
 CellID->242019669],
Cell[135840, 4566, 91, 1, 70, "GuideText",
 CellID->122219523],
Cell[135934, 4569, 86, 1, 70, "GuideText",
 CellID->40619672],
Cell[136023, 4572, 76, 1, 70, "GuideText",
 CellID->54817579],
Cell[136102, 4575, 173, 6, 70, "GuideText",
 CellID->135087927],
Cell[136278, 4583, 92, 1, 70, "GuideText",
 CellID->108251802],
Cell[136373, 4586, 205, 6, 70, "GuideText",
 CellID->235550655],
Cell[136581, 4594, 522, 17, 70, "GuideText",
 CellID->1130919488],
Cell[137106, 4613, 90, 1, 70, "GuideText",
 CellID->192896123],
Cell[137199, 4616, 261, 10, 70, "GuideText",
 CellID->178090585]
}, Open  ]],
Cell[CellGroupData[{
Cell[137497, 4631, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->300531919],
Cell[137576, 4634, 370, 10, 70, "GuideText",
 CellID->336762732],
Cell[137949, 4646, 110, 3, 70, "GuideText",
 CellID->540170135],
Cell[138062, 4651, 78, 1, 70, "GuideText",
 CellID->43003340],
Cell[138143, 4654, 191, 6, 70, "GuideText",
 CellID->1002460597],
Cell[138337, 4662, 891, 24, 70, "GuideText",
 CellID->427532127],
Cell[139231, 4688, 179, 6, 70, "GuideText",
 CellID->77930559],
Cell[139413, 4696, 617, 17, 70, "GuideText",
 CellID->57230158],
Cell[140033, 4715, 968, 26, 70, "GuideText",
 CellID->478329029],
Cell[141004, 4743, 228, 6, 70, "GuideText",
 CellID->320302670],
Cell[141235, 4751, 355, 9, 70, "GuideText",
 CellID->638273576],
Cell[141593, 4762, 616, 16, 70, "GuideText",
 CellID->23800257]
}, Open  ]],
Cell[CellGroupData[{
Cell[142246, 4783, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->182908213],
Cell[142326, 4786, 95, 1, 70, "GuideText",
 CellID->845729164],
Cell[142424, 4789, 167, 6, 70, "GuideText",
 CellID->435835457],
Cell[142594, 4797, 202, 6, 70, "GuideText",
 CellID->105247343],
Cell[142799, 4805, 368, 9, 70, "GuideText",
 CellID->78373458],
Cell[143170, 4816, 387, 9, 70, "GuideText",
 CellID->202048423],
Cell[143560, 4827, 181, 6, 70, "GuideText",
 CellID->65631164]
}, Open  ]],
Cell[CellGroupData[{
Cell[143778, 4838, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->203864978],
Cell[143855, 4841, 188, 6, 70, "GuideText",
 CellID->8251307],
Cell[144046, 4849, 623, 16, 70, "GuideText",
 CellID->147055662],
Cell[144672, 4867, 204, 6, 70, "GuideText",
 CellID->61351082],
Cell[144879, 4875, 210, 6, 70, "GuideText",
 CellID->480991479],
Cell[145092, 4883, 191, 6, 70, "GuideText",
 CellID->367256643]
}, Open  ]],
Cell[CellGroupData[{
Cell[145320, 4894, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->587756692],
Cell[145395, 4897, 327, 11, 70, "GuideText",
 CellID->182711109],
Cell[145725, 4910, 116, 3, 70, "GuideText",
 CellID->432469465],
Cell[145844, 4915, 606, 19, 70, "GuideText",
 CellID->231885768],
Cell[146453, 4936, 245, 7, 70, "GuideText",
 CellID->516412911],
Cell[146701, 4945, 560, 22, 70, "GuideText",
 CellID->146270953],
Cell[147264, 4969, 169, 6, 70, "GuideText",
 CellID->38549300],
Cell[147436, 4977, 96, 1, 70, "GuideText",
 CellID->327809182]
}, Open  ]],
Cell[CellGroupData[{
Cell[147569, 4983, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->600170837],
Cell[147648, 4986, 383, 9, 70, "GuideText",
 CellID->58597201],
Cell[148034, 4997, 374, 9, 70, "GuideText",
 CellID->127546792],
Cell[148411, 5008, 656, 16, 70, "GuideText",
 CellID->261593123],
Cell[149070, 5026, 203, 6, 70, "GuideText",
 CellID->202529566],
Cell[149276, 5034, 366, 9, 70, "GuideText",
 CellID->594979699],
Cell[149645, 5045, 365, 9, 70, "GuideText",
 CellID->337197047],
Cell[150013, 5056, 373, 9, 70, "GuideText",
 CellID->82412461]
}, Open  ]],
Cell[CellGroupData[{
Cell[150423, 5070, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->19673033],
Cell[150502, 5073, 84, 1, 70, "GuideText",
 CellID->54856008],
Cell[150589, 5076, 84, 1, 70, "GuideText",
 CellID->755623741],
Cell[150676, 5079, 85, 1, 70, "GuideText",
 CellID->575828348],
Cell[150764, 5082, 213, 8, 70, "GuideText",
 CellID->305990220],
Cell[150980, 5092, 223, 8, 70, "GuideText",
 CellID->563300997],
Cell[151206, 5102, 93, 1, 70, "GuideText",
 CellID->188522855]
}, Open  ]],
Cell[CellGroupData[{
Cell[151336, 5108, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->142985810],
Cell[151421, 5111, 67, 1, 70, "GuideText",
 CellID->803623653],
Cell[151491, 5114, 85, 1, 70, "GuideText",
 CellID->186169413],
Cell[151579, 5117, 83, 1, 70, "GuideText",
 CellID->640692232],
Cell[151665, 5120, 90, 1, 70, "GuideText",
 CellID->32878720],
Cell[151758, 5123, 290, 9, 70, "GuideText",
 CellID->36541574],
Cell[152051, 5134, 99, 1, 70, "GuideText",
 CellID->366317934]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152199, 5141, 84, 1, 70, "GuideFunctionsSection",
 CellID->408798641],
Cell[CellGroupData[{
Cell[152308, 5146, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->82968555],
Cell[152377, 5149, 120, 3, 70, "GuideText",
 CellID->283060494],
Cell[152500, 5154, 398, 9, 70, "GuideText",
 CellID->16761672],
Cell[152901, 5165, 395, 9, 70, "GuideText",
 CellID->32766997],
Cell[153299, 5176, 238, 6, 70, "GuideText",
 CellID->199500227],
Cell[153540, 5184, 659, 16, 70, "GuideText",
 CellID->121106049],
Cell[154202, 5202, 225, 6, 70, "GuideText",
 CellID->5530752],
Cell[154430, 5210, 211, 6, 70, "GuideText",
 CellID->69139084],
Cell[154644, 5218, 198, 6, 70, "GuideText",
 CellID->53994365]
}, Open  ]],
Cell[CellGroupData[{
Cell[154879, 5229, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->130006915],
Cell[154962, 5232, 123, 3, 70, "GuideText",
 CellID->435064386],
Cell[155088, 5237, 177, 6, 70, "GuideText",
 CellID->504171564],
Cell[155268, 5245, 69, 1, 70, "GuideText",
 CellID->22519836],
Cell[155340, 5248, 344, 9, 70, "GuideText",
 CellID->252603948],
Cell[155687, 5259, 366, 10, 70, "GuideText",
 CellID->834735170],
Cell[156056, 5271, 373, 9, 70, "GuideText",
 CellID->67645730]
}, Open  ]],
Cell[CellGroupData[{
Cell[156466, 5285, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->316621919],
Cell[156550, 5288, 158, 6, 70, "GuideText",
 CellID->462621252],
Cell[156711, 5296, 165, 6, 70, "GuideText",
 CellID->33725922],
Cell[156879, 5304, 149, 6, 70, "GuideText",
 CellID->52461951],
Cell[157031, 5312, 146, 6, 70, "GuideText",
 CellID->171765573]
}, Open  ]],
Cell[CellGroupData[{
Cell[157214, 5323, 60, 1, 70, "GuideFunctionsSubsection",
 CellID->918202346],
Cell[157277, 5326, 219, 9, 70, "GuideText",
 CellID->285451918],
Cell[157499, 5337, 191, 6, 70, "GuideText",
 CellID->3248492]
}, Open  ]],
Cell[CellGroupData[{
Cell[157727, 5348, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->52094258],
Cell[157804, 5351, 197, 6, 70, "GuideText",
 CellID->58662365],
Cell[158004, 5359, 359, 9, 70, "GuideText",
 CellID->109901704],
Cell[158366, 5370, 205, 6, 70, "GuideText",
 CellID->524010285]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158620, 5382, 73, 1, 70, "GuideFunctionsSection",
 CellID->31225209],
Cell[158696, 5385, 102, 2, 70, "GuideText",
 CellID->148236057],
Cell[158801, 5389, 112, 3, 70, "GuideText",
 CellID->900925586],
Cell[158916, 5394, 149, 6, 70, "GuideText",
 CellID->142270156],
Cell[159068, 5402, 161, 6, 70, "GuideText",
 CellID->747779891],
Cell[159232, 5410, 97, 1, 70, "GuideText",
 CellID->195787573],
Cell[159332, 5413, 93, 1, 70, "GuideText",
 CellID->48488680],
Cell[159428, 5416, 102, 2, 70, "GuideText",
 CellID->31865668],
Cell[159533, 5420, 95, 1, 70, "GuideText",
 CellID->250547780],
Cell[159631, 5423, 155, 6, 70, "GuideText",
 CellID->36931372],
Cell[159789, 5431, 103, 2, 70, "GuideText",
 CellID->104060192],
Cell[159895, 5435, 163, 6, 70, "GuideText",
 CellID->434874434]
}, Open  ]],
Cell[CellGroupData[{
Cell[160095, 5446, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[160160, 5449, 176, 4, 70, "GuideMoreAboutSub",
 CellID->582854384]
}, Open  ]],
Cell[160351, 5456, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

