(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13019,        453]
NotebookOptionsPosition[      8288,        330]
NotebookOutlinePosition[     11025,        384]
CellTagsIndexPosition[     10982,        381]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Tensors", "GuideTitle",
 CellID->13079],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s uniform representation of vectors and matrices as lists automatically \
extends to tensors of any rank, allowing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful list manipulation functions immediately to be applied to \
tensors, both numerical and symbolic. "
}], "GuideAbstract",
 CellID->81926457],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a tensor of any rank from an expression"
}], "GuideText",
 CellID->22197],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " construct a tensor from a function: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->13509],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify a tensor in a sparse ",
 Cell[BoxData[
  RowBox[{
   StyleBox["position", "TI"], "\[LongRightArrow]", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " form"
}], "GuideText",
 CellID->6265013],

Cell["\t", "GuideDelimiter",
 CellID->8652],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dimensions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dimensions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the dimensions of a tensor"
}], "GuideText",
 CellID->71],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayDepth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayDepth"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the rank of a tensor"
}], "GuideText",
 CellID->658],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an object is a tensor of a given rank"
}], "GuideText",
 CellID->14122],

Cell["\t", "GuideDelimiter",
 CellID->26859],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a tensor of any rank"
}], "GuideText",
 CellID->7997],

Cell["\t", "GuideDelimiter",
 CellID->10999],

Cell[TextData[{
 Cell[TextData[ButtonBox["KroneckerDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "identity tensor"
}], "GuideText",
 CellID->1899],

Cell[TextData[{
 Cell[TextData[ButtonBox["Signature",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Signature"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "totally antisymmetric tensor"
}], "GuideText",
 CellID->4120],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify banded structure in a sparse array"
}], "GuideText",
 CellID->146685039],

Cell["\t", "GuideDelimiter",
 CellID->1320],

Cell[TextData[{
 Cell[TextData[ButtonBox["Transpose",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Transpose"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transpose to rearrange indices in any way"
}], "GuideText",
 CellID->32036],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " dot product"
}], "GuideText",
 CellID->16984],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inner",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inner"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generalized inner product"
}], "GuideText",
 CellID->4912],

Cell[TextData[{
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generalized outer product"
}], "GuideText",
 CellID->1915],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tr",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tr"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generalized trace"
}], "GuideText",
 CellID->23953],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten out any sequence of levels"
}], "GuideText",
 CellID->675189],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PadLeft",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PadRight",
  BaseStyle->{"Link"}]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->214300626]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->19485],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "GuideTutorial",
 CellID->20741],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->10199]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->11567],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->4208]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->119487297],

Cell[TextData[{
 ButtonBox["Demonstrations related to Tensors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22linear+algebra%22+content%3AArray+OR+ArrayDepth+OR+ArrayFlatten+OR+ArrayQ+\
OR+Band+OR+Dimensions+OR+Dot+OR+Flatten+OR+Inner+OR+KroneckerDelta+OR+\
MatrixForm+OR+Outer+OR+Signature+OR+SparseArray+OR+Table+OR+Tr+OR+Transpose"],
     None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->217304272]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tensors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 26.3318860}", "context" -> "", 
    "keywords" -> {
     "antisymmetry", "array depth", "array dimensions", "array flatten", 
      "array shape", "array size", "arrays", "band-diagonal matrices", 
      "Beck parameters", "blocking lists", "blocks", "Cartesian products", 
      "circular partitioning", "collapse", "contraction of tensors", 
      "cyclic partitioning", "diagonal", "diagonal of matrix", 
      "direct products", "direct products of tensors", "dithering", 
      "divergence operator", "dot product", "dyadic products", 
      "Einstein rule", "Einstein summation", "EinsteinG", "epsilon symbol", 
      "exterior products", "flat list", "flatten matrix", 
      "format of matrices", "formatting of arrays", "formatting of tensors", 
      "Frobenius norm", "full arrays", "general relativity", 
      "generalized inner products", "hashing", "inner product", 
      "inner products", "join block matrices", "join lists", 
      "Kronecker delta", "Kronecker products of tensors", 
      "Levi-Civita symbol", "lists", "matrices", "matrices of matrices", 
      "matrix dimensions", "matrix form", "matrix multiplication", 
      "matrix multiply", "matrix transpose", "matrix vector multiplication", 
      "multiplication", "one-dimensional list", "outer products", 
      "permutation of indices", "pseudotensors", "scalar product", 
      "signature", "sparse array", "sparse matrix", "sparse representation", 
      "sparse vector", "spur of matrix", "squash", "tensor products", 
      "tensors", "trace of matrix", "transpose of matrices", 
      "transposition of lists", "vectors", "wedge product"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's uniform representation of vectors and matrices as lists \
automatically extends to tensors of any rank, allowing Mathematica's powerful \
list manipulation functions immediately to be applied to tensors, both \
numerical and symbolic. ", "synonyms" -> {}, "title" -> "Tensors", "type" -> 
    "Guide", "uri" -> "guide/Tensors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 45, 1, 70, "GuideTitle",
 CellID->13079],
Cell[667, 28, 387, 10, 70, "GuideAbstract",
 CellID->81926457],
Cell[1057, 40, 268, 9, 70, "GuideText",
 CellID->22197],
Cell[1328, 51, 463, 16, 70, "GuideText",
 CellID->13509],
Cell[1794, 69, 395, 13, 70, "GuideText",
 CellID->6265013],
Cell[2192, 84, 43, 1, 70, "GuideDelimiter",
 CellID->8652],
Cell[2238, 87, 252, 9, 70, "GuideText",
 CellID->71],
Cell[2493, 98, 247, 9, 70, "GuideText",
 CellID->658],
Cell[2743, 109, 271, 9, 70, "GuideText",
 CellID->14122],
Cell[3017, 120, 44, 1, 70, "GuideDelimiter",
 CellID->26859],
Cell[3064, 123, 256, 9, 70, "GuideText",
 CellID->7997],
Cell[3323, 134, 44, 1, 70, "GuideDelimiter",
 CellID->10999],
Cell[3370, 137, 251, 9, 70, "GuideText",
 CellID->1899],
Cell[3624, 148, 254, 9, 70, "GuideText",
 CellID->4120],
Cell[3881, 159, 408, 12, 70, "GuideText",
 CellID->146685039],
Cell[4292, 173, 43, 1, 70, "GuideDelimiter",
 CellID->1320],
Cell[4338, 176, 268, 9, 70, "GuideText",
 CellID->32036],
Cell[4609, 187, 342, 13, 70, "GuideText",
 CellID->16984],
Cell[4954, 202, 243, 9, 70, "GuideText",
 CellID->4912],
Cell[5200, 213, 243, 9, 70, "GuideText",
 CellID->1915],
Cell[5446, 224, 230, 9, 70, "GuideText",
 CellID->23953],
Cell[5679, 235, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[5730, 238, 258, 9, 70, "GuideText",
 CellID->675189],
Cell[5991, 249, 860, 23, 70, "InlineGuideFunctionListing",
 CellID->214300626]
}, Open  ]],
Cell[CellGroupData[{
Cell[6888, 277, 58, 1, 70, "GuideTutorialsSection",
 CellID->19485],
Cell[6949, 280, 129, 3, 70, "GuideTutorial",
 CellID->20741],
Cell[7081, 285, 153, 3, 70, "GuideTutorial",
 CellID->10199]
}, Open  ]],
Cell[CellGroupData[{
Cell[7271, 293, 59, 1, 70, "GuideMoreAboutSection",
 CellID->11567],
Cell[7333, 296, 145, 3, 70, "GuideMoreAbout",
 CellID->4208]
}, Open  ]],
Cell[CellGroupData[{
Cell[7515, 304, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->119487297],
Cell[7587, 307, 659, 18, 70, "GuideRelatedLinks",
 CellID->217304272]
}, Open  ]],
Cell[8261, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

