(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13354,        438]
NotebookOptionsPosition[      8804,        319]
NotebookOutlinePosition[     11293,        369]
CellTagsIndexPosition[     11250,        366]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Time Measurement & Optimization", "GuideTitle",
 CellID->25633],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic timing framework allows timing information not only to be \
analyzed but also to be used in the structure of algorithms. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides functions to allow programmers to take advantage of the same \
kinds of powerful optimizations as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s carefully tuned internal code."
}], "GuideAbstract",
 CellID->180678284],

Cell[TextData[{
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "run a command for at most a specified time"
}], "GuideText",
 CellID->20279],

Cell["\t", "GuideDelimiter",
 CellID->12488],

Cell[TextData[{
 Cell[TextData[ButtonBox["Timing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Timing"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "CPU time to run a command within the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel"
}], "GuideText",
 CellID->24870],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsoluteTiming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total wall-clock time to run a command"
}], "GuideText",
 CellID->31754],

Cell[TextData[{
 Cell[TextData[ButtonBox["TimeUsed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeUsed"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SessionTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SessionTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$TimeUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$TimeUnit"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26072],

Cell["\t", "GuideDelimiterSubsection",
 CellID->32176],

Cell[CellGroupData[{

Cell["Time Optimizations", "GuideFunctionsSubsection",
 CellID->26701],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "use approximate rather than exact numbers"
}], "GuideText",
 CellID->15415],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compile"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compile a numeric function"
}], "GuideText",
 CellID->18086],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dispatch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dispatch"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "preprocess large lists of rules"
}], "GuideText",
 CellID->4231],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a numeric hash code for any expression"
}], "GuideText",
 CellID->15792537],

Cell[TextData[{
 Cell[TextData[ButtonBox["DumpSave",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DumpSave"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "save data in .mx native ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format"
}], "GuideText",
 CellID->17480],

Cell[TextData[{
 Cell[TextData[ButtonBox["$IterationLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$IterationLimit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WorkingPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PerformanceGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Method",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Method"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19975]
}, Open  ]],

Cell[CellGroupData[{

Cell["Low-Level Functions", "GuideFunctionsSubsection",
 CellID->29006716],

Cell[TextData[{
 Cell[TextData[ButtonBox["Refresh",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Refresh"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClearSystemCache",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClearSystemCache"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->53165870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->30260],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "GuideTutorial",
 CellID->47873671],

Cell[TextData[{
 ButtonBox["Compiling ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"]
}], "GuideTutorial",
 CellID->154947307],

Cell[TextData[ButtonBox["Manipulating Sets of Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSetsOfTransformationRules"]], "GuideTutorial",
 CellID->45236772],

Cell[TextData[ButtonBox["Controlling Infinite Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ControllingInfiniteEvaluation"]], "GuideTutorial",
 CellID->130958292],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "GuideTutorial",
 CellID->79291720]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->16657],

Cell[TextData[ButtonBox["Time & Date Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "GuideMoreAbout",
 CellID->14990],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MemoryMeasurementAndOptimization"]], "GuideMoreAboutSub",
 CellID->15447],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "GuideMoreAbout",
 CellID->105300894]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->276031911],

Cell[TextData[{
 ButtonBox["Wolfram ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wolfram.com/products/workbench/"], None}],
 StyleBox[ButtonBox["Workbench",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wolfram.com/products/workbench/"], None}],
  FontSlant->"Italic"]
}], "GuideRelatedLinks",
 CellID->1633676869]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Time Measurement & Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 29.3788390}", "context" -> "", 
    "keywords" -> {
     "absolute time", "absolute timing", "accuracy in timing", 
      "approximations", "beat", "benchmark", "binary save", 
      "clear system cache", "clicks", "compilation", "computer time", 
      "CPU time", "data integrity", "dump save", "efficiency", "elapsed time",
       "evaluation chain", "evaluation with time constraints", 
      "execution time", "FASL files", "granularity of time measurement", 
      "iteration limit", "measure of speed", "measurement of efficiency", 
      "NTP", "objective goal", "observer", "optimization for accuracy", 
      "optimization for speed", "optimization goal", "optimize", 
      "performance analysis", "performance goal", "process time", "profiling",
       "quality goal", "quality target", "quantization of time measurement", 
      "real-time clock", "run-time", "session time", "speed", 
      "speed accuracy objective", "speed accuracy trade-off", "standard time",
       "stopping iteration", "system options", "system time", "tick", 
      "time constrained", "time constraints", "time unit", "time used", 
      "timestamp", "update dynamically", "update value", "wall clock time", 
      "watch changes", "working precision"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's symbolic timing framework allows timing information not \
only to be analyzed but also to be used in the structure of algorithms. \
Mathematica provides functions to allow programmers to take advantage of the \
same kinds of powerful optimizations as Mathematica's carefully tuned \
internal code.", "synonyms" -> {}, "title" -> 
    "Time Measurement & Optimization", "type" -> "Guide", "uri" -> 
    "guide/TimeMeasurementAndOptimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->25633],
Cell[691, 28, 491, 13, 70, "GuideAbstract",
 CellID->180678284],
Cell[1185, 43, 281, 9, 70, "GuideText",
 CellID->20279],
Cell[1469, 54, 44, 1, 70, "GuideDelimiter",
 CellID->12488],
Cell[1516, 57, 319, 12, 70, "GuideText",
 CellID->24870],
Cell[1838, 71, 275, 9, 70, "GuideText",
 CellID->31754],
Cell[2116, 82, 824, 23, 70, "InlineGuideFunctionListing",
 CellID->26072],
Cell[2943, 107, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->32176],
Cell[CellGroupData[{
Cell[3022, 112, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->26701],
Cell[3095, 115, 252, 9, 70, "GuideText",
 CellID->15415],
Cell[3350, 126, 249, 9, 70, "GuideText",
 CellID->18086],
Cell[3602, 137, 255, 9, 70, "GuideText",
 CellID->4231],
Cell[3860, 148, 263, 9, 70, "GuideText",
 CellID->15792537],
Cell[4126, 159, 310, 12, 70, "GuideText",
 CellID->17480],
Cell[4439, 173, 848, 23, 70, "InlineGuideFunctionListing",
 CellID->19975]
}, Open  ]],
Cell[CellGroupData[{
Cell[5324, 201, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->29006716],
Cell[5401, 204, 1062, 26, 70, "InlineGuideFunctionListing",
 CellID->53165870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6512, 236, 58, 1, 70, "GuideTutorialsSection",
 CellID->30260],
Cell[6573, 239, 161, 3, 70, "GuideTutorial",
 CellID->47873671],
Cell[6737, 244, 427, 12, 70, "GuideTutorial",
 CellID->154947307],
Cell[7167, 258, 199, 4, 70, "GuideTutorial",
 CellID->45236772],
Cell[7369, 264, 182, 4, 70, "GuideTutorial",
 CellID->130958292],
Cell[7554, 270, 151, 3, 70, "GuideTutorial",
 CellID->79291720]
}, Open  ]],
Cell[CellGroupData[{
Cell[7742, 278, 59, 1, 70, "GuideMoreAboutSection",
 CellID->16657],
Cell[7804, 281, 145, 3, 70, "GuideMoreAbout",
 CellID->14990],
Cell[7952, 286, 184, 4, 70, "GuideMoreAboutSub",
 CellID->15447],
Cell[8139, 292, 172, 3, 70, "GuideMoreAbout",
 CellID->105300894]
}, Open  ]],
Cell[CellGroupData[{
Cell[8348, 300, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->276031911],
Cell[8420, 303, 342, 11, 70, "GuideRelatedLinks",
 CellID->1633676869]
}, Open  ]],
Cell[8777, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

