(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26798,        850]
NotebookOptionsPosition[     18724,        646]
NotebookOutlinePosition[     22769,        719]
CellTagsIndexPosition[     22726,        716]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Tuning & Debugging", "GuideTitle",
 CellID->20337],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s highly optimized architecture makes it easy to create programs that are \
both elegant and efficient",
 ". ",
 "Its symbolic character lets you immediately run and test even the smallest \
program fragments. And it provides full-scale software engineering support, \
from arbitrarily detailed compilation control, to novel high-level symbolic \
analysis."
}], "GuideAbstract",
 CellID->300342354],

Cell[TextData[{
 Cell[TextData[ButtonBox["Monitor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Monitor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "dynamically monitor values during a computation"
}], "GuideText",
 CellID->4858],

Cell[TextData[{
 Cell[TextData[ButtonBox["StepMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StepMonitor"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["EvaluationMonitor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "monitor built-in algorithms"
}], "GuideText",
 CellID->22512],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sow",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sow"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Reap",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "accumulate lists of values from within a computation"
}], "GuideText",
 CellID->29656],

Cell["\t", "GuideDelimiter",
 CellID->3318],

Cell[TextData[{
 Cell[TextData[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Print"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "print any expression or graphic"
}], "GuideText",
 CellID->13201],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrintTemporary",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PrintTemporary"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "print temporary output, cleaning up at the end of a computation"
}], "GuideText",
 CellID->142],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dialog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dialog"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enter a subsession at any stage in a computation"
}], "GuideText",
 CellID->160292373],

Cell["\t", "GuideDelimiter",
 CellID->21276],

Cell[TextData[{
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Debugger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Debugger"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " start interactive debugger"
}], "GuideText",
 CellID->31506],

Cell["\t", "GuideDelimiterSubsection",
 CellID->716684181],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Execution Tracing \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SymbolicExecutionHistory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->32702],

Cell[TextData[{
 Cell[TextData[ButtonBox["Trace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Trace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TracePrint",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TracePrint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stack",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Stack"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolicExecutionHistory"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Messages \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Messages"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->188173209],

Cell[TextData[{
 Cell[TextData[ButtonBox["On",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/On"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Message",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Message"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Check",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Check"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quiet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Quiet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Messages"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->187834434],

Cell["\t", "GuideDelimiterSubsection",
 CellID->15023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Time \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TimeMeasurementAndOptimization"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->30270],

Cell[TextData[{
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "constrain CPU time for a computation"
}], "GuideText",
 CellID->26312],

Cell[TextData[{
 Cell[TextData[ButtonBox["Timing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Timing"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["AbsoluteTiming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "CPU and absolute timing"
}], "GuideText",
 CellID->8250],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Compile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dispatch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dispatch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DumpSave",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DumpSave"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->13475],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Memory \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MemoryMeasurementAndOptimization"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->26850],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clear values"
}], "GuideText",
 CellID->19195],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "constrain memory usage in a computation"
}], "GuideText",
 CellID->5488],

Cell[TextData[{
 Cell[TextData[ButtonBox["ByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ByteCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemoryInUse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryInUse"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Share",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Share"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Short",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Short"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Compress",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Compress"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$HistoryLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$HistoryLength"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11520],

Cell["\t", "GuideDelimiterSubsection",
 CellID->26101]
}, Open  ]],

Cell[CellGroupData[{

Cell["Program Tuning", "GuideFunctionsSubsection",
 CellID->130584045],

Cell[TextData[{
 Cell[TextData[ButtonBox["Method",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Method"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify particular methods for algorithmic functions to use"
}], "GuideText",
 CellID->370990442],

Cell[TextData[{
 Cell[TextData[ButtonBox["PerformanceGoal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify whether to optimize for quality, speed, etc."
}], "GuideText",
 CellID->25432229],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExampleData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExampleData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "data for test examples"
}], "GuideText",
 CellID->186727832]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic Interactivity Tuning", "GuideFunctionsSubsection",
 CellID->218488162],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrackedSymbols",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SynchronousUpdating",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SynchronousUpdating"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UpdateInterval",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/UpdateInterval"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->110862988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Low-Level System Optimization \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelSystemOptimization"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->2687229],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemOptions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemOptions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClearSystemCache",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClearSystemCache"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SystemInformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemInformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelSystemOptimization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->134019594],

Cell["\t", "GuideDelimiter",
 CellID->234979328],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "lay out a symbolic call graph"
}], "GuideText",
 CellID->87593163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbol Namespace \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SymbolHandling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->20183],

Cell[TextData[{
 Cell[TextData[ButtonBox["Names",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Names"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Remove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Remove"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unique",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unique"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolHandling"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24798]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->6784],

Cell[TextData[ButtonBox["Monitoring and Selecting Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MonitoringAndSelectingAlgorithms"]], "GuideTutorial",
 CellID->502798481],

Cell[TextData[ButtonBox["Collecting Expressions During Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CollectingExpressionsDuringEvaluation"]], "GuideTutorial",
 CellID->295870457],

Cell[TextData[ButtonBox["Dialogs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Dialogs"]], "GuideTutorial",
 CellID->28065665],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "GuideTutorial",
 CellID->339831],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "GuideTutorial",
 CellID->102045170],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "GuideTutorial",
 CellID->486152925]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->14462],

Cell[TextData[ButtonBox["Managing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ManagingComputationsInNotebooks"]], "GuideMoreAboutSub",
 CellID->8871],

Cell[TextData[ButtonBox["Benchmarking Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Benchmarking/guide/BenchmarkingPackage"]], "GuideMoreAboutSub",
 CellID->178120018],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "GuideMoreAboutSub",
 CellID->102373769],

Cell[TextData[ButtonBox["Global Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "GuideMoreAboutSub",\

 CellID->1706542],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->101502396],

Cell[TextData[ButtonBox["Wolfram Workbench",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://wolfram.com/products/workbench/"], None}]], "GuideRelatedLinks",\

 CellID->1633676869]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tuning & Debugging - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 34.1914622}", "context" -> "", 
    "keywords" -> {
     "absolute timing", "automatic unique names", "available memory", 
      "benchmark", "blocking", "call stack", "cleaning up", 
      "clearing symbols", "clear system cache", "command history", 
      "common subexpressions", "compacting expressions", "compilation", 
      "compressed form", "computation history", "concise form", 
      "constrained memory", "core dump", "CPU time", "create temporary cells",
       "current memory use", "debug", "definitions", "deleting functions", 
      "deleting symbols", "diagnostics", "display of messages", "dump save", 
      "dynamic evaluation", "efficiency", "elided output", "error message", 
      "errors", "evaluation monitor", "evaluation of functions", 
      "evaluation queue", "evaluation with limited memory", 
      "evaluation with time constraints", "execution time", "FASL files", 
      "finite memory", "free memory", "functions being evaluated", 
      "generate unique names", "generating unique-named symbols", "gensym", 
      "history length", "history of computation", "intermediate results", 
      "known symbols", "measurement of efficiency", "measure of speed", 
      "memory", "memory constrained", "memory constraints", 
      "memory consumption", "memory in use", "memory used in computation", 
      "monitoring evaluation", "names for dummy variables", 
      "numerical overflow", "objective goal", "one-line output", 
      "optimization for accuracy", "optimization for speed", 
      "optimization goal", "optimize", "pending evaluations", 
      "performance analysis", "performance goal", "printing of messages", 
      "print intermediate result", "print temporary", 
      "print trace of evaluation", "process time", "profiling", 
      "quality goal", "quality target", "quiet evaluation", 
      "real-time monitoring", "removing functions", "removing symbols", 
      "save definitions", "save dump", "search for symbols", "short output", 
      "shut off messages", "silence messages", "skeleton output", 
      "small output", "speed", "speed accuracy objective", 
      "speed accuracy trade-off", "step monitor", "subsession", 
      "synchronous updating", "system information", "system options", 
      "test data", "time constrained", "time constraints", "time out", 
      "trace print", "tracing assignments", "tracing based on tags", 
      "tracing calls to functions", "tracing functions", "tracing messages", 
      "tracing of built-in functions", "tracing of conditions", 
      "tracing of recursion", "tracing of rules", 
      "tracing of system functions", "tracing of transformation rules", 
      "tracked symbols", "trapping errors", "turn off messages", 
      "undefining functions", "warning", "watch evaluation"}, "index" -> True,
     "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's highly optimized architecture makes it easy to create \
programs that are both elegant and efficient. Its symbolic character lets you \
immediately run and test even the smallest program fragments. And it provides \
full-scale software engineering support, from arbitrarily detailed \
compilation control, to novel high-level symbolic analysis.", 
    "synonyms" -> {}, "title" -> "Tuning & Debugging", "type" -> "Guide", 
    "uri" -> "guide/TuningAndDebugging"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->20337],
Cell[678, 28, 466, 11, 70, "GuideAbstract",
 CellID->300342354],
Cell[1147, 41, 414, 12, 70, "GuideText",
 CellID->4858],
Cell[1564, 55, 403, 13, 70, "GuideText",
 CellID->22512],
Cell[1970, 70, 386, 13, 70, "GuideText",
 CellID->29656],
Cell[2359, 85, 43, 1, 70, "GuideDelimiter",
 CellID->3318],
Cell[2405, 88, 250, 9, 70, "GuideText",
 CellID->13201],
Cell[2658, 99, 443, 12, 70, "GuideText",
 CellID->142],
Cell[3104, 113, 273, 9, 70, "GuideText",
 CellID->160292373],
Cell[3380, 124, 44, 1, 70, "GuideDelimiter",
 CellID->21276],
Cell[3427, 127, 413, 12, 70, "GuideText",
 CellID->31506],
Cell[3843, 141, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->716684181],
Cell[CellGroupData[{
Cell[3926, 146, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->32702],
Cell[4154, 153, 816, 24, 70, "InlineGuideFunctionListing",
 CellID->10684]
}, Open  ]],
Cell[CellGroupData[{
Cell[5007, 182, 204, 5, 70, "GuideFunctionsSubsection",
 CellID->188173209],
Cell[5214, 189, 1136, 32, 70, "InlineGuideFunctionListing",
 CellID->187834434],
Cell[6353, 223, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->15023]
}, Open  ]],
Cell[CellGroupData[{
Cell[6444, 229, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->30270],
Cell[6665, 236, 275, 9, 70, "GuideText",
 CellID->26312],
Cell[6943, 247, 382, 13, 70, "GuideText",
 CellID->8250],
Cell[7328, 262, 1222, 36, 70, "InlineGuideFunctionListing",
 CellID->13475],
Cell[8553, 300, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[8644, 306, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->26850],
Cell[8869, 313, 231, 9, 70, "GuideText",
 CellID->19195],
Cell[9103, 324, 281, 9, 70, "GuideText",
 CellID->5488],
Cell[9387, 335, 1464, 42, 70, "InlineGuideFunctionListing",
 CellID->11520],
Cell[10854, 379, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->26101]
}, Open  ]],
Cell[CellGroupData[{
Cell[10945, 385, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->130584045],
Cell[11018, 388, 284, 9, 70, "GuideText",
 CellID->370990442],
Cell[11305, 399, 294, 9, 70, "GuideText",
 CellID->25432229],
Cell[11602, 410, 402, 12, 70, "GuideText",
 CellID->186727832]
}, Open  ]],
Cell[CellGroupData[{
Cell[12041, 427, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->218488162],
Cell[12128, 430, 1085, 26, 70, "InlineGuideFunctionListing",
 CellID->110862988]
}, Open  ]],
Cell[CellGroupData[{
Cell[13250, 461, 243, 6, 70, "GuideFunctionsSubsection",
 CellID->2687229],
Cell[13496, 469, 1309, 33, 70, "InlineGuideFunctionListing",
 CellID->134019594],
Cell[14808, 504, 48, 1, 70, "GuideDelimiter",
 CellID->234979328],
Cell[14859, 507, 404, 12, 70, "GuideText",
 CellID->87593163]
}, Open  ]],
Cell[CellGroupData[{
Cell[15300, 524, 214, 5, 70, "GuideFunctionsSubsection",
 CellID->20183],
Cell[15517, 531, 797, 23, 70, "InlineGuideFunctionListing",
 CellID->24798]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16363, 560, 57, 1, 70, "GuideTutorialsSection",
 CellID->6784],
Cell[16423, 563, 189, 4, 70, "GuideTutorial",
 CellID->502798481],
Cell[16615, 569, 199, 4, 70, "GuideTutorial",
 CellID->295870457],
Cell[16817, 575, 132, 3, 70, "GuideTutorial",
 CellID->28065665],
Cell[16952, 580, 151, 3, 70, "GuideTutorial",
 CellID->339831],
Cell[17106, 585, 135, 3, 70, "GuideTutorial",
 CellID->102045170],
Cell[17244, 590, 152, 3, 70, "GuideTutorial",
 CellID->486152925]
}, Open  ]],
Cell[CellGroupData[{
Cell[17433, 598, 59, 1, 70, "GuideMoreAboutSection",
 CellID->14462],
Cell[17495, 601, 183, 4, 70, "GuideMoreAboutSub",
 CellID->8871],
Cell[17681, 607, 175, 4, 70, "GuideMoreAboutSub",
 CellID->178120018],
Cell[17859, 613, 171, 3, 70, "GuideMoreAboutSub",
 CellID->102373769],
Cell[18033, 618, 189, 5, 70, "GuideMoreAboutSub",
 CellID->1706542],
Cell[18225, 625, 161, 3, 70, "GuideMoreAbout",
 CellID->335506323]
}, Open  ]],
Cell[CellGroupData[{
Cell[18423, 633, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->101502396],
Cell[18495, 636, 187, 5, 70, "GuideRelatedLinks",
 CellID->1633676869]
}, Open  ]],
Cell[18697, 644, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

