(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15333,        510]
NotebookOptionsPosition[     10532,        388]
NotebookOutlinePosition[     13237,        441]
CellTagsIndexPosition[     13194,        438]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Defining Variables and Functions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The symbolic language paradigm of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes the concept of variables and functions to a new level. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a variable can not only stand for a value, but can also be used purely \
symbolically. And building on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful pattern language, \"functions\" can be defined not just to take \
arguments, but to transform a pattern with any structure. "
}], "GuideAbstract",
 CellID->145123510],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["\[Ellipsis]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TR"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set a variable"
}], "GuideText",
 CellID->893],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["\[Ellipsis]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TR"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " define a function that takes any single argument"
}], "GuideText",
 CellID->10490],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Assignments \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Assignments"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->117050867],

Cell[TextData[{
 Cell[TextData[ButtonBox["Set",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " immediate assignment (right-hand side evaluated immediately)"
}], "GuideText",
 CellID->21641],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[":=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " delayed assignment (right-hand side evaluated only when used)"
}], "GuideText",
 CellID->23258],

Cell[TextData[{
 Cell[TextData[ButtonBox["Unset",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unset"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["=.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unset"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " unset a variable"
}], "GuideText",
 CellID->124393342],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clear a function definition"
}], "GuideText",
 CellID->29161701],

Cell["\t", "GuideDelimiterSubsection",
 CellID->153612809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Function Argument Patterns \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Patterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->49999478],

Cell[TextData[{
 Cell[TextData[ButtonBox["__",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankSequence"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["BlankSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankSequence"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"],
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alternatives"], "TI"]
 }], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["Alternatives",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Alternatives"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"], "TI"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"],
  StyleBox[ButtonBox["e",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Optional",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Optional"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->166375881]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Bodies of Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProceduralProgramming"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->180214436],

Cell[TextData[{
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ProceduralProgramming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scope local variables"
}], "GuideText",
 CellID->67398310],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["e",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["e",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["e",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["CompoundExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CompoundExpression"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " execute expressions in sequence"
}], "GuideText",
 CellID->201680889]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Function Attributes \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Attributes"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->695981030],

Cell[TextData[{
 Cell[TextData[ButtonBox["Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Attributes"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Flat",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flat"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Orderless",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Orderless"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Listable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Listable"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldFirst"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Protected",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Protected"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->591553516]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Values for Symbols",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ValuesForSymbols"]], "GuideTutorial",
 CellID->159754869],

Cell[TextData[ButtonBox["Defining Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningVariables"]], "GuideTutorial",
 CellID->76614309],

Cell[TextData[ButtonBox["Defining Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningFunctions"]], "GuideTutorial",
 CellID->163581321],

Cell[TextData[ButtonBox["Immediate and Delayed Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ImmediateAndDelayedDefinitions"]], "GuideTutorial",
 CellID->217702093],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "GuideTutorial",
 CellID->55108072]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Variables and Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 35.6446244}", "context" -> "", 
    "keywords" -> {
     "assign value", "assignments", "automatic threading over lists", 
      "blank sequence", "blocks", "procedures", "clearing values", 
      "clearing values of symbols", "compound expression", "defining values", 
      "definitions", "delayed assignment", "delayed definitions", 
      "deleting functions", "deleting symbols", "deleting values", 
      "equals sign", "erasing values", "evaluate in sequence", 
      "exchange values", "functions", "hold first", "immediate assignment", 
      "immediate definition", "immediate value", "immutable", 
      "interchange values", "killing values", "lexical scoping", 
      "linear order of execution", "lists", "optional argument", 
      "optional parameters", "optional value", "parameters", "permute values",
       "procedure", "protected attribute", "removing assignments", 
      "removing functions", "removing symbols", "removing values", "scoping", 
      "semicolon", "sequence of commands", "sequence of expressions", 
      "sequential composition", "sequential evaluation", 
      "sequential expression", "Set", "set delayed", "SetDelayed", 
      "setting values", "static scoping", "swap values", "symbols", 
      "threadable", "unchangeable", "undefining functions", 
      "undefining symbols", "unmodifiable", "unset", "unsetting symbols", 
      "values", "write protected"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The symbolic language paradigm of Mathematica takes the concept of \
variables and functions to a new level. In Mathematica a variable can not \
only stand for a value, but can also be used purely symbolically. And \
building on Mathematica's powerful pattern language, \"functions\" can be \
defined not just to take arguments, but to transform a pattern with any \
structure. ", "synonyms" -> {}, "title" -> "Defining Variables and Functions",
     "type" -> "Guide", "uri" -> "guide/VariablesAndFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 74, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[696, 28, 561, 14, 70, "GuideAbstract",
 CellID->145123510],
Cell[1260, 44, 417, 16, 70, "GuideText",
 CellID->893],
Cell[1680, 62, 811, 28, 70, "GuideText",
 CellID->10490],
Cell[2494, 92, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[2577, 97, 210, 5, 70, "GuideFunctionsSubsection",
 CellID->117050867],
Cell[2790, 104, 391, 13, 70, "GuideText",
 CellID->21641],
Cell[3184, 119, 414, 13, 70, "GuideText",
 CellID->23258],
Cell[3601, 134, 358, 13, 70, "GuideText",
 CellID->124393342],
Cell[3962, 149, 249, 9, 70, "GuideText",
 CellID->29161701],
Cell[4214, 160, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->153612809]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 166, 223, 6, 70, "GuideFunctionsSubsection",
 CellID->49999478],
Cell[4535, 174, 1374, 48, 70, "InlineGuideFunctionListing",
 CellID->166375881]
}, Open  ]],
Cell[CellGroupData[{
Cell[5946, 227, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->180214436],
Cell[6177, 234, 382, 13, 70, "GuideText",
 CellID->67398310],
Cell[6562, 249, 820, 27, 70, "GuideText",
 CellID->201680889]
}, Open  ]],
Cell[CellGroupData[{
Cell[7419, 281, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->695981030],
Cell[7639, 288, 1230, 35, 70, "InlineGuideFunctionListing",
 CellID->591553516]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8918, 329, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8983, 332, 153, 3, 70, "GuideTutorial",
 CellID->159754869],
Cell[9139, 337, 153, 3, 70, "GuideTutorial",
 CellID->76614309],
Cell[9295, 342, 154, 3, 70, "GuideTutorial",
 CellID->163581321],
Cell[9452, 347, 185, 4, 70, "GuideTutorial",
 CellID->217702093],
Cell[9640, 353, 138, 3, 70, "GuideTutorial",
 CellID->55108072]
}, Open  ]],
Cell[CellGroupData[{
Cell[9815, 361, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9880, 364, 287, 9, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[10170, 375, 154, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[10327, 380, 163, 3, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[10505, 386, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

