(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13854,        478]
NotebookOptionsPosition[     11148,        388]
NotebookOutlinePosition[     12338,        424]
CellTagsIndexPosition[     12253,        419]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Running Mathematica from Within an External Program\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLInitialize()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLInitialize"], 
          "MLDeinitialize()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDeinitialize"], 
          "MLParameters()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLParameters"], "stdenv" :> 
          Documentation`HelpLookup["paclet:ref/c/stdenv"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLInitialize()\"\>", 
       2->"\<\"MLDeinitialize()\"\>", 3->"\<\"MLParameters()\"\>", 
       4->"\<\"stdenv\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLENV", "ObjectNameAlt",
 CellID->2715],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell["MLENV", "InlineCode"],
     "\[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " type representing a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library environment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " environment object stores the global state of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " during the execution of a program. "
}], "Notes",
 CellID->1923596823],

Cell[TextData[{
 StyleBox["MLENV", "InlineCode"],
 " is defined in the file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "MR"],
 ", which should be included in the source code for any ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-",
 "compatible program. "
}], "Notes",
 CellID->812462603],

Cell[TextData[{
 StyleBox["MLENV", "InlineCode"],
 " objects are created by the ",
 StyleBox[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"], "InlineCode"],
 " function and deallocated by the ",
 StyleBox[ButtonBox["MLDeinitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLDeinitialize"], "InlineCode"],
 " function."
}], "Notes",
 CellID->462235869],

Cell[TextData[{
 "Each ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program must create a ",
 StyleBox["MLENV", "InlineCode"],
 " object before accessing any other ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functionality."
}], "Notes",
 CellID->1349899084],

Cell[TextData[{
 StyleBox["MLENV", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245200203],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61873010],

Cell["\<\
#include \"mathlink.h\"

int main(int argc, char **argv)
{
\tMLENV env;
\tMLINK link;
\tint error;

\tenv = MLInitialize((char *)0);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize the MathLink environment */ }

\tlink = MLOpenArgcArgv(env, argc, argv, &error);
\tif(link == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create the link */ }

\t/* ... */

\tMLClose(link);
\tMLDeinitialize(env);
\treturn 0;
}\
\>", "Program",
 CellID->1736657880]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29766],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLDeinitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLDeinitialize"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLParameters()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLParameters"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["stdenv",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/stdenv"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->664228575]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11465],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLENV - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 18.3969894}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLENVMLENV is a MathLink type representing a MathLink library \
environment.", "synonyms" -> {}, "title" -> "MLENV", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLENV"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6214, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->245200203]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12110, 412}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2959, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3582, 95, 45, 1, 70, "ObjectNameAlt",
 CellID->2715],
Cell[3630, 98, 455, 16, 70, "Usage",
 CellID->11945]
}, Open  ]],
Cell[CellGroupData[{
Cell[4122, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4600, 136, 242, 9, 70, "Notes",
 CellID->1923596823],
Cell[4845, 147, 353, 12, 70, "Notes",
 CellID->812462603],
Cell[5201, 161, 407, 12, 70, "Notes",
 CellID->462235869],
Cell[5611, 175, 272, 11, 70, "Notes",
 CellID->1349899084],
Cell[5886, 188, 291, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6214, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245200203],
Cell[CellGroupData[{
Cell[6599, 218, 147, 5, 70, "ExampleSection",
 CellID->61873010],
Cell[6749, 225, 462, 24, 70, "Program",
 CellID->1736657880]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7260, 255, 311, 9, 70, "SeeAlsoSection",
 CellID->29766],
Cell[7574, 266, 927, 27, 70, "SeeAlso",
 CellID->664228575]
}, Open  ]],
Cell[CellGroupData[{
Cell[8538, 298, 314, 9, 70, "TutorialsSection",
 CellID->11465],
Cell[8855, 309, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[9348, 326, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9682, 337, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10012, 348, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10375, 362, 299, 8, 70, "MoreAboutSection"],
Cell[10677, 372, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11121, 386, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

