(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15352,        502]
NotebookOptionsPosition[     12387,        407]
NotebookOutlinePosition[     13693,        444]
CellTagsIndexPosition[     13608,        439]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TwoWay Communication with External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"], 
          "Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"TwoWay Communication with External Programs\"\>", 
       2->"\<\"Running Mathematica from Within an External Program\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutFunction()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutFunction"], "MLFlush()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLFlush"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLPutFunction()\"\>", 
       2->"\<\"MLFlush()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       3->"\<\"MathLink C Language Functions\"\>", 
       4->"\<\"MathLink Expression Packet Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLEndPacket()", "ObjectNameAlt",
 CellID->28445],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLEndPacket", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]inserts an indicator in the expression stream that says \
the current expression is complete and is ready to be sent."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLEndPacket()", "InlineCode"],
 " should be called to indicate the end of any top",
 "-",
 "level expression, regardless of whether its head is a standard packet. "
}], "Notes",
 CellID->145],

Cell[TextData[{
 StyleBox["MLEndPacket()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLEndPacket()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1825082587],

Cell[TextData[{
 StyleBox["MLEndPacket()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->631463987],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85034962],

Cell["\<\
#include \"mathlink.h\"

/* send the expression {10, Times[3.56, 10], 1.3} to a link */

void f(MLINK lp)
{
\tif(! MLPutFunction(lp, \"List\", 3))
\t\t{ /* unable to send the function List to lp */ }

\tif(! MLPutInteger32(lp, 10))
\t\t{ /* unable to send the integer 10 to lp */ }

\tif(! MLPutFunction(lp, Times, 2))
\t\t{ /* unable to send the function Times to lp */ }

\tif(! MLPutReal64(lp, 3.56))
\t\t{ /* unable to send the double 3.56 to lp */ }

\tif(! MLPutInteger32(lp, 10))
\t\t{ /* unable to send the integer 10 to lp */ }

\tif(! MLPutReal32(lp, 1.3))
\t\t{ /* unable to send the float 1.3 to lp */ }

\tif(! MLEndPacket(lp))
\t\t{ /* unable to send the end of packet message to lp */ }
}\
\>", "Program",
 CellID->1434564487]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10068],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLFlush()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLFlush"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->111037998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21370],

Cell[TextData[{
 ButtonBox["Two",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TwoWayCommunicationWithExternalPrograms"],
 "-",
 ButtonBox["Way Communication with External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]
}], "Tutorials",
 CellID->26516],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->201275506],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLEndPacket() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 18.1782338}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLEndPacket()int MLEndPacket(MLINK link) inserts an indicator in the \
expression stream that says the current expression is complete and is ready \
to be sent.", "synonyms" -> {"end packet"}, "title" -> "MLEndPacket", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLEndPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6389, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->631463987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13465, 432}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3565, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4188, 105, 54, 1, 70, "ObjectNameAlt",
 CellID->28445],
Cell[4245, 108, 632, 18, 70, "Usage",
 CellID->16590]
}, Open  ]],
Cell[CellGroupData[{
Cell[4914, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5392, 148, 218, 6, 70, "Notes",
 CellID->145],
Cell[5613, 156, 179, 5, 70, "Notes",
 CellID->1093240310],
Cell[5795, 163, 255, 9, 70, "Notes",
 CellID->1825082587],
Cell[6053, 174, 299, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6389, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->631463987],
Cell[CellGroupData[{
Cell[6774, 204, 147, 5, 70, "ExampleSection",
 CellID->85034962],
Cell[6924, 211, 751, 29, 70, "Program",
 CellID->1434564487]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7724, 246, 311, 9, 70, "SeeAlsoSection",
 CellID->10068],
Cell[8038, 257, 443, 13, 70, "SeeAlso",
 CellID->111037998]
}, Open  ]],
Cell[CellGroupData[{
Cell[8518, 275, 314, 9, 70, "TutorialsSection",
 CellID->21370],
Cell[8835, 286, 316, 9, 70, "Tutorials",
 CellID->26516],
Cell[9154, 297, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[9647, 314, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9981, 325, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10311, 336, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10674, 350, 319, 9, 70, "MoreAboutSection",
 CellID->201275506],
Cell[10996, 361, 429, 11, 70, "MoreAbout"],
Cell[11428, 374, 331, 8, 70, "MoreAbout"],
Cell[11762, 384, 281, 8, 70, "MoreAbout"],
Cell[12046, 394, 299, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12360, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

