(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19349,        582]
NotebookOptionsPosition[     16456,        490]
NotebookOutlinePosition[     17769,        527]
CellTagsIndexPosition[     17684,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Interrupt Handling" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ErrorAndInterruptHandling"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Error and Interrupt Handling\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLErrorMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLErrorMessage"], 
          "MLClearError()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLClearError"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLErrorMessage()\"\>", 
       2->"\<\"MLClearError()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelMathLinkOperations"],
           "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>", 
       3->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLError()", "ObjectNameAlt",
 CellID->25],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLError", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]returns a value identifying the last error to occur on \
",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ". ",
     StyleBox["MLError()", "InlineCode"],
     " returns ",
     StyleBox["MLEOK", "InlineCode"],
     " if no error has occurred since the previous call to ",
     StyleBox[ButtonBox["MLClearError()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLClearError"], "InlineCode"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29276]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can get a textual description of errors by calling ",
 StyleBox[ButtonBox["MLErrorMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLErrorMessage"], "InlineCode"],
 "."
}], "Notes",
 CellID->3309],

Cell[TextData[{
 StyleBox["MLError()", "InlineCode"],
 " can return the following values:"
}], "Notes",
 CellID->318742580],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEOK", "InlineCode"], Cell["everything is OK", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEDEAD", "InlineCode"], Cell["link died", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEGBAD", Cell[
    "inconsistent data read", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEGSEQ", Cell[TextData[{
     StyleBox["MLGet()", "InlineCode"],
     " function called out of sequence"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPBTK", Cell[TextData[{
     StyleBox[ButtonBox["MLPutNext()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutNext"], "InlineCode"],
     " passed a bad token"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPSEQ", Cell[TextData[{
     StyleBox["MLPut()", "InlineCode"],
     " function called out of sequence"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPBIG", Cell[TextData[{
     StyleBox[ButtonBox["MLPutData()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutData"], "InlineCode"],
     " given too much data"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEOVFL", Cell[
    "machine number overflow", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEMEM", Cell[
    "out of memory", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEACCEPT", Cell[
    "failure to accept socket connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLECONNECT", "InlineCode"], Cell[
    "a deferred connection is still unconnected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPUTENDPACKET", Cell[TextData[{
     "unexpected or missing call of ",
     StyleBox[ButtonBox["MLEndPacket()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLEndPacket"], "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLENEXTPACKET", Cell[TextData[{
     StyleBox[ButtonBox["MLNextPacket()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLNextPacket"], "InlineCode"],
     " called while the current packet has unread data"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEUNKNOWNPACKET", Cell[TextData[{
     StyleBox[ButtonBox["MLNextPacket()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLNextPacket"], "InlineCode"],
     " read in an unknown packet head"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEGETENDPACKET", Cell[
    "unexpected end of packet", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEABORT", Cell[
    "a put or get was aborted before affecting the link", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLECLOSED", "InlineCode"], Cell["\<\
the other side of the link closed the connection (you may still receive \
undelivered data)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEINIT", "InlineCode"], Cell[TextData[{
     "the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " environment was not initialized"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEARGV", "InlineCode"], Cell[
    "insufficient arguments to open the link", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPROTOCOL", Cell[
    "protocol unavailable", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEMODE", "InlineCode"], Cell[
    "mode unavailable", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLELAUNCH", Cell[
    "launch unsupported", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLELAUNCHAGAIN", Cell[
    "cannot launch the program again from the same file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLELAUNCHSPACE", Cell[
    "insufficient space to launch the program", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLENOPARENT", Cell[
    "no parent available for connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLENAMETAKEN", Cell[
    "the linkname was already in use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLENOLISTEN", Cell[
    "the linkname was found not to be listening", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEBADNAME", Cell[
    "the linkname was missing or not in the proper form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEBADHOST", Cell[
    "the location was unreachable or not in the proper form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLELAUNCHFAILED", Cell["\<\
the program failed to launch because a resource or library was missing\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLELAUNCHNAME", Cell[
    "the launch failed because the program could not be found", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPSCONVERT", Cell["\<\
unable to convert from given character encoding to link encoding\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEGSCONVERT", Cell[
    "unable to convert from link encoding to requested encoding", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLEPDATABAD", Cell[
    "character data in given encoding incorrect", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1282326442],

Cell[TextData[{
 StyleBox["MLError()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105091138],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->80912642],

Cell["\<\
#include \"mathlink.h\"

/* send the integer 10 to a link */

void f(MLINK lp)
{
\tif(! MLPutInteger(lp, 10))
\t{
\t\t/* check the possible errors */
\t\tswitch(MLError(lp))
\t\t{
\t\t\tcase MLEDEAD:
\t\t\t\t/* the link died unexpectedly */
\t\t\t\tbreak;
\t\t\tcase MLECLOSED:
\t\t\t\t/* the other side closed the link */
\t\t\t\tbreak;
\t\t\tcase MLEOK:
\t\t\t\t/* no error occurred */
\t\t\t\tbreak;
\t\t\tdefault:
\t\t\t\t/* ... */
\t\t}
\t}
}\
\>", "Program",
 CellID->2061462648]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21389],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLErrorMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLErrorMessage"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLClearError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLClearError"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1410392778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23842],

Cell[TextData[ButtonBox["Error and Interrupt Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ErrorAndInterruptHandling"]], "Tutorials",
 CellID->18108518],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->90030391],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLError() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 18.8032498}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLError()int MLError(MLINK link) returns a value identifying the last \
error to occur on link. MLError() returns MLEOK if no error has occurred \
since the previous call to MLClearError(). ", "synonyms" -> {}, "title" -> 
    "MLError", "type" -> "MathLink C Function", "uri" -> "ref/c/MLError"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11602, 305, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105091138]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17540, 515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3024, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3647, 96, 47, 1, 70, "ObjectNameAlt",
 CellID->25],
Cell[3697, 99, 948, 29, 70, "Usage",
 CellID->29276]
}, Open  ]],
Cell[CellGroupData[{
Cell[4682, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5160, 150, 230, 7, 70, "Notes",
 CellID->3309],
Cell[5393, 159, 123, 4, 70, "Notes",
 CellID->318742580],
Cell[5519, 165, 5772, 122, 70, "2ColumnTableMod",
 CellID->1282326442],
Cell[11294, 289, 271, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[11602, 305, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105091138],
Cell[CellGroupData[{
Cell[11987, 319, 147, 5, 70, "ExampleSection",
 CellID->80912642],
Cell[12137, 326, 495, 27, 70, "Program",
 CellID->2061462648]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12681, 359, 311, 9, 70, "SeeAlsoSection",
 CellID->21389],
Cell[12995, 370, 456, 13, 70, "SeeAlso",
 CellID->1410392778]
}, Open  ]],
Cell[CellGroupData[{
Cell[13488, 388, 314, 9, 70, "TutorialsSection",
 CellID->23842],
Cell[13805, 399, 167, 3, 70, "Tutorials",
 CellID->18108518],
Cell[13975, 404, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[14309, 415, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[14639, 426, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[15002, 440, 318, 9, 70, "MoreAboutSection",
 CellID->90030391],
Cell[15323, 451, 429, 11, 70, "MoreAbout"],
Cell[15755, 464, 375, 11, 70, "MoreAbout"],
Cell[16133, 477, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[16429, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

