(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14893,        509]
NotebookOptionsPosition[     11941,        414]
NotebookOutlinePosition[     13264,        451]
CellTagsIndexPosition[     13179,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TwoWay Communication with External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"], 
          "Setting Up External Functions to Be Called from Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"TwoWay Communication with External Programs\"\>", 
       2->"\<\"Setting Up External Functions to Be Called from \
Mathematica\"\>", 3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLEvaluate()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEvaluate"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MLEvaluate()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Installable MathLink Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLEvaluateString()", "ObjectNameAlt",
 CellID->24187],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLEvaluateString", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"char", " ", "*", 
          StyleBox["string", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]sends a string to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " for evaluation, and discards any packets sent in response. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The code for ",
 StyleBox["MLEvaluateString()", "InlineCode"],
 " is not included in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library, but is generated automatically by ",
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"], "InlineCode"],
 " or ",
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "InlineCode"],
 " in processing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template files. "
}], "Notes",
 CellID->8288],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MLEvaluateString", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["lp", "TI"], ",", 
     RowBox[{"\"\<Print[\[Backslash]\>\"", 
      RowBox[{
       StyleBox["string", "TI"], "\[Backslash]", "\"\<]\>\""}]}]}], ")"}]}]], 
  "InlineCode"],
 " will cause ",
 Cell[BoxData["string"], "InlineCode"],
 " to be printed in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session at the other end of the link. "
}], "Notes",
 CellID->17925],

Cell[TextData[{
 StyleBox["MLEvaluateString()", "InlineCode"],
 " is only available for use in ",
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "InlineCode"],
 " ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 ButtonBox["template",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/file.tm"],
 " programs. "
}], "Notes",
 CellID->1187183055],

Cell[TextData[{
 StyleBox["MLEvaluateString()", "InlineCode"],
 " returns 0 on failure and a nonzero value on success."
}], "Notes",
 CellID->377413544],

Cell[TextData[{
 StyleBox["MLEvaluateString()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354208254],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->102226111],

Cell["\<\
:Begin:
:Function: f
:Pattern: KernelTime[]
:Arguments: {}
:ArgumentTypes: Manual
:ReturnType: Manual
:End:

#include \"mathlink.h\"

/* read the Kernel's response from evaluating the expression
   {Date[],$TimeZone} */

void f(void)
{
\t/* Pretend we are not in our local timezone. */
\tif(! MLEvaluateString(stdlink, \"$TimeZone = 9;\"))
\t\t{ /* unable to send $TimeZone = 9; to stdlink */ }

\tif(! MLEvaluate(stdlink, \"{Date[],$TimeZone}\"))
\t\t{ /* unable to send the expression to stdlink */ }

\t/* get the Kernel's response */
\tswitch(MLGetType(stdlink))
\t{
\t\t/* ... */
\t}

\t/* ... */\t
}\
\>", "Program",
 CellID->248374319]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14767],

Cell[TextData[Cell[TextData[StyleBox[ButtonBox["MLEvaluate()",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/c/MLEvaluate"],
 FontFamily->"Verdana"]], "InlineCode"]], "SeeAlso",
 CellID->7274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16395],

Cell[TextData[{
 ButtonBox["Two",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TwoWayCommunicationWithExternalPrograms"],
 "-",
 ButtonBox["Way Communication with External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]
}], "Tutorials",
 CellID->26516],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->361474453],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->76122919],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLEvaluateString() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 19.1782594}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLEvaluateString()int MLEvaluateString(MLINK link,char *string) sends a \
string to Mathematica for evaluation, and discards any packets sent in \
response. ", "synonyms" -> {"evaluate string"}, "title" -> "MLEvaluateString",
     "type" -> "MathLink C Function", "uri" -> "ref/c/MLEvaluateString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6928, 224, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->354208254]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13036, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3035, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3658, 97, 59, 1, 70, "ObjectNameAlt",
 CellID->24187],
Cell[3720, 100, 768, 23, 70, "Usage",
 CellID->13407]
}, Open  ]],
Cell[CellGroupData[{
Cell[4525, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5003, 145, 540, 19, 70, "Notes",
 CellID->8288],
Cell[5546, 166, 482, 17, 70, "Notes",
 CellID->17925],
Cell[6031, 185, 398, 15, 70, "Notes",
 CellID->1187183055],
Cell[6432, 202, 152, 4, 70, "Notes",
 CellID->377413544],
Cell[6587, 208, 304, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6928, 224, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354208254],
Cell[CellGroupData[{
Cell[7313, 238, 148, 5, 70, "ExampleSection",
 CellID->102226111],
Cell[7464, 245, 652, 32, 70, "Program",
 CellID->248374319]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8165, 283, 311, 9, 70, "SeeAlsoSection",
 CellID->14767],
Cell[8479, 294, 191, 4, 70, "SeeAlso",
 CellID->7274]
}, Open  ]],
Cell[CellGroupData[{
Cell[8707, 303, 314, 9, 70, "TutorialsSection",
 CellID->16395],
Cell[9024, 314, 316, 9, 70, "Tutorials",
 CellID->26516],
Cell[9343, 325, 395, 11, 70, "Tutorials",
 CellID->361474453],
Cell[9741, 338, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10075, 349, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10405, 360, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10768, 374, 318, 9, 70, "MoreAboutSection",
 CellID->76122919],
Cell[11089, 385, 429, 11, 70, "MoreAbout"],
Cell[11521, 398, 378, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11914, 412, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

