(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18078,        582]
NotebookOptionsPosition[     14646,        476]
NotebookOutlinePosition[     16188,        516]
CellTagsIndexPosition[     16103,        511]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLReleaseByteSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReleaseByteSymbol"], 
          "MLGetSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetSymbol"], 
          "MLGetUCS2Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUCS2Symbol"], 
          "MLGetUTF8Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF8Symbol"], 
          "MLGetUTF16Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16Symbol"], 
          "MLGetUTF32Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF32Symbol"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLReleaseByteSymbol()\"\>", 
       2->"\<\"MLGetSymbol()\"\>", 3->"\<\"MLGetUCS2Symbol()\"\>", 
       4->"\<\"MLGetUTF8Symbol()\"\>", 5->"\<\"MLGetUTF16Symbol()\"\>", 
       6->"\<\"MLGetUTF32Symbol()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Symbols\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetByteSymbol()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetByteSymbol", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", "unsigned", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["sp", "TI"]}]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["len", "TI"]}], 
         StyleBox[",", "InlineForumula"], 
         RowBox[{
          StyleBox["long", "InlineForumula"], 
          StyleBox[" ", "InlineForumula"], 
          StyleBox["spec", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]gets a character string corresponding to the name of a \
symbol from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the resulting string in ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " and the number of characters in ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     ". The code ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " is used for any character whose ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " character code is larger than 255."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " allocates memory for the array of character codes. You must call ",
 StyleBox[ButtonBox["MLReleaseByteSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteSymbol"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " fails the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseByteSymbol()", "InlineCode"],
 " on the value contained in ",
 StyleBox["sp", "TI"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " is convenient in situations where no special characters occur."
}], "Notes",
 CellID->218872065],

Cell[TextData[{
 "The character codes used by ",
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " are exactly the ones returned by ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->28786],

Cell[TextData[{
 "The array of character codes returned by ",
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " is not terminated by a null character."
}], "Notes",
 CellID->679522476],

Cell[TextData[{
 "Characters such as newlines are specified by their raw character codes, not \
by ASCII forms such as ",
 Cell["\[Backslash]n", "InlineCode"],
 ". "
}], "Notes",
 CellID->7491],

Cell[TextData[{
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->54979407],

Cell[TextData[{
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->2106872204],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->496253758],

Cell[TextData[{
 StyleBox["MLGetByteSymbol()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33914230],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->471368603],

Cell["\<\
#include \"mathlink.h\"

/* read a symbol encoded with codes from ToCharacterCode[] from a link */

void f(MLINK lp)
{
\tconst unsigned char *symbol;
\tint length;

\tif(! MLGetByteSymbol(lp, &symbol, &length, 0))
\t\t{
\t\t\t/* unable to read the byte-encoded symbol from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseByteSymbol(lp, symbol, length);
}\
\>", "Program",
 CellID->894956795]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLReleaseByteSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF8Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF8Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF16Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF32Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32Symbol"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1954407313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetByteSymbol() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 26.6315752}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetByteSymbol()int MLGetByteSymbol(MLINK link,const unsigned char \
**sp,int *len,long spec) gets a character string corresponding to the name of \
a symbol from the MathLink connection specified by link, storing the \
resulting string in sp and the number of characters in len. The code spec is \
used for any character whose Mathematica character code is larger than 255.", 
    "synonyms" -> {"get byte symbol"}, "title" -> "MLGetByteSymbol", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetByteSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8970, 275, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33914230]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15961, 504}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3755, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4378, 109, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4444, 112, 1621, 47, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6102, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6580, 181, 568, 16, 70, "Notes",
 CellID->1067943069],
Cell[7151, 199, 161, 4, 70, "Notes",
 CellID->218872065],
Cell[7315, 205, 359, 13, 70, "Notes",
 CellID->28786],
Cell[7677, 220, 183, 5, 70, "Notes",
 CellID->679522476],
Cell[7863, 227, 193, 6, 70, "Notes",
 CellID->7491],
Cell[8059, 235, 121, 4, 70, "Notes",
 CellID->54979407],
Cell[8183, 241, 183, 5, 70, "Notes",
 CellID->2106872204],
Cell[8369, 248, 258, 9, 70, "Notes",
 CellID->496253758],
Cell[8630, 259, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8970, 275, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33914230],
Cell[CellGroupData[{
Cell[9354, 289, 148, 5, 70, "ExampleSection",
 CellID->471368603],
Cell[9505, 296, 404, 21, 70, "Program",
 CellID->894956795]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9958, 323, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10277, 334, 1464, 41, 70, "SeeAlso",
 CellID->1954407313]
}, Open  ]],
Cell[CellGroupData[{
Cell[11778, 380, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[12099, 391, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[12302, 397, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[12505, 403, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[12839, 414, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[13169, 425, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[13532, 439, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[13853, 450, 429, 11, 70, "MoreAbout"],
Cell[14285, 463, 319, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[14619, 474, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

