(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15357,        512]
NotebookOptionsPosition[     12279,        413]
NotebookOutlinePosition[     13590,        450]
CellTagsIndexPosition[     13505,        445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Portability of MathLink Programs\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetInteger16()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetInteger16"], 
          "MLGetInteger64()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetInteger64"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLGetInteger16()\"\>", 
       2->"\<\"MLGetInteger64()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink C Functions for Exchanging Integers" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingIntegers"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"C/C++ Language Interface\"\>", 3->"\<\"MathLink API\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Integers\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetInteger32()", "ObjectNameAlt",
 CellID->21288],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetInteger32", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["i", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets a 32-bit integer from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " and stores it in ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24973]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the data on the link corresponds to a real number, ",
 StyleBox["MLGetInteger32()", "InlineCode"],
 " will round it to an integer. "
}], "Notes",
 CellID->18300],

Cell[TextData[{
 "If the data on the link corresponds to an integer too large to store in a C \
",
 StyleBox["int", "InlineCode"],
 " on your computer system, then ",
 StyleBox["MLGetInteger32()", "InlineCode"],
 " will fail, and return 0. "
}], "Notes",
 CellID->5064],

Cell[TextData[{
 "You can get arbitrary",
 "-",
 "precision integers by first using ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " to generate lists of digits, then calling ",
 StyleBox[ButtonBox["MLGetInteger32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32List"], "InlineCode"],
 ". "
}], "Notes",
 CellID->24654],

Cell[TextData[{
 StyleBox["MLGetInteger32()", "InlineCode"],
 " returns a nonzero value if the function succeeds."
}], "Notes",
 CellID->1036399140],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetInteger32()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->412986716],

Cell[TextData[{
 StyleBox["MLGetInteger32()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3491053],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42061636],

Cell["\<\
#include \"mathlink.h\"

/* read a 32-bit integer from a link */

void f(MLINK lp)
{
\tint data;

\tif(! MLGetInteger32(lp, &data))
\t\t{ /* unable to read an integer from lp */ }

\t/* use the integer */
}\
\>", "Program",
 CellID->890001785]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5675],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetInteger16()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger16"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetInteger64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger64"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->17500691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9067],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->294247705],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetInteger32() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 34.6005292}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetInteger32()int MLGetInteger32(MLINK link,int *i) gets a 32-bit \
integer from the MathLink connection specified by link and stores it in i. ", 
    "synonyms" -> {"get integer"}, "title" -> "MLGetInteger32", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetInteger32"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7180, 224, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3491053]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13364, 438}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3438, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4061, 104, 57, 1, 70, "ObjectNameAlt",
 CellID->21288],
Cell[4121, 107, 906, 29, 70, "Usage",
 CellID->24973]
}, Open  ]],
Cell[CellGroupData[{
Cell[5064, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5542, 158, 182, 5, 70, "Notes",
 CellID->18300],
Cell[5727, 165, 269, 8, 70, "Notes",
 CellID->5064],
Cell[5999, 175, 428, 14, 70, "Notes",
 CellID->24654],
Cell[6430, 191, 148, 4, 70, "Notes",
 CellID->1036399140],
Cell[6581, 197, 257, 9, 70, "Notes",
 CellID->412986716],
Cell[6841, 208, 302, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7180, 224, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3491053],
Cell[CellGroupData[{
Cell[7563, 238, 147, 5, 70, "ExampleSection",
 CellID->42061636],
Cell[7713, 245, 253, 15, 70, "Program",
 CellID->890001785]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8015, 266, 310, 9, 70, "SeeAlsoSection",
 CellID->5675],
Cell[8328, 277, 458, 13, 70, "SeeAlso",
 CellID->17500691]
}, Open  ]],
Cell[CellGroupData[{
Cell[8823, 295, 313, 9, 70, "TutorialsSection",
 CellID->9067],
Cell[9139, 306, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[9342, 312, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[9760, 326, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10094, 337, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10424, 348, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10787, 362, 319, 9, 70, "MoreAboutSection",
 CellID->294247705],
Cell[11109, 373, 429, 11, 70, "MoreAbout"],
Cell[11541, 386, 134, 2, 70, "MoreAbout"],
Cell[11678, 390, 234, 8, 70, "MoreAbout"],
Cell[11915, 400, 322, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12252, 411, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

