(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13075,        423]
NotebookOptionsPosition[     10730,        348]
NotebookOutlinePosition[     11826,        378]
CellTagsIndexPosition[     11783,        375]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       2->"\<\"Portability of MathLink Programs\"\>", 
       3->"\<\"Manipulating Expressions in External Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetFloat()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetFloat"], 
          "MLGetDouble()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetDouble"], 
          "MLGetRealList()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetRealList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLGetFloat()\"\>", 
       2->"\<\"MLGetDouble()\"\>", 
       3->"\<\"MLGetRealList()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetReal()", "ObjectNameAlt",
 CellID->1491],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetReal", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"double", " ", "*", 
          StyleBox["x", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets a floating",
     "-",
     "point number from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " and stores it in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the data on the link corresponds to an integer, ",
 StyleBox["MLGetReal()", "InlineCode"],
 " will coerce it to a ",
 StyleBox["double", "InlineCode"],
 " before storing it in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28414],

Cell[TextData[{
 "If the data on the link corresponds to a number outside the range that can \
be stored in a C ",
 StyleBox["double", "InlineCode"],
 " on your computer system, then ",
 StyleBox["MLGetReal()", "InlineCode"],
 " will fail, and return 0. "
}], "Notes",
 CellID->8753],

Cell[TextData[{
 "You can get arbitrary",
 "-",
 "precision real numbers by first using ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " to generate lists of digits, then calling ",
 StyleBox[ButtonBox["MLGetIntegerList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetIntegerList"], "InlineCode"],
 ". "
}], "Notes",
 CellID->32210],

Cell[TextData[{
 StyleBox["MLGetReal()", "InlineCode"],
 " is normally equivalent to ",
 StyleBox[ButtonBox["MLGetDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLGetReal64()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64"], "InlineCode"],
 ". "
}], "Notes",
 CellID->10742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6213],

Cell[TextData[{
 StyleBox[ButtonBox["MLGetFloat()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetFloat"], "InlineCode",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLGetDouble()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"], "InlineCode",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLGetRealList()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetRealList"], "InlineCode",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->25949]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19553],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetReal() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 51.2259548}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetReal()int MLGetReal(MLINK link,double *x) gets a floating-point \
number from the MathLink connection specified by link and stores it in x. ", 
    "synonyms" -> {"get real"}, "title" -> "MLGetReal", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetReal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3275, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3898, 102, 51, 1, 70, "ObjectNameAlt",
 CellID->1491],
Cell[3952, 105, 929, 31, 70, "Usage",
 CellID->18811]
}, Open  ]],
Cell[CellGroupData[{
Cell[4918, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5396, 158, 291, 10, 70, "Notes",
 CellID->28414],
Cell[5690, 170, 283, 8, 70, "Notes",
 CellID->8753],
Cell[5976, 180, 422, 14, 70, "Notes",
 CellID->32210],
Cell[6401, 196, 364, 12, 70, "Notes",
 CellID->10742]
}, Closed]],
Cell[CellGroupData[{
Cell[6802, 213, 310, 9, 70, "SeeAlsoSection",
 CellID->6213],
Cell[7115, 224, 638, 20, 70, "SeeAlso",
 CellID->25949]
}, Open  ]],
Cell[CellGroupData[{
Cell[7790, 249, 314, 9, 70, "TutorialsSection",
 CellID->19553],
Cell[8107, 260, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[8310, 266, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[8728, 280, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[8930, 286, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9264, 297, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9594, 308, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9957, 322, 299, 8, 70, "MoreAboutSection"],
Cell[10259, 332, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10703, 346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

