(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16246,        526]
NotebookOptionsPosition[     13215,        429]
NotebookOutlinePosition[     14571,        467]
CellTagsIndexPosition[     14486,        462]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       2->"\<\"Manipulating Expressions in External Programs\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetByteSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetByteSymbol"], 
          "MLGetUCS2Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUCS2Symbol"], 
          "MLGetUTF8Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF8Symbol"], 
          "MLGetUTF16Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16Symbol"], 
          "MLGetUTF32Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF32Symbol"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLGetByteSymbol()\"\>", 
       2->"\<\"MLGetUCS2Symbol()\"\>", 3->"\<\"MLGetUTF8Symbol()\"\>", 
       4->"\<\"MLGetUTF16Symbol()\"\>", 
       5->"\<\"MLGetUTF32Symbol()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Symbols\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetSymbol()", "ObjectNameAlt",
 CellID->13168],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetSymbol", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["s", "TI"]}]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets a character string corresponding to the name of a \
symbol from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the resulting string in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetSymbol()", "InlineCode"],
 " allocates memory for the character string. You must call ",
 Cell[TextData[ButtonBox["MLReleaseSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseSymbol"]], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetSymbol()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseSymbol()", "InlineCode"],
 " on the value contained in ",
 StyleBox["s", "TI"],
 "."
}], "Notes",
 CellID->1171],

Cell[TextData[{
 StyleBox["MLGetSymbol()", "InlineCode"],
 " creates a string that is terminated by ",
 StyleBox["\[Backslash]0", "InlineCode"],
 ". "
}], "Notes",
 CellID->9606],

Cell[TextData[{
 StyleBox["MLGetSymbol()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetSymbol()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->665835627],

Cell[TextData[{
 StyleBox["MLGetSymbol()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->554224970],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->166788255],

Cell["\<\
#include \"mathlink.h\"

/* read a symbol from a link */

void f(MLINK lp)
{\[LineSeparator]\tconst char *symbol;

\tif(! MLGetSymbol(lp, &symbol))
\t\t{
\t\t\t/* unable to read the symbol from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseSymbol(lp, symbol);
}\
\>", "Program",
 CellID->1247493947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->531],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetByteSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetByteSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF8Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF8Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF16Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF32Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32Symbol"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->56377720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11852],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->54932781],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetSymbol() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 51.7728438}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetSymbol()int MLGetSymbol(MLINK link,const char **s) gets a character \
string corresponding to the name of a symbol from the MathLink connection \
specified by link, storing the resulting string in s. ", 
    "synonyms" -> {"get symbol"}, "title" -> "MLGetSymbol", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7557, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->554224970]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14343, 455}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3862, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4485, 111, 54, 1, 70, "ObjectNameAlt",
 CellID->13168],
Cell[4542, 114, 998, 31, 70, "Usage",
 CellID->7081]
}, Open  ]],
Cell[CellGroupData[{
Cell[5577, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6055, 167, 543, 16, 70, "Notes",
 CellID->1171],
Cell[6601, 185, 178, 6, 70, "Notes",
 CellID->9606],
Cell[6782, 193, 179, 5, 70, "Notes",
 CellID->1093240310],
Cell[6964, 200, 254, 9, 70, "Notes",
 CellID->665835627],
Cell[7221, 211, 299, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7557, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->554224970],
Cell[CellGroupData[{
Cell[7942, 241, 148, 5, 70, "ExampleSection",
 CellID->166788255],
Cell[8093, 248, 314, 19, 70, "Program",
 CellID->1247493947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8456, 273, 309, 9, 70, "SeeAlsoSection",
 CellID->531],
Cell[8768, 284, 1213, 34, 70, "SeeAlso",
 CellID->56377720]
}, Open  ]],
Cell[CellGroupData[{
Cell[10018, 323, 314, 9, 70, "TutorialsSection",
 CellID->11852],
Cell[10335, 334, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[10538, 340, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[10740, 346, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11074, 357, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11404, 368, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11767, 382, 318, 9, 70, "MoreAboutSection",
 CellID->54932781],
Cell[12088, 393, 429, 11, 70, "MoreAbout"],
Cell[12520, 406, 331, 8, 70, "MoreAbout"],
Cell[12854, 416, 319, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13188, 427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

