(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16191,        525]
NotebookOptionsPosition[     13021,        426]
NotebookOutlinePosition[     14474,        465]
CellTagsIndexPosition[     14389,        460]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetSymbol"], 
          "MLGetByteSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetByteSymbol"], 
          "MLGetUCS2Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUCS2Symbol"], 
          "MLGetUTF8Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF8Symbol"], 
          "MLGetUTF16Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16Symbol"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLGetSymbol()\"\>", 
       2->"\<\"MLGetByteSymbol()\"\>", 3->"\<\"MLGetUCS2Symbol()\"\>", 
       4->"\<\"MLGetUTF8Symbol()\"\>", 
       5->"\<\"MLGetUTF16Symbol()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Symbols\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetUTF32Symbol()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetUTF32Symbol", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", "unsigned", " ", 
          RowBox[{"int", " ", "**", 
           StyleBox["s", "TI"]}]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["len", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]gets a UTF-32 character string corresponding to the \
name of a symbol from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the resulting string in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and the length in ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " allocates memory for the character string. You must call ",
 StyleBox[ButtonBox["MLReleaseUTF32Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUTF32Symbol"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseUTF32Symbol()", "InlineCode"],
 " on the contents of ",
 StyleBox["s", "TI"],
 "."
}], "Notes",
 CellID->10556],

Cell[TextData[{
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->639409606],

Cell[TextData[{
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " stores all characters directly in the UTF-32 encoding form. "
}], "Notes",
 CellID->14241],

Cell[TextData[{
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->868001348],

Cell[TextData[{
 StyleBox["MLGetUTF32Symbol()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364062257],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->174324748],

Cell["\<\
#include \"mathlink.h\"

/* read a UTF-32 encoded symbol from a link */

void f(MLINK lp)
{
\tconst unsigned int *symbol;
\tint len;

\tif(! MLGetUTF32Symbol(lp, &symbol, &len))
\t\t{
\t\t\t/* unable to read the UTF-32 symbol from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseUTF32Symbol(lp, symbol, len);
}\
\>", "Program",
 CellID->1855128784]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetByteSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetByteSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF8Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF8Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF16Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16Symbol"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1213892806]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetUTF32Symbol() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 59.4292898}", "context" -> "", 
    "keywords" -> {"UTF-32", "unicode"}, "index" -> True, "label" -> 
    "MathLink C Function", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MLGetUTF32Symbol()int MLGetUTF32Symbol(MLINK link,const unsigned int \
**s,int *len) gets a UTF-32 character string corresponding to the name of a \
symbol from the MathLink connection specified by link, storing the resulting \
string in s and the length in len.", "synonyms" -> {"get UTF32 symbol"}, 
    "title" -> "MLGetUTF32Symbol", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLGetUTF32Symbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7646, 232, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->364062257]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14246, 453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3605, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4228, 107, 64, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4295, 110, 1202, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5534, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6012, 168, 556, 16, 70, "Notes",
 CellID->10556],
Cell[6571, 186, 123, 4, 70, "Notes",
 CellID->639409606],
Cell[6697, 192, 156, 4, 70, "Notes",
 CellID->14241],
Cell[6856, 198, 184, 5, 70, "Notes",
 CellID->1093240310],
Cell[7043, 205, 259, 9, 70, "Notes",
 CellID->868001348],
Cell[7305, 216, 304, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7646, 232, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364062257],
Cell[CellGroupData[{
Cell[8031, 246, 148, 5, 70, "ExampleSection",
 CellID->174324748],
Cell[8182, 253, 361, 21, 70, "Program",
 CellID->1855128784]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8592, 280, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8911, 291, 1205, 34, 70, "SeeAlso",
 CellID->1213892806]
}, Open  ]],
Cell[CellGroupData[{
Cell[10153, 330, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10474, 341, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[10677, 347, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[10880, 353, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11214, 364, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11544, 375, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11907, 389, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[12228, 400, 429, 11, 70, "MoreAbout"],
Cell[12660, 413, 319, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12994, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

