(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14889,        491]
NotebookOptionsPosition[     11833,        397]
NotebookOutlinePosition[     13351,        437]
CellTagsIndexPosition[     13266,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetSymbol"], 
          "MLGetByteSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetByteSymbol"], 
          "MLGetUCS2Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUCS2Symbol"], 
          "MLGetUTF16Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16Symbol"], 
          "MLGetUTF32Symbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF32Symbol"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLGetSymbol()\"\>", 
       2->"\<\"MLGetByteSymbol()\"\>", 3->"\<\"MLGetUCS2Symbol()\"\>", 
       4->"\<\"MLGetUTF16Symbol()\"\>", 
       5->"\<\"MLGetUTF32Symbol()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetUTF8Symbol()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetUTF8Symbol", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", "unsigned", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["s", "TI"]}]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["b", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["c", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]gets a UTF-8 encoded character string corresponding to \
the name of a symbol from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the result in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", the number of bytes in the string in ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", and the number of characters in the string in ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " allocates memory for the character string. You must call ",
 StyleBox[ButtonBox["MLReleaseUTF8Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseUTF8Symbol"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseUTF8Symbol()", "InlineCode"],
 " on the contents of ",
 StyleBox["s", "TI"],
 "."
}], "Notes",
 CellID->1954951093],

Cell[TextData[{
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->1910048107],

Cell[TextData[{
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " stores all characters directly in the UTF-8 Unicode encoding form."
}], "Notes",
 CellID->273746595],

Cell[TextData[{
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->949050291],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->904534533],

Cell[TextData[{
 StyleBox["MLGetUTF8Symbol()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112786655],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->114447392],

Cell["\<\
#include \"mathlink.h\"

/* read an UTF-8 encoded symbol from a link */

void f(MLINK lp)
{
\tconst unsigned char *symbol;
\tint bytes;
\tint characters;

\tif(! MLGetUTF8Symbol(lp, &symbol, &bytes, &characters))
\t\t{
\t\t\t/* unable to read the UTF-8 symbol from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseUTF8Symbol(lp, symbol, bytes, characters);
}\
\>", "Program",
 CellID->1077601639]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetByteSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetByteSymbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUCS2Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF16Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16Symbol"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF32Symbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32Symbol"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->292050906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetUTF8Symbol() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 59.8042994}", "context" -> "", 
    "keywords" -> {"UTF-8", "unicode"}, "index" -> True, "label" -> 
    "MathLink C Function", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MLGetUTF8Symbol()int MLGetUTF8Symbol(MLINK link,const unsigned char \
**s,int *b,int *c) gets a UTF-8 encoded character string corresponding to the \
name of a symbol from the MathLink connection specified by link, storing the \
result in s, the number of bytes in the string in b, and the number of \
characters in the string in c.", "synonyms" -> {"get UTF8 symbol"}, "title" -> 
    "MLGetUTF8Symbol", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLGetUTF8Symbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7157, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112786655]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13123, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2903, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3526, 95, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3592, 98, 1411, 41, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5040, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5518, 161, 556, 16, 70, "Notes",
 CellID->1954951093],
Cell[6077, 179, 123, 4, 70, "Notes",
 CellID->1910048107],
Cell[6203, 185, 165, 4, 70, "Notes",
 CellID->273746595],
Cell[6371, 191, 182, 5, 70, "Notes",
 CellID->949050291],
Cell[6556, 198, 258, 9, 70, "Notes",
 CellID->904534533],
Cell[6817, 209, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7157, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112786655],
Cell[CellGroupData[{
Cell[7542, 239, 148, 5, 70, "ExampleSection",
 CellID->114447392],
Cell[7693, 246, 408, 22, 70, "Program",
 CellID->1077601639]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8150, 274, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8469, 285, 1206, 34, 70, "SeeAlso",
 CellID->292050906]
}, Open  ]],
Cell[CellGroupData[{
Cell[9712, 324, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10033, 335, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10367, 346, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10697, 357, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11060, 371, 299, 8, 70, "MoreAboutSection"],
Cell[11362, 381, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11806, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

