(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15057,        499]
NotebookOptionsPosition[     12185,        405]
NotebookOutlinePosition[     13446,        442]
CellTagsIndexPosition[     13361,        437]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLTransferToEndOfLoopbackLink()" :> 
          Documentation`HelpLookup[
           "paclet:ref/c/MLTransferToEndOfLoopbackLink"], 
          "MLTransferExpression()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLTransferExpression"], 
          "MLOpenArgcArgv()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenArgcArgv"], 
          "MLOpenString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MLTransferToEndOfLoopbackLink()\"\>", 
       2->"\<\"MLTransferExpression()\"\>", 3->"\<\"MLOpenArgcArgv()\"\>", 
       4->"\<\"MLOpenString()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       3->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLLoopbackOpen()", "ObjectNameAlt",
 CellID->9164],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", "MLLoopbackOpen", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLENV",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], " ", 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["errno", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]opens a loopback ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In an external program set up with ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates, the environment ",
 Cell[BoxData[
  ButtonBox["stdenv",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/stdenv"]], "InlineCode"],
 " should be used. "
}], "Notes",
 CellID->13318],

Cell[TextData[{
 "You can use loopback links to effectively store ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Notes",
 CellID->18545],

Cell["\<\
Any expressions written to a loopback link can be read from the same link \
object.\
\>", "Notes",
 CellID->1173438827],

Cell[TextData[{
 StyleBox["MLLoopbackOpen()", "InlineCode"],
 " stores its error results in ",
 Cell[BoxData[
  StyleBox["errno", "TI"]], "InlineFormula"],
 ". If no error occurs ",
 Cell[BoxData[
  StyleBox["errno", "TI"]], "InlineFormula"],
 " contains ",
 StyleBox["MLEOK", "InlineCode"],
 "."
}], "Notes",
 CellID->23196762],

Cell[TextData[{
 StyleBox["MLLoopbackOpen()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->736297402],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55704051],

Cell["\<\
#include \"mathlink.h\"

/* read data from a link, store it in a loopback link, and return the \
loopback link */

MLINK f(MLENV env, MLINK link)
{
\tMLINK loopbacklink;
\tint error;

\tloopbacklink = MLLoopbackOpen(env, &error);
\tif(loopbacklink == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create loopbacklink */ }

\tif(! MLTransferExpression(loopbacklink, link))
\t\t{ /* unable to transfer an expression from link to
             loopbacklink */ }

\treturn loopbacklink;\t
}\
\>", "Program",
 CellID->1771441014]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18254],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLTransferToEndOfLoopbackLink()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferToEndOfLoopbackLink"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLTransferExpression()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLTransferExpression"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->115275256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6813],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108275846],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLLoopbackOpen() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 6.9294818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLLoopbackOpen()MLINK MLLoopbackOpen(MLENV env,int *errno) opens a \
loopback MathLink connection. ", "synonyms" -> {"loopback open"}, "title" -> 
    "MLLoopbackOpen", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLLoopbackOpen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6769, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->736297402]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13218, 430}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3501, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4124, 105, 56, 1, 70, "ObjectNameAlt",
 CellID->9164],
Cell[4183, 108, 801, 26, 70, "Usage",
 CellID->6704]
}, Open  ]],
Cell[CellGroupData[{
Cell[5021, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5499, 156, 298, 11, 70, "Notes",
 CellID->13318],
Cell[5800, 169, 164, 6, 70, "Notes",
 CellID->18545],
Cell[5967, 177, 129, 4, 70, "Notes",
 CellID->1173438827],
Cell[6099, 183, 328, 12, 70, "Notes",
 CellID->23196762],
Cell[6430, 197, 302, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6769, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->736297402],
Cell[CellGroupData[{
Cell[7154, 227, 147, 5, 70, "ExampleSection",
 CellID->55704051],
Cell[7304, 234, 534, 22, 70, "Program",
 CellID->1771441014]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7887, 262, 311, 9, 70, "SeeAlsoSection",
 CellID->18254],
Cell[8201, 273, 991, 27, 70, "SeeAlso",
 CellID->115275256]
}, Open  ]],
Cell[CellGroupData[{
Cell[9229, 305, 313, 9, 70, "TutorialsSection",
 CellID->6813],
Cell[9545, 316, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[9747, 322, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10081, 333, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10411, 344, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10774, 358, 319, 9, 70, "MoreAboutSection",
 CellID->108275846],
Cell[11096, 369, 429, 11, 70, "MoreAbout"],
Cell[11528, 382, 331, 8, 70, "MoreAbout"],
Cell[11862, 392, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12158, 403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

