(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12994,        437]
NotebookOptionsPosition[     10273,        352]
NotebookOutlinePosition[     11699,        391]
CellTagsIndexPosition[     11614,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutMessage"], 
          "MLGetMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetMessage"], 
          "MLSetMessageHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetMessageHandler"], 
          "MLGetMessageHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetMessageHandler"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MLPutMessage()\"\>", 
       2->"\<\"MLGetMessage()\"\>", 3->"\<\"MLSetMessageHandler()\"\>", 
       4->"\<\"MLGetMessageHandler()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLMessageHandlerObject", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MLMessageHandlerObject"], "InlineCode"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " type that describes a function pointer to a function taking three \
arguments: an ",
     StyleBox[ButtonBox["MLINK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLINK"], "InlineCode"],
     ", an ",
     StyleBox["int,", "InlineCode"],
     " and an ",
     StyleBox["int,", "InlineCode"],
     " and returning a ",
     StyleBox["void", "InlineCode"],
     " that implements an urgent message handler."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The urgent message handler function is called when ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " receives an urgent message from the other end of the connection."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLMessageHandlerObject", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7849926],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->581133801],

Cell["\<\
#include \"mathlink.h\"


/* handle three common MathLink urgent messages */

void f(MLINK lp, int msg, int arg)
{
\tif(msg == MLInterruptMessage)
\t\t{ /* generate an interrupt menu */ }
\telse if(msg == MLAbortMessage)
\t\t{ /* abort the current operation */ }
\telse if(msg == MLTerminateMessage)
\t\t{ /* shutdown the program */ }

\t/* ... */
}


int main(int argc, char **argv)
{
\tMLENV env;
\tMLINK link;
\tint error;

\tenv = MLInitialize((char *)0);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize MathLink environment */ }

\tlink = MLOpenArgcArgv(env, argc, argv, &error);
\tif(link == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create link */ }

\tif(! MLSetMessageHandler(link, (MLMessageHandlerObject)f)
\t\t{ /* unable to install message handler for link */ }

\t/* ... */

\tMLClose(link);
\tMLDeinitialize(env);

\treturn 0;
}\
\>", "Program",
 CellID->1747880391]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessage"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessage"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLSetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetMessageHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessageHandler"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->433528100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLMessageHandlerObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 7.4451200}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLMessageHandlerObjectMLMessageHandlerObject is a MathLink type that \
describes a function pointer to a function taking three arguments: an MLINK, \
an int, and an int, and returning a void that implements an urgent message \
handler.", "synonyms" -> {"message handler object"}, "title" -> 
    "MLMessageHandlerObject", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLMessageHandlerObject"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5348, 165, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7849926]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11473, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2773, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3396, 92, 68, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3467, 95, 798, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4302, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4780, 141, 220, 6, 70, "Notes",
 CellID->1067943069],
Cell[5003, 149, 308, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5348, 165, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7849926],
Cell[CellGroupData[{
Cell[5731, 179, 148, 5, 70, "ExampleSection",
 CellID->581133801],
Cell[5882, 186, 900, 44, 70, "Program",
 CellID->1747880391]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6831, 236, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7150, 247, 965, 27, 70, "SeeAlso",
 CellID->433528100]
}, Open  ]],
Cell[CellGroupData[{
Cell[8152, 279, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8473, 290, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8807, 301, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9137, 312, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9500, 326, 299, 8, 70, "MoreAboutSection"],
Cell[9802, 336, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10246, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

