(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13230,        449]
NotebookOptionsPosition[     10371,        360]
NotebookOutlinePosition[     11814,        399]
CellTagsIndexPosition[     11729,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetAllocParameter()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetAllocParameter"], 
          "MLAllocParameter()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLAllocParameter"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLSetAllocParameter()\"\>", 
       2->"\<\"MLAllocParameter()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLNewParameters()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"unsigned", " ", "long", " ", "MLNewParameters", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"char", "*", " ", 
          StyleBox["p", "TI"]}], ",", 
         RowBox[{"unsigned", " ", "long", " ", 
          StyleBox["rev", "TI"]}], ",", 
         RowBox[{"unsigned", " ", "long", " ", 
          StyleBox["apirev", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]initializes an ",
     StyleBox[ButtonBox["MLParameters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLParameters"], "InlineCode"],
     " object ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " and sets the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " revision number to the value specified by ",
     Cell[BoxData[
      StyleBox["rev", "TI"]], "InlineFormula"],
     ", and the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " API revision number to the value specified by ",
     Cell[BoxData[
      StyleBox["apirev", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " revision number and the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API revision number should be set to the the constants ",
 StyleBox["MLREVISION", "InlineCode"],
 " and ",
 StyleBox["MLAPIREVISION", "InlineCode"],
 " from ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLNewParameters()", "InlineCode"],
 " does not allocate memory for the ",
 StyleBox[ButtonBox["MLParameters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLParameters"], "InlineCode"],
 " object ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2078939424],

Cell[TextData[{
 StyleBox["MLNewParameters()", "InlineCode"],
 " returns ",
 Cell[BoxData[
  StyleBox["rev", "TI"]], "InlineFormula"],
 " on success or 0 if an error occurs."
}], "Notes",
 CellID->168490865],

Cell[TextData[{
 StyleBox["MLNewParameters()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26832227],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224921173],

Cell["\<\
#include <stdlib.h>
#include \"mathlink.h\"

/* initialize the MathLink environment */

MLENV f(void)
{
\tMLENV env;
\tMLParameters p;
\tunsigned long res;

\tif(! MLNewParameters((char *)p, MLREVISION, MLAPIREVISION))
\t\t{ /* unable to initialize the parameters object */ }

\tMLSetAllocParameter((char *)p, malloc, free);

\tenv = MLInitialize((char *)p);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize the MathLink environment */ }

\treturn env;
}\
\>", "Program",
 CellID->634531581]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetAllocParameter()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetAllocParameter"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLAllocParameter()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLAllocParameter"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1462652367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLNewParameters() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 14.1796674}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLNewParameters()unsigned long MLNewParameters(char* p,unsigned long \
rev,unsigned long apirev) initializes an MLParameters object p and sets the \
MathLink revision number to the value specified by rev, and the MathLink API \
revision number to the value specified by apirev.", 
    "synonyms" -> {"new parameters"}, "title" -> "MLNewParameters", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLNewParameters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6332, 207, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26832227]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11587, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2503, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3126, 87, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3192, 90, 1281, 38, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4510, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4988, 150, 463, 17, 70, "Notes",
 CellID->1067943069],
Cell[5454, 169, 325, 11, 70, "Notes",
 CellID->2078939424],
Cell[5782, 182, 207, 7, 70, "Notes",
 CellID->168490865],
Cell[5992, 191, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6332, 207, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26832227],
Cell[CellGroupData[{
Cell[6716, 221, 148, 5, 70, "ExampleSection",
 CellID->224921173],
Cell[6867, 228, 504, 24, 70, "Program",
 CellID->634531581]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7420, 258, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7739, 269, 474, 13, 70, "SeeAlso",
 CellID->1462652367]
}, Open  ]],
Cell[CellGroupData[{
Cell[8250, 287, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8571, 298, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8905, 309, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9235, 320, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9598, 334, 299, 8, 70, "MoreAboutSection"],
Cell[9900, 344, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10344, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

