(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16282,        555]
NotebookOptionsPosition[     13180,        455]
NotebookOutlinePosition[     14505,        492]
CellTagsIndexPosition[     14420,        487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLActivate()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLActivate"], 
          "MLOpenString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLActivate()\"\>", 
       2->"\<\"MLOpenString()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Language Functions\"\>", 
       3->"\<\"MathLink Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLOpenArgcArgv()", "ObjectNameAlt",
 CellID->13273],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", "MLOpenArgcArgv", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLENV",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], " ", 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["argc", "TI"]}], ",", 
         RowBox[{"char", "**", " ", 
          StyleBox["argv", "TI"]}], ",", 
         RowBox[{"int", "*", " ", 
          StyleBox["errno", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]opens a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection, taking parameters from command-line arguments."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23489]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"], "InlineCode"],
 " must be called before ",
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 ". "
}], "Notes",
 CellID->4497],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " processes the command-line arguments and uses them to control the creation \
of the link. "
}], "Notes",
 CellID->25338],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " recognizes the following command-line arguments:"
}], "Notes",
 CellID->306850034],

Cell[BoxData[GridBox[{
   {"\"\<-linkconnect\>\"", Cell[TextData[{
     "connect to an existing link (",
     Cell[BoxData[
      ButtonBox["LinkConnect",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {"\"\<-linkcreate\>\"", Cell[TextData[{
     "create a link (",
     Cell[BoxData[
      ButtonBox["LinkCreate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {"\"\<-linklaunch\>\"", Cell[TextData[{
     "launch a child process (",
     Cell[BoxData[
      ButtonBox["LinkLaunch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {
    RowBox[{"\"\<-linkname\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[
    "the name to use in opening the link ", "TableText"]},
   {
    RowBox[{"\"\<-linkprotocol\>\"", ",", "\"\<\!\(\*
StyleBox[\"protocol\", \"TI\"]\)\>\""}], Cell[TextData[{
     "the link protocol to use (",
     StyleBox["TCPIP", "InlineCode"],
     ", ",
     StyleBox["Pipes", "InlineCode"],
     ", ",
     StyleBox["SharedMemory", "InlineCode"],
     ", etc.) "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTable",
 CellID->25576],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " is not sensitive to the case of argument names. "
}], "Notes",
 CellID->22674],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " ignores argument names that it does not recognize. "
}], "Notes",
 CellID->20325],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " is called automatically by the ",
 Cell[TextData[ButtonBox["MLMain()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMain"]], "InlineCode"],
 " function created by ",
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"], "InlineCode"],
 ". "
}], "Notes",
 CellID->31465],

Cell[TextData[{
 "On some computer systems, giving ",
 Cell[BoxData["0"], "InlineCode"],
 " for ",
 Cell[BoxData[
  StyleBox["argc", "TI"]], "InlineFormula"],
 " or a null pointer for ",
 Cell[BoxData[
  StyleBox["argv", "TI"]], "InlineFormula"],
 " will cause arguments to be requested interactively, typically through a \
dialog box. "
}], "Notes",
 CellID->16736],

Cell[TextData[{
 StyleBox["MLOpenArgcArgv()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165703140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->223795006],

Cell["\<\
#include \"mathlink.h\"

/* create a link using command-line parameters */

int main(int argc, char **argv)
{
\tMLENV env;
\tMLINK link;
\tint error;

\tenv = MLInitialize((char *)0);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize the MathLink environment */ }

\t/* let MLOpenArgcArgv process the command line */
\tlink = MLOpenArgcArgv(env, argc, argv, &error);
\tif(link == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create the link */ }

\t/* ... */

\tMLClose(link);
\tMLDeinitialize(env);

\treturn 0;
}\
\>", "Program",
 CellID->398995132]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18421],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLActivate()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLActivate"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->381278504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28989],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->268711226],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLOpenArgcArgv() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 14.6796802}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLOpenArgcArgv()MLINK MLOpenArgcArgv(MLENV env,int argc,char** argv,int* \
errno) opens a MathLink connection, taking parameters from command-line \
arguments.", "synonyms" -> {"open argc argv"}, "title" -> "MLOpenArgcArgv", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLOpenArgcArgv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8522, 277, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->165703140]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14277, 480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2834, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3457, 93, 57, 1, 70, "ObjectNameAlt",
 CellID->13273],
Cell[3517, 96, 990, 30, 70, "Usage",
 CellID->23489]
}, Open  ]],
Cell[CellGroupData[{
Cell[4544, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5022, 148, 240, 8, 70, "Notes",
 CellID->4497],
Cell[5265, 158, 184, 5, 70, "Notes",
 CellID->25338],
Cell[5452, 165, 146, 4, 70, "Notes",
 CellID->306850034],
Cell[5601, 171, 1422, 44, 70, "2ColumnTable",
 CellID->25576],
Cell[7026, 217, 142, 4, 70, "Notes",
 CellID->22674],
Cell[7171, 223, 145, 4, 70, "Notes",
 CellID->20325],
Cell[7319, 229, 492, 16, 70, "Notes",
 CellID->31465],
Cell[7814, 247, 366, 12, 70, "Notes",
 CellID->16736],
Cell[8183, 261, 302, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8522, 277, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165703140],
Cell[CellGroupData[{
Cell[8907, 291, 148, 5, 70, "ExampleSection",
 CellID->223795006],
Cell[9058, 298, 565, 28, 70, "Program",
 CellID->398995132]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9672, 332, 311, 9, 70, "SeeAlsoSection",
 CellID->18421],
Cell[9986, 343, 447, 13, 70, "SeeAlso",
 CellID->381278504]
}, Open  ]],
Cell[CellGroupData[{
Cell[10470, 361, 314, 9, 70, "TutorialsSection",
 CellID->28989],
Cell[10787, 372, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11121, 383, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11451, 394, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11814, 408, 319, 9, 70, "MoreAboutSection",
 CellID->268711226],
Cell[12136, 419, 429, 11, 70, "MoreAbout"],
Cell[12568, 432, 281, 8, 70, "MoreAbout"],
Cell[12852, 442, 286, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13153, 453, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

