(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16694,        552]
NotebookOptionsPosition[     13486,        451]
NotebookOutlinePosition[     14896,        489]
CellTagsIndexPosition[     14811,        484]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutInteger16Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger16Array"], 
          "MLPutInteger64Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger64Array"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MLPutInteger16Array()\"\>", 
       2->"\<\"MLPutInteger64Array()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Integers" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingIntegers"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Integers\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLPutInteger32Array()", "ObjectNameAlt",
 CellID->1914],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLPutInteger32Array", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["dims", "TI"]}], ",", 
         RowBox[{"char", " ", "**", 
          StyleBox["heads", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["d", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]puts an array of 32-bit integers to the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " to form a depth ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " array with dimensions ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The array ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " must be laid out in memory like a C array declared explicitly as ",
 Cell[BoxData[
  RowBox[{"int", " ", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["m", "TI"], "]"}], "[", 
    StyleBox["n", "TI"], "]"}], 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->21154],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["heads", "TI"]], "InlineFormula"],
 " is given as ",
 StyleBox["NULL", "InlineCode"],
 ", the array will be assumed to have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " at every level. "
}], "Notes",
 CellID->20593],

Cell[TextData[{
 "The length of the array at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineCode"],
 " is taken to be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["dims", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->14059],

Cell[TextData[{
 StyleBox["MLPutInteger32Array()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1931284111],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLPutInteger32Array()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1045698459],

Cell[TextData[{
 StyleBox["MLPutInteger32Array()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213456597],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->96843872],

Cell["\<\
#include \"mathlink.h\"

/* send an array of 32-bit integers to a link */

void f(MLINK lp)
{
\tint array[6][10][2][1];
\tint dims[4];
\tint i;

\tfor(i = 0; i < 120; i++)
\t\t*((int *)array + i) = i;

\tdims[0] = 6;
\tdims[1] = 10;
\tdims[2] = 2;
\tdims[3] = 1;

\tif(! MLPutInteger32Array(lp, (int *)array, (int *)dims, (char **)0, 4))
\t\t{ /* unable to send the array to lp */ }
}\
\>", "Program",
 CellID->417081524]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28056],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16Array"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger64Array"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->89260040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17657],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->298214451],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLPutInteger32Array() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 23.5392820}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutInteger32Array()int MLPutInteger32Array(MLINK link,int *a,int \
*dims,char **heads,int d) puts an array of 32-bit integers to the MathLink \
connection specified by link to form a depth d array with dimensions dims. ", 
    "synonyms" -> {"put integer array"}, "title" -> "MLPutInteger32Array", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLPutInteger32Array"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7980, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213456597]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14668, 477}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3702, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4325, 108, 61, 1, 70, "ObjectNameAlt",
 CellID->1914],
Cell[4389, 111, 1244, 38, 70, "Usage",
 CellID->2164]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6148, 171, 412, 15, 70, "Notes",
 CellID->21154],
Cell[6563, 188, 342, 13, 70, "Notes",
 CellID->20593],
Cell[6908, 203, 269, 11, 70, "Notes",
 CellID->14059],
Cell[7180, 216, 187, 5, 70, "Notes",
 CellID->1931284111],
Cell[7370, 223, 263, 9, 70, "Notes",
 CellID->1045698459],
Cell[7636, 234, 307, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7980, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213456597],
Cell[CellGroupData[{
Cell[8365, 264, 147, 5, 70, "ExampleSection",
 CellID->96843872],
Cell[8515, 271, 431, 23, 70, "Program",
 CellID->417081524]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8995, 300, 311, 9, 70, "SeeAlsoSection",
 CellID->28056],
Cell[9309, 311, 478, 13, 70, "SeeAlso",
 CellID->89260040]
}, Open  ]],
Cell[CellGroupData[{
Cell[9824, 329, 314, 9, 70, "TutorialsSection",
 CellID->17657],
Cell[10141, 340, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[10344, 346, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[10547, 352, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[10965, 366, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11299, 377, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11629, 388, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11992, 402, 319, 9, 70, "MoreAboutSection",
 CellID->298214451],
Cell[12314, 413, 429, 11, 70, "MoreAbout"],
Cell[12746, 426, 322, 8, 70, "MoreAbout"],
Cell[13071, 436, 373, 10, 70, "MoreAbout"]
}, Open  ]],
Cell[13459, 449, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

