(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16741,        553]
NotebookOptionsPosition[     13666,        453]
NotebookOutlinePosition[     14913,        490]
CellTagsIndexPosition[     14828,        485]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutArgCount()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutArgCount"], 
          "MLPutData()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLPutArgCount()\"\>", 
       2->"\<\"MLPutData()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelMathLinkOperations"],
           "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLPutNext()", "ObjectNameAlt",
 CellID->12412],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLPutNext", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["type", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]prepares to put an object of the specified type on ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13441]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " values begin with ",
 StyleBox["MLTK.", "InlineCode"]
}], "Notes",
 CellID->1784671800],

Cell["The following types are common:", "Notes",
 CellID->1074844951],

Cell[BoxData[GridBox[{
   {"MLTKERR", Cell["error ", "TableText"]},
   {"MLTKINT", Cell["integer ", "TableText"]},
   {"MLTKFUNC", Cell["composite function ", "TableText"]},
   {"MLTKREAL", Cell["approximate real number ", "TableText"]},
   {"MLTKSTR", Cell["character string ", "TableText"]},
   {"MLTKSYM", Cell["symbol ", "TableText"]},
   {"MLTKOLDINT", Cell[TextData[{
     "integer from older versions of the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library"
    }], "TableText"]},
   {"MLTKOLDREAL", Cell[TextData[{
     "approximate real number from older versions of the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library"
    }], "TableText"]},
   {"MLTKOLDSTR", Cell[TextData[{
     "character string from older versions of the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library"
    }], "TableText"]},
   {"MLTKOLDSYM", Cell[TextData[{
     "symbol from older versions of the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTable",
 CellID->27000],

Cell[TextData[{
 StyleBox["MLTKINT", "InlineCode"],
 " and ",
 StyleBox["MLTKREAL", "InlineCode"],
 " do not necessarily signify numbers that can be stored in C ",
 StyleBox["int", "InlineCode"],
 " and ",
 StyleBox["double", "InlineCode"],
 " variables. "
}], "Notes",
 CellID->15651],

Cell[TextData[{
 StyleBox["MLPutNext()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1724708591],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLPutNext()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->641394166],

Cell[TextData[{
 StyleBox["MLPutNext()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10393127],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->106544040],

Cell["\<\
#include \"mathlink.h\"

/* send a function using tokens and argument counts to a link */

void f(MLINK lp)
{
\tif(! MLPutNext(lp, MLTKFUNC))
\t\t{ /* unable to put the function type to lp */ }

\tif(! MLPutArgCount(lp, 2))
\t\t{ /* unable to put the number of arguments to lp */ }

\tif(! MLPutSymbol(lp, \"Plus\"))
\t\t{ /* unable to put the symbol to lp */ }

\tif(! MLPutInteger32(lp, 2))
\t\t{ /* unable to put the integer to lp */ }

\tif(! MLPutInteger32(lp, 3))
\t\t{ /* unable to put the integer to lp */ }

\tif(! MLFlush(lp))
\t\t{ /* unable to flush an buffered outgoing data to lp */ }
}\
\>", "Program",
 CellID->954808419]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8428],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutArgCount()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutArgCount"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutData"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->698124772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23037],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->258023267],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLPutNext() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 38.1802818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutNext()int MLPutNext(MLINK link,int type) prepares to put an object \
of the specified type on link. ", "synonyms" -> {"put next"}, "title" -> 
    "MLPutNext", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLPutNext"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7990, 248, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->10393127]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14686, 478}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3533, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4156, 105, 52, 1, 70, "ObjectNameAlt",
 CellID->12412],
Cell[4211, 108, 739, 23, 70, "Usage",
 CellID->13441]
}, Open  ]],
Cell[CellGroupData[{
Cell[4987, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5465, 153, 175, 7, 70, "Notes",
 CellID->1784671800],
Cell[5643, 162, 69, 1, 70, "Notes",
 CellID->1074844951],
Cell[5715, 165, 1215, 35, 70, "2ColumnTable",
 CellID->27000],
Cell[6933, 202, 285, 10, 70, "Notes",
 CellID->15651],
Cell[7221, 214, 177, 5, 70, "Notes",
 CellID->1724708591],
Cell[7401, 221, 252, 9, 70, "Notes",
 CellID->641394166],
Cell[7656, 232, 297, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7990, 248, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10393127],
Cell[CellGroupData[{
Cell[8374, 262, 148, 5, 70, "ExampleSection",
 CellID->106544040],
Cell[8525, 269, 647, 26, 70, "Program",
 CellID->954808419]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9221, 301, 310, 9, 70, "SeeAlsoSection",
 CellID->8428],
Cell[9534, 312, 447, 13, 70, "SeeAlso",
 CellID->698124772]
}, Open  ]],
Cell[CellGroupData[{
Cell[10018, 330, 314, 9, 70, "TutorialsSection",
 CellID->23037],
Cell[10335, 341, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[10537, 347, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10871, 358, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11201, 369, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11564, 383, 319, 9, 70, "MoreAboutSection",
 CellID->258023267],
Cell[11886, 394, 429, 11, 70, "MoreAbout"],
Cell[12318, 407, 375, 11, 70, "MoreAbout"],
Cell[12696, 420, 310, 8, 70, "MoreAbout"],
Cell[13009, 430, 331, 8, 70, "MoreAbout"],
Cell[13343, 440, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13639, 451, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

