(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14203,        489]
NotebookOptionsPosition[     11152,        392]
NotebookOutlinePosition[     12550,        431]
CellTagsIndexPosition[     12465,        426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLReady()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReady"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLReady()\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLReadyParallel()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLReadyParallel", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLENV",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], " ", 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", "*", 
          StyleBox["links", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["n", "TI"]}], ",", 
         RowBox[{
          ButtonBox["mltimeval",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/mltimeval"], " ", 
          StyleBox["waittime", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]takes a list of link objects of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and waits a timeout period specified by ",
     Cell[BoxData[
      StyleBox["waittime", "TI"]], "InlineFormula"],
     " for one of those links to have data ready to read."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " returns the index into the list of link objects of the link that has data \
to read",
 ". ",
 "The links are indexed from ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["n", "TI"], "-", "1"}], ")"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " returns ",
 StyleBox["MLREADYPARALLELTIMEDOUT", "InlineCode"],
 " if no link has data to read after the timeout period expires."
}], "Notes",
 CellID->1958007395],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " returns ",
 StyleBox["MLREADYPARALLELERROR", "InlineCode"],
 " in the event of an error."
}], "Notes",
 CellID->190881137],

Cell[TextData[{
 "To wait for an indefinite period until a link is ready, set ",
 Cell[BoxData[
  StyleBox["waittime", "TI"]], "InlineFormula"],
 " to ",
 StyleBox["MLINFINITEWAIT", "InlineCode"],
 "."
}], "Notes",
 CellID->2113123014],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " cannot be used as a fine-grained wait mechanism."
}], "Notes",
 CellID->72120658],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " is analogous to the kernel function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    StyleBox["waittime", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->951122098],

Cell[TextData[{
 StyleBox["MLReadyParallel()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236796622],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->145307353],

Cell["\<\
#include \"mathlink.h\"

/* read data from either of two links */

void f(MLENV env, MLINK lp1, MLINK lp2)
{
\tmltimeval timeout;
\tMLINK links[2];
\tint result;

\ttimeout.tv_sec = 5;
\ttimeout.tv_usec = 0;

\tlinks[0] = lp1;
\tlinks[1] = lp2;

\tresult = MLReadyParallel(env, (MLINK *)links, 2, timeout);
\tif(result == MLREADYPARALLELERROR)
\t\t{ /* unable to check links for data */ }
\telse if(result != MLREADYPARALLELTIMEDOUT)
\t\t{
\t\t\t/* read the link that has data ready */
\t\t\tif(result == 0)
\t\t\t\t/* read lp1 */
\t\t\telse
\t\t\t\t/* read lp2 */
\t\t}
}\
\>", "Program",
 CellID->53703843]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[TextData[StyleBox[ButtonBox["MLReady()",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/c/MLReady"],
 FontFamily->"Verdana"]], "InlineCode"]], "SeeAlso",
 CellID->1777290477]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLReadyParallel() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 2.3840264}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLReadyParallel()int MLReadyParallel(MLENV env,MLINK *links,int \
n,mltimeval waittime) takes a list of link objects of length n and waits a \
timeout period specified by waittime for one of those links to have data \
ready to read.", "synonyms" -> {"ready parallel"}, "title" -> 
    "MLReadyParallel", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLReadyParallel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6884, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->236796622]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12322, 419}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2517, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3140, 88, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3206, 91, 1262, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4505, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4983, 149, 381, 14, 70, "Notes",
 CellID->1067943069],
Cell[5367, 165, 227, 6, 70, "Notes",
 CellID->1958007395],
Cell[5597, 173, 187, 6, 70, "Notes",
 CellID->190881137],
Cell[5787, 181, 235, 8, 70, "Notes",
 CellID->2113123014],
Cell[6025, 191, 146, 4, 70, "Notes",
 CellID->72120658],
Cell[6174, 197, 367, 13, 70, "Notes",
 CellID->951122098],
Cell[6544, 212, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6884, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236796622],
Cell[CellGroupData[{
Cell[7269, 242, 148, 5, 70, "ExampleSection",
 CellID->145307353],
Cell[7420, 249, 618, 30, 70, "Program",
 CellID->53703843]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8087, 285, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8406, 296, 191, 4, 70, "SeeAlso",
 CellID->1777290477]
}, Open  ]],
Cell[CellGroupData[{
Cell[8634, 305, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8955, 316, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9289, 327, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9619, 338, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9982, 352, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[10303, 363, 429, 11, 70, "MoreAbout"],
Cell[10735, 376, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11125, 390, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

