(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14662,        470]
NotebookOptionsPosition[     11765,        378]
NotebookOutlinePosition[     13112,        416]
CellTagsIndexPosition[     13027,        411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetReal64List()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetReal64List"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MLGetReal64List()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingLists"], 
          "MathLink C Functions for Exchanging Reals" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingReals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Lists\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Reals\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLReleaseReal64List()", "ObjectNameAlt",
 CellID->21375],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"void", " ", "MLReleaseReal64List", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"double", " ", "*", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["n", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]disowns memory allocated by ",
     StyleBox[ButtonBox["MLGetReal64List()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal64List"], "InlineCode"],
     " to store the array ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLReleaseReal64List()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205667862],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->24099500],

Cell["\<\
#include \"mathlink.h\"

/* read a list of double-precision floating-point numbers from a link and \
then release the memory to MathLink for deallocation */

void f(MLINK lp)
{
\tdouble *data;
\tint length;

\tif(! MLGetReal64List(lp, &data, &length))
\t  { /* unable to read the list of floating-point numbers from lp */ }

\t/* ... */

\tMLReleaseReal64List(lp, data, length);
}\
\>", "Program",
 CellID->665891406]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9537],

Cell[TextData[Cell[TextData[StyleBox[ButtonBox["MLGetReal64List()",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/c/MLGetReal64List"],
 FontFamily->"Verdana"]], "InlineCode"]], "SeeAlso",
 CellID->778497672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8493],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->101884693],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingLists"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingLists"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLReleaseReal64List() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 11.5248854}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLReleaseReal64List()void MLReleaseReal64List(MLINK link,double *a,int \
n) disowns memory allocated by MLGetReal64List() to store the array a of \
length n. ", "synonyms" -> {"release real list"}, "title" -> 
    "MLReleaseReal64List", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLReleaseReal64List"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6293, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->205667862]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12884, 404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3699, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4322, 109, 62, 1, 70, "ObjectNameAlt",
 CellID->21375],
Cell[4387, 112, 1047, 32, 70, "Usage",
 CellID->1425]
}, Open  ]],
Cell[CellGroupData[{
Cell[5471, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5949, 166, 307, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6293, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205667862],
Cell[CellGroupData[{
Cell[6678, 196, 147, 5, 70, "ExampleSection",
 CellID->24099500],
Cell[6828, 203, 427, 19, 70, "Program",
 CellID->665891406]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7304, 228, 310, 9, 70, "SeeAlsoSection",
 CellID->9537],
Cell[7617, 239, 206, 4, 70, "SeeAlso",
 CellID->778497672]
}, Open  ]],
Cell[CellGroupData[{
Cell[7860, 248, 313, 9, 70, "TutorialsSection",
 CellID->8493],
Cell[8176, 259, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[8379, 265, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[8582, 271, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[9000, 285, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9334, 296, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9664, 307, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10027, 321, 319, 9, 70, "MoreAboutSection",
 CellID->101884693],
Cell[10349, 332, 429, 11, 70, "MoreAbout"],
Cell[10781, 345, 310, 8, 70, "MoreAbout"],
Cell[11094, 355, 313, 8, 70, "MoreAbout"],
Cell[11410, 365, 313, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[11738, 376, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

