(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13568,        457]
NotebookOptionsPosition[     10713,        367]
NotebookOutlinePosition[     12088,        405]
CellTagsIndexPosition[     12003,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetSignalHandlerFromFunction()" :> 
          Documentation`HelpLookup[
           "paclet:ref/c/MLSetSignalHandlerFromFunction"], 
          "MLUnsetSignalHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLUnsetSignalHandler"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"MLSetSignalHandlerFromFunction()\"\>", 
       2->"\<\"MLUnsetSignalHandler()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLSetSignalHandler()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLSetSignalHandler", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox[
           RowBox[{"MLENV", " "}],
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["s", "TI"]}], ",", 
         RowBox[{"void", " ", "*", 
          StyleBox["sa", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]installs the Unix signal handler detailed in the \
object ",
     Cell[BoxData[
      StyleBox["sa", "TI"]], "InlineFormula"],
     " for signal ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " in the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library signal-handling mechanism."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLSetSignalHandler()", "InlineCode"],
 " does nothing on Microsoft Windows."
}], "Notes",
 CellID->1624790143],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["sa", "TI"]], "InlineFormula"],
 " is a pointer to a Unix ",
 StyleBox["sigaction struct", "InlineCode"],
 ". See the header file ",
 StyleBox["signal.h", "InlineCode"],
 " on most Unix and Unix-like systems for details regarding the ",
 StyleBox["sigaction", "InlineCode"],
 " structure."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLSetSignalHandler()", "InlineCode"],
 " returns ",
 StyleBox["MLEOK", "InlineCode"],
 " if no error occurs and one of the other error codes as listed in ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " in the event of an error."
}], "Notes",
 CellID->721513517],

Cell[TextData[{
 StyleBox["MLSetSignalHandler()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593132226],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251473338],

Cell["\<\
#include <signal.h>
#include \"mathlink.h\"

void app_signal_handler(int signum)
{
\t/* ... */
}

/* set a signal handler in the MathLink environment */

void f(MLENV ep)
{
\tstruct sigaction sa;
\tint err;

\tsa.sa_handler = (void (*)(int))app_signal_handler;
\tsigemptyset(&sa.sa_mask);
\tsa.sa_flags = 0;


\t/* install app_signal_handler for SIGHUP */
\terr = MLSetSignalHandler(ep, SIGHUP, (void *)&sa);
\tif(err != MLEOK)
\t\t{ /* unable to set the signal handler in ep */ }
}\
\>", "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetSignalHandlerFromFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetSignalHandlerFromFunction"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLUnsetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLUnsetSignalHandler"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->793224567]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLSetSignalHandler() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 26.9471552}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLSetSignalHandler()int MLSetSignalHandler(MLENV env,int s,void *sa) \
installs the Unix signal handler detailed in the object sa for signal s in \
the MathLink library signal-handling mechanism.", 
    "synonyms" -> {"set signal handler"}, "title" -> "MLSetSignalHandler", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLSetSignalHandler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6221, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->593132226]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11860, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2757, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3380, 92, 66, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3449, 95, 1042, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4528, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5006, 150, 137, 4, 70, "Notes",
 CellID->1624790143],
Cell[5146, 156, 365, 11, 70, "Notes",
 CellID->1067943069],
Cell[5514, 169, 361, 10, 70, "Notes",
 CellID->721513517],
Cell[5878, 181, 306, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6221, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593132226],
Cell[CellGroupData[{
Cell[6606, 211, 148, 5, 70, "ExampleSection",
 CellID->251473338],
Cell[6757, 218, 530, 27, 70, "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7336, 251, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7655, 262, 503, 13, 70, "SeeAlso",
 CellID->793224567]
}, Open  ]],
Cell[CellGroupData[{
Cell[8195, 280, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8516, 291, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8850, 302, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9180, 313, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9543, 327, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[9864, 338, 429, 11, 70, "MoreAbout"],
Cell[10296, 351, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10686, 365, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

