(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12658,        437]
NotebookOptionsPosition[      9789,        345]
NotebookOutlinePosition[     11115,        383]
CellTagsIndexPosition[     11030,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLSetYieldFunction()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLSetYieldFunction", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{
          ButtonBox["MLYieldFunctionObject",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLYieldFunctionObject"], " ", 
          StyleBox["yf", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]installs the yield function ",
     Cell[BoxData[
      StyleBox["yf", "TI"]], "InlineFormula"],
     " for the link referenced by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Some ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API calls will block until data is available to read or space is available \
for writing. If an application needs to perform other useful processing \
during that blocking time, the application can install a yield function for \
the link and ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will automatically make calls to the yield function while it blocks."
}], "Notes",
 CellID->1968326934],

Cell["\<\
To back out of a blocked read or write, the yield function should return a \
nonzero value.\
\>", "Notes",
 CellID->1341897437],

Cell[TextData[{
 StyleBox["MLSetYieldFunction()", "InlineCode"],
 " will return 0 in the event of an error, and a nonzero value if the \
function succeeds."
}], "Notes",
 CellID->517500529],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLSetYieldFunction()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1185228329],

Cell[TextData[{
 StyleBox["MLSetYieldFunction()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19995316],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->114475620],

Cell["\<\
#include \"mathlink.h\"

int AppYieldFunction(MLINK lp, MLYieldParameters yp)
{
\t/* ... */
\treturn 0;
}

int main(int argc, char **argv)
{
\tMLENV env;
\tMLINK link;
\tint error;

\tenv = MLInitialize((MLParametersPointer)0);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize MathLink environment */ }

\tlink = MLOpenArgcArgv(env, argv, argv + argc, &error);
\tif(link == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create the link */ }

\tif(! MLSetYieldFunction(link, (MLYieldFunctionObject)AppYieldFunction))
\t\t{ /* unablet to set the yield function for link */ }

\t/* ... */

\tMLClose(link);
\tMLDeinitialize(env);
\treturn 0;
}\
\>", "Program",
 CellID->2034909243]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell["MLGetYieldFunction()", "RelatedLinks",
 CellID->1118947903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLSetYieldFunction() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 27.3065394}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLSetYieldFunction()int MLSetYieldFunction(MLINK \
link,MLYieldFunctionObject yf) installs the yield function yf for the link \
referenced by link.", "synonyms" -> {"set yield function"}, "title" -> 
    "MLSetYieldFunction", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLSetYieldFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5564, 181, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19995316]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10888, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1981, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2604, 73, 66, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[2673, 76, 961, 29, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3671, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4149, 127, 472, 12, 70, "Notes",
 CellID->1968326934],
Cell[4624, 141, 137, 4, 70, "Notes",
 CellID->1341897437],
Cell[4764, 147, 189, 5, 70, "Notes",
 CellID->517500529],
Cell[4956, 154, 262, 9, 70, "Notes",
 CellID->1185228329],
Cell[5221, 165, 306, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5564, 181, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19995316],
Cell[CellGroupData[{
Cell[5948, 195, 148, 5, 70, "ExampleSection",
 CellID->114475620],
Cell[6099, 202, 692, 33, 70, "Program",
 CellID->2034909243]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6840, 241, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7161, 252, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[7495, 263, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[7825, 274, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8188, 288, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[8517, 299, 65, 1, 70, "RelatedLinks",
 CellID->1118947903]
}, Open  ]],
Cell[CellGroupData[{
Cell[8619, 305, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[8940, 316, 429, 11, 70, "MoreAbout"],
Cell[9372, 329, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[9762, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

