(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11866,        407]
NotebookOptionsPosition[      9234,        321]
NotebookOutlinePosition[     10452,        357]
CellTagsIndexPosition[     10367,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLFromLinkID()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLFromLinkID"], 
          "MLLinkName()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLLinkName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLFromLinkID()\"\>", 
       2->"\<\"MLLinkName()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLToLinkID()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"long", " ", "MLToLinkID", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]returns the ID number of ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ID number is suitable for use with ",
 StyleBox[ButtonBox["MLFromLinkID()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLFromLinkID"], "InlineCode"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLToLinkID()", "InlineCode"],
 " returns 0 in the event of an error and a positive integer value \
otherwise."
}], "Notes",
 CellID->39693530],

Cell[TextData[{
 StyleBox["MLToLinkID()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->683640856],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->453995666],

Cell["\<\
#include \"mathlink.h\"

/* get the link id number */

void f(MLINK lp)
{
\tlong idnumber;

\tidnumber = MLToLinkID(lp);
\tif(idnumber == 0)
\t\t{ /* unable to get the link id number */ }
}\
\>", "Program",
 CellID->300206217]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLFromLinkID()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLFromLinkID"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLLinkName()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLLinkName"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1644482389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLToLinkID() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 27.7909268}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLToLinkID()long MLToLinkID(MLINK link) returns the ID number of link.", 
    "synonyms" -> {"to link ID"}, "title" -> "MLToLinkID", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLToLinkID"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5180, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->683640856]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10224, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2656, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3279, 90, 58, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3340, 93, 623, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4000, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4478, 135, 216, 7, 70, "Notes",
 CellID->1067943069],
Cell[4697, 144, 169, 5, 70, "Notes",
 CellID->39693530],
Cell[4869, 151, 274, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5180, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->683640856],
Cell[CellGroupData[{
Cell[5565, 181, 148, 5, 70, "ExampleSection",
 CellID->453995666],
Cell[5716, 188, 236, 14, 70, "Program",
 CellID->300206217]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6001, 208, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6320, 219, 448, 13, 70, "SeeAlso",
 CellID->1644482389]
}, Open  ]],
Cell[CellGroupData[{
Cell[6805, 237, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7126, 248, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[7460, 259, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[7790, 270, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8153, 284, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[8474, 295, 429, 11, 70, "MoreAbout"],
Cell[8906, 308, 286, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[9207, 319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

