(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7064,        239]
NotebookOptionsPosition[      5158,        177]
NotebookOutlinePosition[      6178,        206]
CellTagsIndexPosition[      6135,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CapitalARing]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalARing"], 
          "\\[EmptySmallCircle]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/EmptySmallCircle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[CapitalARing]\"\>", 
       2->"\<\"\\\\[EmptySmallCircle]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ARing]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ARing]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->233337863],

Cell["\\[ARing]", "CharacterName",
 CellID->17086],

Cell["Unicode: 00E5.", "Notes",
 CellID->440570572],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ao", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3487],

Cell["Letter. ", "Notes",
 CellID->29577],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->14474]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->2625],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->25627],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28520],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CapitalARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalARing"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->6902]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->508536234],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ARing] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 58.6295878}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00E5. Alias: Esc ao Esc. Letter. Included in ISO Latin-1. ", 
    "synonyms" -> {"a ring"}, "title" -> "\\[ARing]", "type" -> 
    "Character Name", "uri" -> "ref/character/ARing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2243, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2866, 83, 581, 19, 70, "CharacterImage",
 CellID->233337863],
Cell[3450, 104, 50, 1, 70, "CharacterName",
 CellID->17086],
Cell[3503, 107, 51, 1, 70, "Notes",
 CellID->440570572],
Cell[3557, 110, 233, 9, 70, "Notes",
 CellID->3487],
Cell[3793, 121, 41, 1, 70, "Notes",
 CellID->29577],
Cell[3837, 124, 66, 1, 70, "Notes",
 CellID->14474]
}, Open  ]],
Cell[CellGroupData[{
Cell[3940, 130, 52, 1, 70, "TutorialsSection",
 CellID->2625],
Cell[3995, 133, 189, 4, 70, "Tutorials",
 CellID->25627],
Cell[4187, 139, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4397, 147, 50, 1, 70, "SeeAlsoSection",
 CellID->28520],
Cell[4450, 150, 425, 12, 70, "SeeAlso",
 CellID->6902]
}, Open  ]],
Cell[CellGroupData[{
Cell[4912, 167, 58, 1, 70, "MoreAboutSection",
 CellID->508536234],
Cell[4973, 170, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5131, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

