(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7392,        248]
NotebookOptionsPosition[      5373,        183]
NotebookOutlinePosition[      6457,        213]
CellTagsIndexPosition[      6414,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Bet]" :> 
          Documentation`HelpLookup["paclet:ref/character/Bet"], "\\[Gimel]" :> 
          Documentation`HelpLookup["paclet:ref/character/Gimel"], "\\[Dalet]" :> 
          Documentation`HelpLookup["paclet:ref/character/Dalet"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Bet]\"\>", 
       2->"\<\"\\\\[Gimel]\"\>", 
       3->"\<\"\\\\[Dalet]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Aleph]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Aleph]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->401914798],

Cell["\\[Aleph]", "CharacterName",
 CellID->29657],

Cell["Unicode: 2135.", "Notes",
 CellID->7958],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["al", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->6191],

Cell["Hebrew letter. ", "Notes",
 CellID->19815],

Cell["Sometimes called alef. ", "Notes",
 CellID->22888],

Cell["Used in pure mathematics to denote transfinite cardinals. ", "Notes",
 CellID->19156]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11511],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->16202],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20328],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Bet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Bet"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Gimel]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Gimel"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Dalet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Dalet"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22646]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->12978260],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Aleph] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 50.6137576}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2135. Alias: Esc al Esc. Hebrew letter. Sometimes called alef. \
Used in pure mathematics to denote transfinite cardinals. ", 
    "synonyms" -> {"aleph"}, "title" -> "\\[Aleph]", "type" -> 
    "Character Name", "uri" -> "ref/character/Aleph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2227, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2850, 82, 581, 19, 70, "CharacterImage",
 CellID->401914798],
Cell[3434, 103, 50, 1, 70, "CharacterName",
 CellID->29657],
Cell[3487, 106, 46, 1, 70, "Notes",
 CellID->7958],
Cell[3536, 109, 233, 9, 70, "Notes",
 CellID->6191],
Cell[3772, 120, 48, 1, 70, "Notes",
 CellID->19815],
Cell[3823, 123, 56, 1, 70, "Notes",
 CellID->22888],
Cell[3882, 126, 91, 1, 70, "Notes",
 CellID->19156]
}, Open  ]],
Cell[CellGroupData[{
Cell[4010, 132, 53, 1, 70, "TutorialsSection",
 CellID->11511],
Cell[4066, 135, 163, 3, 70, "Tutorials",
 CellID->16202],
Cell[4232, 140, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4442, 148, 50, 1, 70, "SeeAlsoSection",
 CellID->20328],
Cell[4495, 151, 596, 17, 70, "SeeAlso",
 CellID->22646]
}, Open  ]],
Cell[CellGroupData[{
Cell[5128, 173, 57, 1, 70, "MoreAboutSection",
 CellID->12978260],
Cell[5188, 176, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5346, 181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

