(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7768,        256]
NotebookOptionsPosition[      5731,        193]
NotebookOutlinePosition[      6908,        224]
CellTagsIndexPosition[      6865,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[InvisibleComma]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleComma"], 
          "\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"], 
          "\\[Null]" :> Documentation`HelpLookup["paclet:ref/character/Null"],
           "\\[NoBreak]" :> 
          Documentation`HelpLookup["paclet:ref/character/NoBreak"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[InvisibleComma]\"\>", 
       2->"\<\"\\\\[InvisibleSpace]\"\>", 3->"\<\"\\\\[Null]\"\>", 
       4->"\<\"\\\\[NoBreak]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[AlignmentMarker]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[AlignmentMarker]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->465755098],

Cell["\\[AlignmentMarker]", "CharacterName",
 CellID->18060],

Cell["Unicode: F760.", "Notes",
 CellID->21718],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["am", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3753],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->16139],

Cell["Invisible by default on display. ", "Notes",
 CellID->12423],

Cell[TextData[{
 "Used as a marker to indicate, for example, how entries in a ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " column should be lined up. "
}], "Notes",
 CellID->16279]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->25996],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->12529]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19866],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[InvisibleComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleComma"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Null]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NoBreak]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NoBreak"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->12949]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[AlignmentMarker] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 51.0512688}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F760. Alias: Esc am Esc. Letter-like form. Invisible by default \
on display. Used as a marker to indicate, for example, how entries in a \
GridBox column should be lined up. ", "synonyms" -> {"alignment marker"}, 
    "title" -> "\\[AlignmentMarker]", "type" -> "Character Name", "uri" -> 
    "ref/character/AlignmentMarker"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2267, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2890, 82, 601, 19, 70, "CharacterImage",
 CellID->465755098],
Cell[3494, 103, 60, 1, 70, "CharacterName",
 CellID->18060],
Cell[3557, 106, 47, 1, 70, "Notes",
 CellID->21718],
Cell[3607, 109, 233, 9, 70, "Notes",
 CellID->3753],
Cell[3843, 120, 59, 1, 70, "Notes",
 CellID->16139],
Cell[3905, 123, 66, 1, 70, "Notes",
 CellID->12423],
Cell[3974, 126, 258, 8, 70, "Notes",
 CellID->16279]
}, Open  ]],
Cell[CellGroupData[{
Cell[4269, 139, 53, 1, 70, "TutorialsSection",
 CellID->25996],
Cell[4325, 142, 196, 4, 70, "Tutorials",
 CellID->12529]
}, Open  ]],
Cell[CellGroupData[{
Cell[4558, 151, 38, 0, 70, "MoreAboutSection"],
Cell[4599, 153, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4779, 160, 50, 1, 70, "SeeAlsoSection",
 CellID->19866],
Cell[4832, 163, 857, 25, 70, "SeeAlso",
 CellID->12949]
}, Open  ]],
Cell[5704, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

