(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9176,        315]
NotebookOptionsPosition[      6956,        245]
NotebookOutlinePosition[      8128,        276]
CellTagsIndexPosition[      8085,        273]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Or]" :> Documentation`HelpLookup["paclet:ref/character/Or"],
           "\\[Nand]" :> 
          Documentation`HelpLookup["paclet:ref/character/Nand"], "\\[Not]" :> 
          Documentation`HelpLookup["paclet:ref/character/Not"], "\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Or]\"\>", 
       2->"\<\"\\\\[Nand]\"\>", 3->"\<\"\\\\[Not]\"\>", 
       4->"\<\"\\\\[Wedge]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[And]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[And]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->17586826],

Cell["\\[And]", "CharacterName",
 CellID->14018],

Cell["Unicode: 2227.", "Notes",
 CellID->18787],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["&&", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["and", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9905],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->17958],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[And]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "&&", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7391],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10202],

Cell[TextData[{
 "Drawn slightly larger than ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->3625]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26477],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->4414],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->9314],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->25824]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24372],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Or]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Nand]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nand"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Not]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Not"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20159]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->322934027],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[And] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 58.1608258}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2227. Aliases: Esc && Esc, Esc and Esc. Infix operator with \
built-in evaluation rules. x && y is by default interpreted as And[x,y], \
equivalent to x&&y. Not the same as \\[Wedge]. Drawn slightly larger than \
\\[Wedge]. ", "synonyms" -> {"and"}, "title" -> "\\[And]", "type" -> 
    "Character Name", "uri" -> "ref/character/And"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2387, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3010, 84, 576, 19, 70, "CharacterImage",
 CellID->17586826],
Cell[3589, 105, 48, 1, 70, "CharacterName",
 CellID->14018],
Cell[3640, 108, 47, 1, 70, "Notes",
 CellID->18787],
Cell[3690, 111, 416, 15, 70, "Notes",
 CellID->9905],
Cell[4109, 128, 96, 3, 70, "Notes",
 CellID->17958],
Cell[4208, 133, 608, 25, 70, "Notes",
 CellID->7391],
Cell[4819, 160, 200, 7, 70, "Notes",
 CellID->10202],
Cell[5022, 169, 210, 7, 70, "Notes",
 CellID->3625]
}, Open  ]],
Cell[CellGroupData[{
Cell[5269, 181, 53, 1, 70, "TutorialsSection",
 CellID->26477],
Cell[5325, 184, 143, 3, 70, "Tutorials",
 CellID->4414],
Cell[5471, 189, 179, 5, 70, "Tutorials",
 CellID->9314],
Cell[5653, 196, 129, 3, 70, "Tutorials",
 CellID->25824]
}, Open  ]],
Cell[CellGroupData[{
Cell[5819, 204, 50, 1, 70, "SeeAlsoSection",
 CellID->24372],
Cell[5872, 207, 801, 23, 70, "SeeAlso",
 CellID->20159]
}, Open  ]],
Cell[CellGroupData[{
Cell[6710, 235, 58, 1, 70, "MoreAboutSection",
 CellID->322934027],
Cell[6771, 238, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6929, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

