(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7260,        240]
NotebookOptionsPosition[      5372,        179]
NotebookOutlinePosition[      6430,        209]
CellTagsIndexPosition[      6387,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[MeasuredAngle]" :> 
          Documentation`HelpLookup["paclet:ref/character/MeasuredAngle"], 
          "\\[SphericalAngle]" :> 
          Documentation`HelpLookup["paclet:ref/character/SphericalAngle"], 
          "\\[RightAngle]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightAngle"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[MeasuredAngle]\"\>", 
       2->"\<\"\\\\[SphericalAngle]\"\>", 
       3->"\<\"\\\\[RightAngle]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Angle]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Angle]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->94688140],

Cell["\\[Angle]", "CharacterName",
 CellID->1924],

Cell["Unicode: 2220.", "Notes",
 CellID->11023],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->29972],

Cell[TextData[{
 "Used in geometry to indicate an angle, as in the symbol ",
 Cell[BoxData[
  FormBox["\[Angle]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["ABC"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13061]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14181],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->31003],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22725],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[MeasuredAngle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/MeasuredAngle"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SphericalAngle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SphericalAngle"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightAngle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngle"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->13031]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->634593669],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Angle] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 58.3170798}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2220. Letter-like form. Used in geometry to indicate an angle, \
as in the symbol \\[Angle] ABC. ", "synonyms" -> {"angle"}, "title" -> 
    "\\[Angle]", "type" -> "Character Name", "uri" -> 
    "ref/character/Angle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 84, 580, 19, 70, "CharacterImage",
 CellID->94688140],
Cell[3528, 105, 49, 1, 70, "CharacterName",
 CellID->1924],
Cell[3580, 108, 47, 1, 70, "Notes",
 CellID->11023],
Cell[3630, 111, 59, 1, 70, "Notes",
 CellID->29972],
Cell[3692, 114, 228, 8, 70, "Notes",
 CellID->13061]
}, Open  ]],
Cell[CellGroupData[{
Cell[3957, 127, 53, 1, 70, "TutorialsSection",
 CellID->14181],
Cell[4013, 130, 163, 3, 70, "Tutorials",
 CellID->31003],
Cell[4179, 135, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4389, 143, 50, 1, 70, "SeeAlsoSection",
 CellID->22725],
Cell[4442, 146, 647, 18, 70, "SeeAlso",
 CellID->13031]
}, Open  ]],
Cell[CellGroupData[{
Cell[5126, 169, 58, 1, 70, "MoreAboutSection",
 CellID->634593669],
Cell[5187, 172, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5345, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

