(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8761,        285]
NotebookOptionsPosition[      6680,        219]
NotebookOutlinePosition[      7781,        249]
CellTagsIndexPosition[      7738,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ARing]" :> 
          Documentation`HelpLookup["paclet:ref/character/ARing"], "\\[Micro]" :> 
          Documentation`HelpLookup["paclet:ref/character/Micro"], 
          "\\[EmptySmallCircle]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptySmallCircle"], 
          "\\[HBar]" :> Documentation`HelpLookup["paclet:ref/character/HBar"],
           "\\[CapitalARing]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalARing"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ARing]\"\>", 
       2->"\<\"\\\\[Micro]\"\>", 3->"\<\"\\\\[EmptySmallCircle]\"\>", 
       4->"\<\"\\\\[HBar]\"\>", 
       5->"\<\"\\\\[CapitalARing]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Angstrom]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Angstrom]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->122885718],

Cell["\\[Angstrom]", "CharacterName",
 CellID->13694],

Cell["Unicode: 212B.", "Notes",
 CellID->2695],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Ang", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->21624],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->28019],

Cell[TextData[{
 "Unit corresponding to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], TraditionalForm]], "InlineMath"],
 " meters. "
}], "Notes",
 CellID->2125],

Cell[TextData[{
 "Not the same as the letter ",
 Cell[TextData[ButtonBox["\\[CapitalARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalARing"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->26576]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21694],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->22658],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4678],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ARing"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Micro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Micro"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySmallCircle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalARing"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22593]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->613009857],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Angstrom] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 58.4733338}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 212B. Alias: Esc Ang Esc. Letter-like form. Unit corresponding \
to 10^-10 meters. Not the same as the letter \\[CapitalARing]. ", 
    "synonyms" -> {"angstrom"}, "title" -> "\\[Angstrom]", "type" -> 
    "Character Name", "uri" -> "ref/character/Angstrom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2649, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3272, 88, 587, 19, 70, "CharacterImage",
 CellID->122885718],
Cell[3862, 109, 53, 1, 70, "CharacterName",
 CellID->13694],
Cell[3918, 112, 46, 1, 70, "Notes",
 CellID->2695],
Cell[3967, 115, 235, 9, 70, "Notes",
 CellID->21624],
Cell[4205, 126, 59, 1, 70, "Notes",
 CellID->28019],
Cell[4267, 129, 194, 8, 70, "Notes",
 CellID->2125],
Cell[4464, 139, 225, 7, 70, "Notes",
 CellID->26576]
}, Open  ]],
Cell[CellGroupData[{
Cell[4726, 151, 53, 1, 70, "TutorialsSection",
 CellID->21694],
Cell[4782, 154, 163, 3, 70, "Tutorials",
 CellID->22658],
Cell[4948, 159, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[5158, 167, 49, 1, 70, "SeeAlsoSection",
 CellID->4678],
Cell[5210, 170, 1063, 30, 70, "SeeAlso",
 CellID->22593]
}, Open  ]],
Cell[CellGroupData[{
Cell[6310, 205, 58, 1, 70, "MoreAboutSection",
 CellID->613009857],
Cell[6371, 208, 143, 2, 70, "MoreAbout"],
Cell[6517, 212, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6653, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

