(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9185,        307]
NotebookOptionsPosition[      6875,        235]
NotebookOutlinePosition[      8080,        266]
CellTagsIndexPosition[      8037,        263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"], 
          "Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>", 
       3->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawBackslash]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawBackslash"], 
          "\\[Colon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Colon"], 
          "\\[VerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalBar"], 
          "\\[Continuation]" :> 
          Documentation`HelpLookup["paclet:ref/character/Continuation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[RawBackslash]\"\>", 
       2->"\<\"\\\\[Colon]\"\>", 3->"\<\"\\\\[VerticalBar]\"\>", 
       4->"\<\"\\\\[Continuation]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Backslash]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Backslash]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->695809474],

Cell["\\[Backslash]", "CharacterName",
 CellID->8932],

Cell["Unicode: 2216.", "Notes",
 CellID->22296],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\\", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29855],

Cell["Infix operator. ", "Notes",
 CellID->12053],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Backslash]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Backslash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Backslash"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16962],

Cell["Used in mathematics for set difference. ", "Notes",
 CellID->3584],

Cell["Also used to separate arguments of elliptic functions. ", "Notes",
 CellID->29734],

Cell[TextData[{
 "Sometimes used to indicate ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " divides ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6654]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->16972],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->21457],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14369],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->1156133539]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2607],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawBackslash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawBackslash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Colon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Continuation]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Continuation"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->2483]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->122208033],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Backslash] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 6.3641608}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2216. Alias: Esc \\ Esc. Infix operator. x \\ y is by default \
interpreted as Backslash[x,y]. Used in mathematics for set difference. Also \
used to separate arguments of elliptic functions. Sometimes used to indicate \
x divides y. ", "synonyms" -> {"backslash"}, "title" -> "\\[Backslash]", 
    "type" -> "Character Name", "uri" -> "ref/character/Backslash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2576, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3199, 89, 589, 19, 70, "CharacterImage",
 CellID->695809474],
Cell[3791, 110, 53, 1, 70, "CharacterName",
 CellID->8932],
Cell[3847, 113, 47, 1, 70, "Notes",
 CellID->22296],
Cell[3897, 116, 234, 9, 70, "Notes",
 CellID->29855],
Cell[4134, 127, 49, 1, 70, "Notes",
 CellID->12053],
Cell[4186, 130, 504, 20, 70, "Notes",
 CellID->16962],
Cell[4693, 152, 72, 1, 70, "Notes",
 CellID->3584],
Cell[4768, 155, 88, 1, 70, "Notes",
 CellID->29734],
Cell[4859, 158, 209, 9, 70, "Notes",
 CellID->6654]
}, Open  ]],
Cell[CellGroupData[{
Cell[5105, 172, 53, 1, 70, "TutorialsSection",
 CellID->16972],
Cell[5161, 175, 163, 3, 70, "Tutorials",
 CellID->21457],
Cell[5327, 180, 129, 3, 70, "Tutorials",
 CellID->14369],
Cell[5459, 185, 192, 4, 70, "Tutorials",
 CellID->1156133539]
}, Open  ]],
Cell[CellGroupData[{
Cell[5688, 194, 49, 1, 70, "SeeAlsoSection",
 CellID->2607],
Cell[5740, 197, 852, 23, 70, "SeeAlso",
 CellID->2483]
}, Open  ]],
Cell[CellGroupData[{
Cell[6629, 225, 58, 1, 70, "MoreAboutSection",
 CellID->122208033],
Cell[6690, 228, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6848, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

