(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7317,        249]
NotebookOptionsPosition[      5297,        184]
NotebookOutlinePosition[      6378,        214]
CellTagsIndexPosition[      6335,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ARing]" :> 
          Documentation`HelpLookup["paclet:ref/character/ARing"], 
          "\\[Angstrom]" :> 
          Documentation`HelpLookup["paclet:ref/character/Angstrom"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[ARing]\"\>", 
       2->"\<\"\\\\[Angstrom]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalARing]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalARing]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->687248523],

Cell["\\[CapitalARing]", "CharacterName",
 CellID->26423],

Cell["Unicode: 00C5.", "Notes",
 CellID->30124671],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Ao", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->10866],

Cell["Letter. ", "Notes",
 CellID->17659],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->32498],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Angstrom]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Angstrom"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28486]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21196],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->7462],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1146],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ARing]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ARing"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Angstrom]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Angstrom"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18392]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->74699248],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalARing] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 15.2550134}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00C5. Alias: Esc Ao Esc. Letter. Included in ISO Latin-1. Not \
the same as \\[Angstrom]. ", "synonyms" -> {"capital a ring"}, "title" -> 
    "\\[CapitalARing]", "type" -> "Character Name", "uri" -> 
    "ref/character/CapitalARing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2186, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2809, 82, 595, 19, 70, "CharacterImage",
 CellID->687248523],
Cell[3407, 103, 57, 1, 70, "CharacterName",
 CellID->26423],
Cell[3467, 106, 50, 1, 70, "Notes",
 CellID->30124671],
Cell[3520, 109, 234, 9, 70, "Notes",
 CellID->10866],
Cell[3757, 120, 41, 1, 70, "Notes",
 CellID->17659],
Cell[3801, 123, 66, 1, 70, "Notes",
 CellID->32498],
Cell[3870, 126, 206, 7, 70, "Notes",
 CellID->28486]
}, Open  ]],
Cell[CellGroupData[{
Cell[4113, 138, 53, 1, 70, "TutorialsSection",
 CellID->21196],
Cell[4169, 141, 188, 4, 70, "Tutorials",
 CellID->7462],
Cell[4360, 147, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4570, 155, 49, 1, 70, "SeeAlsoSection",
 CellID->1146],
Cell[4622, 158, 393, 11, 70, "SeeAlso",
 CellID->18392]
}, Open  ]],
Cell[CellGroupData[{
Cell[5052, 174, 57, 1, 70, "MoreAboutSection",
 CellID->74699248],
Cell[5112, 177, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5270, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

